/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.kronecker;

import java.util.ArrayList;
import uk.ac.ed.inf.pepa.ctmc.abstraction.AggregationException;
import uk.ac.ed.inf.pepa.ctmc.abstraction.SequentialAbstraction;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.ShortArray;
import uk.ac.ed.inf.pepa.ctmc.kronecker.KroneckerDisplayAction;
import uk.ac.ed.inf.pepa.ctmc.kronecker.KroneckerDisplayModel;
import uk.ac.ed.inf.pepa.ctmc.kronecker.KroneckerDisplayPropertyMap;
import uk.ac.ed.inf.pepa.ctmc.kronecker.KroneckerDisplayState;
import uk.ac.ed.inf.pepa.ctmc.kronecker.KroneckerDisplayTransition;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.PropertyBank;

public class KroneckerDisplayComponent {
    private int componentID;
    private KroneckerDisplayState componentState;
    private KroneckerDisplayModel model;
    private ArrayList<KroneckerDisplayTransition> transitions;
    private SequentialAbstraction abstraction;
    private ShortArray actions;
    private KroneckerDisplayPropertyMap propertyMap;
    private ShortArray selectedStates;

    KroneckerDisplayComponent(int componentID, KroneckerDisplayState componentState, KroneckerDisplayModel model, PropertyBank propertyBank, SequentialAbstraction abstraction) {
        this.componentID = componentID;
        this.componentState = componentState;
        this.model = model;
        this.transitions = new ArrayList(20);
        this.abstraction = abstraction;
        this.actions = new ShortArray(10);
        this.propertyMap = new KroneckerDisplayPropertyMap(propertyBank, this, abstraction);
        this.selectedStates = new ShortArray(10);
    }

    public String getName() {
        return this.componentState.getLabel(false);
    }

    public int getComponentID() {
        return this.componentID;
    }

    public KroneckerDisplayPropertyMap getPropertyMap() {
        return this.propertyMap;
    }

    public void addTransition(short actionID, short state1, short state2, double rate) {
        KroneckerDisplayAction action;
        KroneckerDisplayState s2;
        KroneckerDisplayState s1 = this.model.getState(state1);
        KroneckerDisplayTransition transition = new KroneckerDisplayTransition(s1, s2 = this.model.getState(state2), action = new KroneckerDisplayAction(actionID, rate, this.model));
        if (!this.transitions.contains(transition)) {
            this.transitions.add(transition);
            this.actions.addNew(actionID);
        }
    }

    public short getAbstractState(KroneckerDisplayState state) {
        return this.abstraction.getAbstractState(state.getID());
    }

    public KroneckerDisplayState[] getAggregate(KroneckerDisplayState state) {
        short abstractState = this.getAbstractState(state);
        short[] concreteStates = this.abstraction.getConcreteStates(abstractState);
        KroneckerDisplayState[] aggregates = new KroneckerDisplayState[concreteStates.length];
        int i = 0;
        while (i < concreteStates.length) {
            aggregates[i] = this.model.getState(concreteStates[i]);
            ++i;
        }
        return aggregates;
    }

    public KroneckerDisplayTransition[] getTransitions() {
        KroneckerDisplayTransition[] transitionArray = new KroneckerDisplayTransition[this.transitions.size()];
        this.transitions.toArray(transitionArray);
        return transitionArray;
    }

    public KroneckerDisplayModel getModel() {
        return this.model;
    }

    public void selectState(KroneckerDisplayState state) {
        this.selectedStates.add(state.getID());
    }

    public void deselectState(KroneckerDisplayState state) {
        this.selectedStates.remove(state.getID());
    }

    public void clearSelection() {
        this.selectedStates.clear();
    }

    public boolean isSelected(KroneckerDisplayState state) {
        return this.selectedStates.contains(state.getID());
    }

    public void aggregateSelected() {
        block2: {
            try {
                this.disaggregateSelected();
                this.abstraction.aggregate(this.selectedStates.toArray());
            }
            catch (AggregationException aggregationException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public void disaggregateSelected() {
        short[] selected = this.selectedStates.toArray();
        int i = 0;
        while (i < selected.length) {
            this.abstraction.disaggregate(this.abstraction.getAbstractState(selected[i]));
            ++i;
        }
    }

    public int getNumActions() {
        return this.actions.size();
    }
}

