/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.kronecker.internal;

import java.util.ArrayList;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.MatrixEntry;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.actions.InternalAction;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.actions.InternalActionList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionTypes {
    private boolean multipleActionTypes = false;
    private InternalAction singleActionType = null;
    private InternalActionList[][] actionTypes = null;

    public ActionTypes() {
    }

    public ActionTypes(ActionTypes copy) {
        this.multipleActionTypes = copy.multipleActionTypes;
        this.singleActionType = copy.singleActionType;
        if (copy.actionTypes != null) {
            int size = copy.actionTypes.length;
            this.actionTypes = new InternalActionList[size][size];
            int i = 0;
            while (i < size) {
                int j = 0;
                while (j < size) {
                    if (copy.actionTypes[i][j] != null) {
                        this.actionTypes[i][j] = new InternalActionList(copy.actionTypes[i][j]);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void initActionTypes(AbstractMatrix probMatrix) {
        assert (probMatrix.isSquare());
        this.multipleActionTypes = true;
        int size = probMatrix.numRows();
        this.actionTypes = new InternalActionList[size][size];
        for (MatrixEntry transition : probMatrix) {
            InternalActionList actions2 = new InternalActionList();
            actions2.add(this.singleActionType);
            this.actionTypes[transition.row()][transition.column()] = actions2;
        }
    }

    public void addActionType(AbstractMatrix probMatrix, int index1, int index2, InternalAction action) {
        if (!this.multipleActionTypes) {
            if (this.singleActionType == null) {
                this.singleActionType = action;
            } else if (!this.singleActionType.equals(action)) {
                this.initActionTypes(probMatrix);
            }
        }
        if (this.multipleActionTypes) {
            if (this.actionTypes[index1][index2] == null) {
                this.actionTypes[index1][index2] = new InternalActionList();
            }
            this.actionTypes[index1][index2].add(action);
        }
    }

    public ArrayList<InternalAction> getActionTypes(int index1, int index2) {
        if (this.multipleActionTypes) {
            return this.actionTypes[index1][index2].getActions();
        }
        ArrayList<InternalAction> actions2 = new ArrayList<InternalAction>(1);
        actions2.add(this.singleActionType);
        return actions2;
    }

    public void notifySwap(int index1, int index2) {
        if (this.multipleActionTypes) {
            InternalActionList[] row1 = this.actionTypes[index1];
            InternalActionList[] row2 = this.actionTypes[index2];
            this.actionTypes[index1] = row2;
            this.actionTypes[index2] = row1;
            int j = 0;
            while (j < this.actionTypes.length) {
                InternalActionList actions2;
                InternalActionList actions1 = this.actionTypes[index1][j];
                this.actionTypes[index1][j] = actions2 = this.actionTypes[index2][j];
                this.actionTypes[index2][j] = actions1;
                ++j;
            }
        }
    }
}

