/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.kronecker.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import no.uib.cipr.matrix.sparse.FlexCompRowMatrix;
import uk.ac.ed.inf.pepa.DoNothingMonitor;
import uk.ac.ed.inf.pepa.IProgressMonitor;
import uk.ac.ed.inf.pepa.ctmc.ThroughputResult;
import uk.ac.ed.inf.pepa.ctmc.abstraction.SequentialAbstraction;
import uk.ac.ed.inf.pepa.ctmc.derivation.DerivationException;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.ISymbolGenerator;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.IntegerArray;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.OptimisedHashMap;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.State;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.Transition;
import uk.ac.ed.inf.pepa.ctmc.derivation.internal.hbf.AbstractStateSpace;
import uk.ac.ed.inf.pepa.ctmc.kronecker.IKroneckerStateSpace;
import uk.ac.ed.inf.pepa.ctmc.kronecker.KroneckerDisplayModel;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.AbstractKroneckerModel;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.KroneckerModel;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.AbstractCTMC;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.CSLModelChecker;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.CompositionalProperty;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.ModelCheckingLog;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.PropertyBank;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.ctmc.solution.internal.simple.Generator;

public class KroneckerStateSpace
extends AbstractStateSpace
implements IKroneckerStateSpace {
    private KroneckerModel kroneckerModel;
    private OptimisedHashMap stateSpace;
    private DerivationException generationError = null;
    private boolean generatedStateSpace = false;
    private short[] initialState;

    protected KroneckerStateSpace(ISymbolGenerator generator, KroneckerModel kroneckerModel) {
        super(generator, null, false, generator.getInitialState().length);
        assert (kroneckerModel != null);
        this.kroneckerModel = kroneckerModel;
        this.initialState = generator.getInitialState();
    }

    private KroneckerStateSpace(short[] initialState, ISymbolGenerator generator, KroneckerModel kroneckerModel) {
        super(generator, null, false, generator.getInitialState().length);
        assert (kroneckerModel != null);
        this.kroneckerModel = kroneckerModel;
        this.initialState = initialState;
    }

    private short[] getAbstractState(short[] state) {
        assert (state.length == this.kroneckerModel.numComponents());
        short[] abstractState = new short[state.length];
        int i = 0;
        while (i < state.length) {
            SequentialAbstraction abstraction = this.kroneckerModel.getAbstraction(i);
            abstractState[i] = abstraction.getAbstractState(state[i]);
            ++i;
        }
        return abstractState;
    }

    public KroneckerDisplayModel getDisplayModel() {
        return this.kroneckerModel.getDisplayModel();
    }

    public CSLModelChecker getModelChecker(OptionMap optionMap, IProgressMonitor monitor, double boundAccuracy) {
        ModelCheckingLog eventLog = new ModelCheckingLog();
        PropertyBank propertyBank = this.kroneckerModel.getPropertyBank();
        AbstractCTMC abstractCTMC = this.getAbstractCTMC(propertyBank, eventLog);
        SequentialAbstraction[] abstraction = this.kroneckerModel.getAbstraction();
        CSLModelChecker modelChecker = new CSLModelChecker(this, abstractCTMC, abstraction, optionMap, monitor, boundAccuracy, eventLog);
        return modelChecker;
    }

    private AbstractCTMC getAbstractCTMC(PropertyBank propertyBank, ModelCheckingLog eventLog) {
        AbstractKroneckerModel abstractModel = this.kroneckerModel.getAbstractModel();
        short[] abstractInitialState = this.getAbstractState(this.initialState);
        return new AbstractCTMC(abstractInitialState, abstractModel, propertyBank, eventLog);
    }

    private KroneckerStateSpace makeBound(KroneckerModel boundingModel, short[] newInitialState) {
        if (boundingModel == this.kroneckerModel) {
            return this;
        }
        if (newInitialState == null) {
            newInitialState = this.getAbstractState(this.initialState);
        }
        return new KroneckerStateSpace(newInitialState, this.symbolGenerator, boundingModel);
    }

    public KroneckerStateSpace getUpperBoundingStateSpace(CompositionalProperty property) {
        KroneckerModel boundingModel = this.kroneckerModel.getUpperBoundingModel(property);
        return this.makeBound(boundingModel, property.anyTrueState());
    }

    public KroneckerStateSpace getLowerBoundingStateSpace(CompositionalProperty property) {
        KroneckerModel boundingModel = this.kroneckerModel.getLowerBoundingModel(property);
        return this.makeBound(boundingModel, property.anyFalseState());
    }

    private boolean addState(short[] state) {
        int hashCode = Arrays.hashCode(state);
        OptimisedHashMap.InsertionResult result = this.stateSpace.putIfNotPresentUnsync(state, hashCode);
        if (!result.wasPresent) {
            this.states.add(result.state);
        }
        return result.wasPresent;
    }

    private State getState(short[] state) {
        int hashCode = Arrays.hashCode(state);
        return this.stateSpace.putIfNotPresentUnsync((short[])state, (int)hashCode).state;
    }

    public short[] getSystemState(int index) {
        return ((State)this.states.get((int)index)).fState;
    }

    private void initStateSpace() {
        this.states = new ArrayList(1000);
        this.stateSpace = new OptimisedHashMap(1000);
        this.generatedStateSpace = false;
    }

    private void generateStateSpace() {
        this.initStateSpace();
        short[] state = this.initialState;
        this.addState(state);
        LinkedList<short[]> queue = new LinkedList<short[]>();
        queue.add(state);
        try {
            while (!queue.isEmpty()) {
                state = (short[])queue.remove();
                ArrayList<Transition> found = this.kroneckerModel.getTransitionsFrom(state);
                for (Transition t : found) {
                    short[] s = t.fTargetProcess;
                    if (this.addState(s)) continue;
                    queue.add(s);
                }
            }
            this.generatedStateSpace = true;
            this.generationError = null;
        }
        catch (DerivationException e) {
            this.generatedStateSpace = false;
            this.generationError = e;
        }
    }

    public DerivationException getDerivationException() {
        return this.generationError;
    }

    protected FlexCompRowMatrix createGeneratorMatrix() {
        if (!this.generatedStateSpace && this.generationError == null) {
            this.generateStateSpace();
        }
        if (this.generationError != null) {
            return null;
        }
        FlexCompRowMatrix Q = new FlexCompRowMatrix(this.size(), this.size());
        int i = 0;
        while (i < this.size()) {
            ArrayList<Transition> transitions;
            block6: {
                State s = (State)this.states.get(i);
                transitions = null;
                try {
                    transitions = this.kroneckerModel.getTransitionsFrom(s.fState);
                }
                catch (DerivationException derivationException) {
                    if ($assertionsDisabled) break block6;
                    throw new AssertionError();
                }
            }
            for (Transition t : transitions) {
                short[] target = t.fTargetProcess;
                int target_index = this.getState((short[])target).stateNumber;
                double rate = t.fRate;
                Q.add(i, target_index, rate);
                Q.add(i, i, -rate);
            }
            ++i;
        }
        return Q;
    }

    protected Generator createSimpleGenerator() {
        return null;
    }

    protected void doThroughput(IProgressMonitor monitor) {
        this.throughput = EMPTY_THROUGHPUT;
        if (monitor == null) {
            monitor = new DoNothingMonitor();
        }
        if (this.solution == null) {
            monitor.done();
            return;
        }
        HashMap<Short, Double> throughputMap = new HashMap<Short, Double>();
        int i = 0;
        int size = this.size();
        while (i < size) {
            ArrayList transitions;
            double steadyStateProb;
            block8: {
                steadyStateProb = this.solution[i];
                State state = (State)this.states.get(i);
                transitions = null;
                try {
                    this.kroneckerModel.getTransitionsFrom(state.fState);
                }
                catch (DerivationException derivationException) {
                    if ($assertionsDisabled) break block8;
                    throw new AssertionError();
                }
            }
            for (Transition t : transitions) {
                Double throughput = (Double)throughputMap.get(t.fActionId);
                if (throughput == null) {
                    throughput = 0.0;
                }
                throughput = throughput + steadyStateProb * t.fRate;
                throughputMap.put(t.fActionId, throughput);
            }
            ++i;
        }
        ThroughputResult[] result = new ThroughputResult[throughputMap.size()];
        int i2 = 0;
        for (Map.Entry entry : throughputMap.entrySet()) {
            ThroughputResult r = new ThroughputResult(this.symbolGenerator.getActionLabel((Short)entry.getKey()), (Double)entry.getValue());
            result[i2++] = r;
        }
        this.throughput = result;
        monitor.done();
    }

    public String[] getAction(int source, int target) {
        ArrayList<Transition> transitions;
        ArrayList<String> actions2;
        block5: {
            if (!this.generatedStateSpace && this.generationError == null) {
                this.generateStateSpace();
            }
            if (this.generationError != null) {
                return null;
            }
            short[] source_state = ((State)this.states.get((int)source)).fState;
            actions2 = new ArrayList<String>(10);
            transitions = null;
            try {
                transitions = this.kroneckerModel.getTransitionsFrom(source_state);
            }
            catch (DerivationException derivationException) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError();
            }
        }
        for (Transition t : transitions) {
            String action_type;
            if (this.getState((short[])t.fTargetProcess).stateNumber != target || actions2.contains(action_type = this.symbolGenerator.getActionLabel(t.fActionId))) continue;
            actions2.add(action_type);
        }
        return actions2.size() > 0 ? (String[])actions2.toArray() : null;
    }

    public int[] getIncomingStateIndices(int stateIndex) {
        if (!this.generatedStateSpace) {
            this.generateStateSpace();
        }
        short[] state = ((State)this.states.get((int)stateIndex)).fState;
        IntegerArray indices = new IntegerArray(10);
        ArrayList<Transition> transitions = this.kroneckerModel.getTransitionsTo(state);
        for (Transition t : transitions) {
            short[] prevState = t.fTargetProcess;
            int prevStateIndex = this.getState((short[])prevState).stateNumber;
            indices.addNew(prevStateIndex);
        }
        return indices.toArray();
    }

    public int[] getOutgoingStateIndices(int stateIndex) {
        ArrayList transitions;
        IntegerArray indices;
        block5: {
            if (!this.generatedStateSpace && this.generationError == null) {
                this.generateStateSpace();
            }
            if (this.generationError != null) {
                return null;
            }
            short[] state = ((State)this.states.get((int)stateIndex)).fState;
            indices = new IntegerArray(10);
            transitions = null;
            try {
                this.kroneckerModel.getTransitionsFrom(state);
            }
            catch (DerivationException derivationException) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError();
            }
        }
        for (Transition t : transitions) {
            short[] nextState = t.fTargetProcess;
            int nextStateIndex = this.getState((short[])nextState).stateNumber;
            indices.addNew(nextStateIndex);
        }
        return indices.toArray();
    }

    public double getRate(int source, int target) {
        ArrayList transitions;
        block5: {
            if (!this.generatedStateSpace && this.generationError == null) {
                this.generateStateSpace();
            }
            if (this.generationError != null) {
                return -1.0;
            }
            short[] source_state = ((State)this.states.get((int)source)).fState;
            transitions = null;
            try {
                this.kroneckerModel.getTransitionsFrom(source_state);
            }
            catch (DerivationException derivationException) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError();
            }
        }
        double rate = 0.0;
        for (Transition t : transitions) {
            if (this.getState((short[])t.fTargetProcess).stateNumber != target) continue;
            rate += t.fRate;
        }
        return rate;
    }

    public void dispose() {
    }

    public int size() {
        return this.states == null ? 0 : this.states.size();
    }

    public String toString() {
        return this.kroneckerModel.toString();
    }
}

