/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.kronecker.internal;

import uk.ac.ed.inf.pepa.ctmc.derivation.DerivationException;

public class KroneckerUtilities {
    public static double rateMin(double r1, double r2) {
        if (r1 >= 0.0 && r2 >= 0.0) {
            return Math.min(r1, r2);
        }
        if (r1 < 0.0 && r2 >= 0.0) {
            return r2;
        }
        if (r1 >= 0.0 && r2 < 0.0) {
            return r1;
        }
        assert (r1 == r2);
        return r1;
    }

    public static double ratePlus(double r1, double r2) throws DerivationException {
        if (r1 >= 0.0 && r2 >= 0.0) {
            return r1 + r2;
        }
        if (r1 < 0.0 && r2 < 0.0) {
            assert (r1 == r2);
            return r1;
        }
        throw new DerivationException("Mixing active and passive rates");
    }

    public static void incrementArray(int[] current, int[] max) {
        int index = 0;
        int i = current.length - 1;
        while (i >= 0) {
            if (current[i] < max[i] - 1) {
                int n = i;
                current[n] = current[n] + 1;
                index = i;
                break;
            }
            --i;
        }
        i = index + 1;
        while (i < current.length) {
            current[i] = 0;
            ++i;
        }
    }

    public static void incrementBooleanArray(boolean[] current) {
        int index = 0;
        int i = current.length - 1;
        while (i >= 0) {
            if (!current[i]) {
                current[i] = true;
                index = i;
                break;
            }
            --i;
        }
        i = index + 1;
        while (i < current.length) {
            current[i] = false;
            ++i;
        }
    }
}

