/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.kronecker.internal.actions;

import uk.ac.ed.inf.pepa.ctmc.derivation.DerivationException;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.KroneckerUtilities;

public class ApparentRateCalculator {
    private Operator operator;

    public ApparentRateCalculator() {
        this.operator = new LeafOperator();
    }

    private ApparentRateCalculator(Operator operator) {
        this.operator = operator;
    }

    public ApparentRateCalculator plus(ApparentRateCalculator calculator) {
        return new ApparentRateCalculator(new PlusOperator(this.operator, calculator.operator));
    }

    public ApparentRateCalculator min(ApparentRateCalculator calculator) {
        return new ApparentRateCalculator(new MinOperator(this.operator, calculator.operator));
    }

    public double compute(double[] rates) throws DerivationException {
        assert (rates.length == this.operator.size());
        return this.operator.compute(rates);
    }

    private static class LeafOperator
    extends Operator {
        LeafOperator() {
        }

        protected double compute(double[] rates) throws DerivationException {
            return rates[this.offset];
        }
    }

    private static class MinOperator
    extends Operator {
        MinOperator(Operator left, Operator right) {
            super(left, right);
        }

        protected double compute(double[] rates) throws DerivationException {
            double left = this.leftOperator.compute(rates);
            double right = this.rightOperator.compute(rates);
            return KroneckerUtilities.rateMin(left, right);
        }
    }

    private static abstract class Operator {
        protected int offset = 0;
        protected int leftComponents;
        protected int rightComponents;
        protected Operator leftOperator;
        protected Operator rightOperator;

        Operator(Operator left, Operator right) {
            this.leftOperator = left;
            this.leftComponents = left == null ? 0 : left.size();
            this.rightOperator = right;
            this.rightComponents = right == null ? 0 : right.size();
            this.setOffset(0);
        }

        Operator() {
            this.leftComponents = 1;
            this.rightComponents = 0;
            this.leftOperator = null;
            this.rightOperator = null;
        }

        protected abstract double compute(double[] var1) throws DerivationException;

        private void setOffset(int offset) {
            this.offset = offset;
            int leftSize = 0;
            if (this.leftOperator != null) {
                this.leftOperator.setOffset(offset);
                leftSize = this.leftOperator.size();
            }
            if (this.rightOperator != null) {
                this.rightOperator.setOffset(offset + leftSize);
            }
        }

        private int size() {
            return this.leftComponents + this.rightComponents;
        }
    }

    private static class PlusOperator
    extends Operator {
        PlusOperator(Operator left, Operator right) {
            super(left, right);
        }

        protected double compute(double[] rates) throws DerivationException {
            double left = this.leftOperator.compute(rates);
            double right = this.rightOperator.compute(rates);
            return KroneckerUtilities.ratePlus(left, right);
        }
    }
}

