/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.kronecker.internal.actions;

import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.ISymbolGenerator;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.actions.ApparentRateCalculator;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.actions.InternalAction;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.actions.InternalActionList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KroneckerActionManager {
    private ISymbolGenerator generator;
    private int numComponents;
    private HashMap<InternalAction, Short> syncActionMap;
    private HashMap<Short, ArrayList<Short>> reverseSyncActionMap;
    private HashMap<Short, ApparentRateCalculator> apparentRateCalculators;
    private ArrayList<HashMap<Short, InternalActionList>> componentActions;

    public KroneckerActionManager(ISymbolGenerator generator) {
        this.numComponents = generator.getInitialState().length;
        this.generator = generator;
        this.syncActionMap = new HashMap(20);
        this.reverseSyncActionMap = new HashMap(20);
        this.apparentRateCalculators = new HashMap(20);
        this.componentActions = new ArrayList(this.numComponents);
        int i = 0;
        while (i < this.numComponents) {
            this.componentActions.add(new HashMap());
            ++i;
        }
    }

    public void addActionType(int component, short actionID) {
        if (!this.componentActions.get(component).containsKey(actionID)) {
            InternalActionList actionList = new InternalActionList(actionID);
            InternalAction action = new InternalAction(actionID, component, this.numComponents);
            actionList.add(action);
            this.componentActions.get(component).put(actionID, actionList);
        }
    }

    public String getActionName(InternalAction action) {
        return this.generator.getActionLabel(action.getID());
    }

    public short getActionID(InternalAction action) {
        Short actionID = this.syncActionMap.get(action);
        if (actionID == null) {
            return -1;
        }
        return actionID;
    }

    public String getActionName(int actionIndex) {
        for (Map.Entry<InternalAction, Short> entry : this.syncActionMap.entrySet()) {
            if (entry.getValue().intValue() != actionIndex) continue;
            return String.valueOf(this.getActionName(entry.getKey())) + "(" + actionIndex + ")";
        }
        return "Don't know";
    }

    public InternalActionList getActions(int component, short actionID) {
        return this.componentActions.get(component).get(actionID);
    }

    public void merge(Point components1, Point components2, short actionID) {
        HashMap<Integer, InternalActionList> componentActions2 = new HashMap<Integer, InternalActionList>(10);
        int component2 = components2.x;
        while (component2 <= components2.y) {
            componentActions2.put(component2, new InternalActionList(actionID));
            ++component2;
        }
        int component1 = components1.x;
        while (component1 <= components1.y) {
            InternalActionList newActionList1 = new InternalActionList(actionID);
            int component22 = components2.x;
            while (component22 <= components2.y) {
                InternalActionList newActionList2 = (InternalActionList)componentActions2.get(component22);
                InternalActionList actionList1 = this.componentActions.get(component1).get(actionID);
                InternalActionList actionList2 = this.componentActions.get(component22).get(actionID);
                if (actionList1 != null && actionList2 != null) {
                    InternalActionList syncActionList = actionList1.synchronise(actionList2);
                    newActionList1.add(syncActionList);
                    newActionList2.add(syncActionList);
                }
                ++component22;
            }
            this.componentActions.get(component1).put(actionID, newActionList1);
            ++component1;
        }
        component2 = components2.x;
        while (component2 <= components2.y) {
            InternalActionList newActionList = (InternalActionList)componentActions2.get(component2);
            this.componentActions.get(component2).put(actionID, newActionList);
            ++component2;
        }
    }

    public void indexActions() {
        short actionID = 0;
        this.syncActionMap.clear();
        for (HashMap<Short, InternalActionList> actions2 : this.componentActions) {
            for (InternalActionList actionList : actions2.values()) {
                for (InternalAction action : actionList) {
                    if (action.isLocal() || this.syncActionMap.containsKey(action)) continue;
                    short s = actionID;
                    actionID = (short)(s + 1);
                    this.syncActionMap.put(action, s);
                }
            }
        }
        this.reverseIndexActions();
    }

    private void reverseIndexActions() {
        this.reverseSyncActionMap.clear();
        for (Map.Entry<InternalAction, Short> entry : this.syncActionMap.entrySet()) {
            ArrayList<Object> internalIDs;
            short internalID = entry.getValue();
            short externalID = entry.getKey().getID();
            if (!this.reverseSyncActionMap.containsKey(externalID)) {
                internalIDs = new ArrayList<Short>();
                internalIDs.add(internalID);
                this.reverseSyncActionMap.put(externalID, internalIDs);
                continue;
            }
            internalIDs = this.reverseSyncActionMap.get(externalID);
            assert (!internalIDs.contains(internalID));
            internalIDs.add(internalID);
        }
    }

    public Set<Map.Entry<Short, ArrayList<Short>>> getExternalActions() {
        return this.reverseSyncActionMap.entrySet();
    }

    public void addApparentRateCalculator(short actionID, ApparentRateCalculator calculator) {
        this.apparentRateCalculators.put(actionID, calculator);
    }

    public ApparentRateCalculator getApparentRateCalculator(short actionID) {
        return this.apparentRateCalculators.get(actionID);
    }

    public int getNumSyncActions() {
        return this.syncActionMap.size();
    }
}

