/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.kronecker.internal.stochasticbounds;

import java.awt.Point;
import no.uib.cipr.matrix.AbstractVector;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.SparseVector;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.Rate;

public class ComponentRateContext {
    private AbstractVector lowerRates;
    private AbstractVector originalRates;
    private AbstractVector upperRates;
    private double lowerInternalBound;
    private double upperInternalBound;
    private double lowerComparativeBound;
    private double upperComparativeBound;

    public ComponentRateContext(AbstractVector lowerRates, AbstractVector originalRates, AbstractVector upperRates, double lowerInternalBound, double upperInternalBound, double lowerComparativeBound, double upperComparativeBound) {
        this.lowerRates = lowerRates;
        this.originalRates = originalRates;
        this.upperRates = upperRates;
        this.lowerInternalBound = lowerInternalBound;
        this.upperInternalBound = upperInternalBound;
        this.lowerComparativeBound = lowerComparativeBound;
        this.upperComparativeBound = upperComparativeBound;
    }

    public SparseVector getLowerRateVector() {
        assert (this.lowerRates != null);
        return new SparseVector((Vector)this.lowerRates);
    }

    public SparseVector getUpperRateVector() {
        assert (this.upperRates != null);
        return new SparseVector((Vector)this.upperRates);
    }

    public double getLowerRate(Point block) {
        if (this.lowerRates == null) {
            return -1.0;
        }
        double lowerRate = this.lowerRates.get(block.x);
        int i = block.x + 1;
        while (i <= block.y) {
            lowerRate = Rate.min(lowerRate, this.lowerRates.get(i));
            ++i;
        }
        return lowerRate;
    }

    public double getUpperRate(Point block) {
        if (this.upperRates == null) {
            return -1.0;
        }
        double upperRate = this.upperRates.get(block.x);
        int i = block.x + 1;
        while (i <= block.y) {
            upperRate = Rate.max(upperRate, this.upperRates.get(i));
            ++i;
        }
        return upperRate;
    }

    private double getLowerOriginalRate(Point block) {
        double lowerRate = this.originalRates.get(block.x);
        int i = block.x + 1;
        while (i <= block.y) {
            lowerRate = Rate.min(lowerRate, this.originalRates.get(i));
            ++i;
        }
        return lowerRate;
    }

    private double getUpperOriginalRate(Point block) {
        double upperRate = this.originalRates.get(block.x);
        int i = block.x + 1;
        while (i <= block.y) {
            upperRate = Rate.max(upperRate, this.originalRates.get(i));
            ++i;
        }
        return upperRate;
    }

    public double getUpperRatio(Point block) {
        if (this.originalRates == null) {
            return 1.0;
        }
        double lowerOriginalRate = this.getLowerOriginalRate(block);
        double upperRate = this.getUpperRate(block);
        assert (Rate.max(lowerOriginalRate, upperRate) == upperRate);
        if (upperRate == 0.0) {
            return 0.0;
        }
        return lowerOriginalRate / upperRate;
    }

    public double getLowerRatio(Point block) {
        if (this.originalRates == null) {
            return 1.0;
        }
        double upperOriginalRate = this.getUpperOriginalRate(block);
        double lowerRate = this.getLowerRate(block);
        assert (Rate.max(lowerRate, upperOriginalRate) == upperOriginalRate);
        if (upperOriginalRate == 0.0) {
            return 0.0;
        }
        return lowerRate / upperOriginalRate;
    }

    public double getLowerInternalBound() {
        return this.lowerInternalBound;
    }

    public double getUpperInternalBound() {
        return this.upperInternalBound;
    }

    public double getLowerComparativeBound() {
        return this.lowerComparativeBound;
    }

    public double getUpperComparativeBound() {
        return this.upperComparativeBound;
    }
}

