/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.kronecker.internal.stochasticbounds;

import uk.ac.ed.inf.pepa.ctmc.abstraction.AbstractState;
import uk.ac.ed.inf.pepa.ctmc.abstraction.SequentialAbstraction;

public class PartitionIndices {
    private int[] indices;

    public PartitionIndices(SequentialAbstraction abstraction) {
        AbstractState[] partitions = abstraction.getAbstractStateSpace();
        this.indices = new int[partitions.length + 1];
        this.indices[0] = 0;
        int k = 0;
        while (k < partitions.length) {
            this.indices[k + 1] = this.indices[k] + partitions[k].size();
            ++k;
        }
    }

    public int getStart(int partition) {
        return this.indices[partition];
    }

    public int getEnd(int partition) {
        return this.indices[partition + 1] - 1;
    }

    public int getLength(int partition) {
        return this.indices[partition + 1] - this.indices[partition];
    }

    public int size() {
        return this.indices.length - 1;
    }
}

