/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.kronecker.internal.stochasticbounds;

import java.awt.Point;
import java.util.ArrayList;
import no.uib.cipr.matrix.AbstractVector;
import no.uib.cipr.matrix.sparse.SparseVector;
import uk.ac.ed.inf.pepa.ctmc.abstraction.SequentialAbstraction;
import uk.ac.ed.inf.pepa.ctmc.abstraction.SequentialOrder;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.ActionTypes;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.Rate;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.stochasticbounds.ComponentRateContext;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.stochasticbounds.PartitionIndices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RateContext {
    private ArrayList<SparseVector> upperRates;
    private ArrayList<SparseVector> originalRates;
    private ArrayList<SparseVector> lowerRates;
    private ArrayList<Double> lowerInternalRateMeasures;
    private ArrayList<Double> upperInternalRateMeasures;
    private ArrayList<Double> lowerComparativeRateMeasures;
    private ArrayList<Double> upperComparativeRateMeasures;
    private int numComponents;

    private RateContext(int numComponents) {
        this.numComponents = numComponents;
        this.upperRates = new ArrayList(numComponents);
        this.originalRates = new ArrayList(numComponents);
        this.lowerRates = new ArrayList(numComponents);
        this.lowerInternalRateMeasures = new ArrayList(numComponents);
        this.upperInternalRateMeasures = new ArrayList(numComponents);
        this.lowerComparativeRateMeasures = new ArrayList(numComponents);
        this.upperComparativeRateMeasures = new ArrayList(numComponents);
    }

    public static RateContext[] makeNewContext(int numComponents, int numSyncActions) {
        RateContext[] context = new RateContext[numSyncActions];
        int i = 0;
        while (i < numSyncActions) {
            context[i] = new RateContext(numComponents);
            ++i;
        }
        return context;
    }

    private double getMaxRateBlock(SparseVector rateVector, int start, int end) {
        double max = 0.0;
        int i = start;
        while (i <= end) {
            double current = rateVector.get(i);
            max = Rate.max(max, current);
            ++i;
        }
        return max;
    }

    private double getMinRateBlock(SparseVector rateVector, int start, int end) {
        double min = -1.0;
        int i = start;
        while (i <= end) {
            double current = rateVector.get(i);
            min = Rate.min(min, current);
            ++i;
        }
        return min;
    }

    private SparseVector upperBoundRateVector(SparseVector rateVector, SequentialOrder order) {
        SparseVector upperBound = new SparseVector(rateVector.size());
        double previous_maximum = 0.0;
        double current_maximum = 0.0;
        int i = 0;
        while (i < rateVector.size()) {
            if (order.isComparableIndex(i)) {
                previous_maximum = current_maximum;
            }
            double newRate = Rate.max(previous_maximum, rateVector.get(i));
            current_maximum = Rate.max(current_maximum, newRate);
            upperBound.set(i, newRate);
            ++i;
        }
        return upperBound;
    }

    private SparseVector lowerBoundRateVector(SparseVector rateVector, SequentialOrder order) {
        SparseVector lowerBound = new SparseVector(rateVector.size());
        double previous_minimum = -1.0;
        double current_minimum = -1.0;
        int i = 0;
        while (i < rateVector.size()) {
            if (order.isComparableIndex(i)) {
                previous_minimum = current_minimum;
            }
            double newRate = Rate.min(previous_minimum, rateVector.get(i));
            current_minimum = Rate.min(current_minimum, newRate);
            lowerBound.set(i, newRate);
            ++i;
        }
        return lowerBound;
    }

    private void makeLumpable(boolean maximise, SparseVector rateVector, PartitionIndices partitions) {
        int k = 0;
        while (k < partitions.size()) {
            int start = partitions.getStart(k);
            int end = partitions.getEnd(k);
            double newRate = maximise ? this.getMaxRateBlock(rateVector, start, end) : this.getMinRateBlock(rateVector, start, end);
            int i = start;
            while (i <= end) {
                rateVector.set(i, newRate);
                ++i;
            }
            ++k;
        }
    }

    private void checkLumpable(SparseVector rateVector, PartitionIndices partitions) {
        int k = 0;
        while (k < partitions.size()) {
            int start = partitions.getStart(k);
            int end = partitions.getEnd(k);
            double rate = rateVector.get(start);
            int i = start;
            while (i <= end) {
                assert (rate == rateVector.get(i));
                ++i;
            }
            ++k;
        }
    }

    private double divideRate(double rate1, double rate2) {
        if (rate1 == rate2) {
            return 1.0;
        }
        if (rate1 >= 0.0 && rate2 < 0.0) {
            return 0.0;
        }
        assert (rate2 != 0.0);
        return rate1 / rate2;
    }

    private double internalRateMeasure(SparseVector rateVector, SequentialOrder order) {
        double internalRateMeasure = 1.0;
        double previousMinimum = 0.0;
        double currentMinimum = 0.0;
        int i = 0;
        while (i < rateVector.size()) {
            if (order.isComparableIndex(i)) {
                Point currentBlock = order.getCurrent(i);
                previousMinimum = currentMinimum;
                currentMinimum = this.getMinRateBlock(rateVector, currentBlock.x, currentBlock.y);
                assert (Rate.min(previousMinimum, currentMinimum) == previousMinimum);
                double currentMaximum = this.getMaxRateBlock(rateVector, currentBlock.x, currentBlock.y);
                if (i > 0) {
                    double ratio = this.divideRate(previousMinimum, currentMaximum);
                    internalRateMeasure = Math.min(internalRateMeasure, ratio);
                }
            }
            ++i;
        }
        return internalRateMeasure;
    }

    private double reverseInternalRateMeasure(SparseVector rateVector, SequentialOrder order) {
        double internalRateMeasure = 1.0;
        double previousMinimum = 0.0;
        double currentMinimum = 0.0;
        int i = rateVector.size() - 1;
        while (i >= 0) {
            if (order.isComparableIndex(i)) {
                Point currentBlock = order.getCurrent(i);
                previousMinimum = currentMinimum;
                currentMinimum = this.getMinRateBlock(rateVector, currentBlock.x, currentBlock.y);
                assert (Rate.min(previousMinimum, currentMinimum) == previousMinimum);
                double currentMaximum = this.getMaxRateBlock(rateVector, currentBlock.x, currentBlock.y);
                if (i > 0) {
                    double ratio = this.divideRate(previousMinimum, currentMaximum);
                    internalRateMeasure = Math.min(internalRateMeasure, ratio);
                }
            }
            --i;
        }
        return internalRateMeasure;
    }

    private double comparativeRateMeasure(SparseVector lowerVector, SparseVector upperVector) {
        double comparativeRateMeasure = 1.0;
        int i = 0;
        while (i < lowerVector.size()) {
            double ratio = this.divideRate(lowerVector.get(i), upperVector.get(i));
            assert (ratio >= 0.0);
            comparativeRateMeasure = Math.min(comparativeRateMeasure, ratio);
            ++i;
        }
        return comparativeRateMeasure;
    }

    private void upperBoundRate(int componentID, SparseVector rateVector, SequentialAbstraction abstraction, SequentialOrder order) {
        PartitionIndices partitions = new PartitionIndices(abstraction);
        SparseVector upperBound = !order.isAnythingComparable() ? rateVector.copy() : this.upperBoundRateVector(rateVector, order);
        this.makeLumpable(true, upperBound, partitions);
        double comparativeRateMeasure = this.comparativeRateMeasure(rateVector, upperBound);
        double internalRateMeasure = this.internalRateMeasure(upperBound, order);
        assert (componentID == this.upperRates.size());
        this.upperRates.add(upperBound);
        this.upperInternalRateMeasures.add(internalRateMeasure);
        this.upperComparativeRateMeasures.add(comparativeRateMeasure);
    }

    private void lowerBoundRate(int componentID, SparseVector rateVector, SequentialAbstraction abstraction, SequentialOrder order) {
        PartitionIndices partitions = new PartitionIndices(abstraction);
        SparseVector lowerBound = !order.isAnythingComparable() ? rateVector.copy() : this.lowerBoundRateVector(rateVector, order);
        this.makeLumpable(false, lowerBound, partitions);
        double comparativeRateMeasure = this.comparativeRateMeasure(lowerBound, rateVector);
        double internalRateMeasure = this.reverseInternalRateMeasure(lowerBound, order);
        assert (componentID == this.lowerRates.size());
        this.lowerRates.add(lowerBound);
        this.lowerInternalRateMeasures.add(internalRateMeasure);
        this.lowerComparativeRateMeasures.add(comparativeRateMeasure);
    }

    public void addComponent(int componentID, SparseVector rateVector, ActionTypes actionTypes, SequentialAbstraction abstraction, SequentialOrder order) {
        this.upperBoundRate(componentID, rateVector, abstraction, order);
        this.lowerBoundRate(componentID, rateVector, abstraction, order);
        assert (componentID == this.originalRates.size());
        this.originalRates.add(rateVector);
    }

    public void addEmptyComponent(int componentID, ActionTypes actionTypes) {
        assert (componentID == this.originalRates.size());
        this.lowerRates.add(null);
        this.upperRates.add(null);
        this.originalRates.add(null);
        this.upperComparativeRateMeasures.add(null);
        this.lowerComparativeRateMeasures.add(null);
        this.upperInternalRateMeasures.add(null);
        this.lowerInternalRateMeasures.add(null);
    }

    private double computeBound(int component, ArrayList<Double> measures) {
        double bound = 1.0;
        int i = 0;
        while (i < this.numComponents) {
            Double measure;
            if (component != i && (measure = measures.get(i)) != null) {
                bound = Math.min(bound, measure);
            }
            ++i;
        }
        return bound;
    }

    public ComponentRateContext getRateContext(int component) {
        double lowerInternalBound = this.computeBound(component, this.lowerInternalRateMeasures);
        double upperInternalBound = this.computeBound(component, this.upperInternalRateMeasures);
        double lowerComparativeBound = this.computeBound(component, this.lowerComparativeRateMeasures);
        double upperComparativeBound = this.computeBound(component, this.upperComparativeRateMeasures);
        return new ComponentRateContext((AbstractVector)this.lowerRates.get(component), (AbstractVector)this.originalRates.get(component), (AbstractVector)this.upperRates.get(component), lowerInternalBound, upperInternalBound, lowerComparativeBound, upperComparativeBound);
    }
}

