/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.kronecker.internal.stochasticbounds;

import java.awt.Point;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.sparse.FlexCompRowMatrix;
import uk.ac.ed.inf.pepa.ctmc.abstraction.SequentialAbstraction;
import uk.ac.ed.inf.pepa.ctmc.abstraction.SequentialOrder;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.stochasticbounds.ComponentRateContext;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.stochasticbounds.PartitionIndices;

public class StochasticBoundsRateWise {
    private static double rate_ratio(double rate1, double rate2) {
        if (rate2 == 0.0) {
            assert (rate1 == 0.0);
            return 0.0;
        }
        return rate1 / rate2;
    }

    private static double truncate(double probability) {
        return Math.max(0.0, Math.min(1.0, probability));
    }

    private static double matrix_sum(AbstractMatrix M, int row, int start_column, int end_column) {
        double sum = 0.0;
        int j = start_column;
        while (j <= end_column) {
            sum += M.get(row, j);
            ++j;
        }
        return StochasticBoundsRateWise.truncate(sum);
    }

    private static double max_sum_block(AbstractMatrix M, int start_row, int end_row, int start_column, int end_column) {
        double max_sum_block = 0.0;
        int i = start_row;
        while (i <= end_row) {
            double sum = StochasticBoundsRateWise.matrix_sum(M, i, start_column, end_column);
            max_sum_block = Math.max(max_sum_block, sum);
            ++i;
        }
        return StochasticBoundsRateWise.truncate(max_sum_block);
    }

    private static double min_sum_block(AbstractMatrix M, int start_row, int end_row, int start_column, int end_column) {
        double min_sum_block = 1.0;
        int i = start_row;
        while (i <= end_row) {
            double sum = StochasticBoundsRateWise.matrix_sum(M, i, start_column, end_column);
            min_sum_block = Math.min(min_sum_block, sum);
            ++i;
        }
        return StochasticBoundsRateWise.truncate(min_sum_block);
    }

    private static double average_sum_block(AbstractMatrix M, int start_row, int end_row, int start_column, int end_column) {
        int counter = 0;
        double sum = 0.0;
        int i = start_row;
        while (i <= end_row) {
            int j = start_column;
            while (j <= end_column) {
                sum += M.get(i, j);
                ++counter;
                ++j;
            }
            ++i;
        }
        return StochasticBoundsRateWise.truncate(sum / (double)counter);
    }

    private static void refresh_sum_rate_wise_upper(AbstractMatrix P, AbstractMatrix R, int start_column, int end_column, SequentialOrder order, ComponentRateContext context) {
        int n = R.numRows();
        double comparativeBound = context.getUpperComparativeBound();
        double internalBound = context.getUpperInternalBound();
        assert (comparativeBound >= 0.0);
        assert (internalBound >= 0.0);
        Point previous_block = null;
        Point current_block = order.getCurrent(0);
        double previous_maximum_in_R = 0.0;
        double current_maximum_in_R = 0.0;
        double current_maximum_in_P = StochasticBoundsRateWise.max_sum_block(P, current_block.x, current_block.y, start_column, n - 1);
        double current_comparative_sum = 1.0 - Math.min(comparativeBound, context.getUpperRatio(current_block)) * (1.0 - current_maximum_in_P);
        assert (current_comparative_sum >= 0.0 && current_comparative_sum <= 1.0);
        double current_internal_sum = 0.0;
        int i = 0;
        while (i < n) {
            if (order.isComparableIndex(i)) {
                previous_block = current_block;
                current_block = order.getCurrent(i);
                previous_maximum_in_R = current_maximum_in_R;
                current_maximum_in_P = StochasticBoundsRateWise.max_sum_block(P, current_block.x, current_block.y, start_column, n - 1);
                current_comparative_sum = 1.0 - Math.min(comparativeBound, context.getUpperRatio(current_block)) * (1.0 - current_maximum_in_P);
                current_internal_sum = 1.0 - Math.min(internalBound, StochasticBoundsRateWise.rate_ratio(context.getUpperRate(previous_block), context.getUpperRate(current_block))) * (1.0 - previous_maximum_in_R);
                assert (current_comparative_sum >= 0.0 && current_comparative_sum <= 1.0);
                assert (current_internal_sum >= 0.0 && current_internal_sum <= 1.0);
                assert (current_maximum_in_P >= 0.0 && current_maximum_in_P <= 1.0);
            }
            double current_assigned = StochasticBoundsRateWise.matrix_sum(R, i, end_column + 1, n - 1);
            double new_sum = Math.max(previous_maximum_in_R, current_maximum_in_P);
            if (start_column <= i) {
                new_sum = Math.max(new_sum, Math.max(current_comparative_sum, current_internal_sum));
            }
            double current_in_P = StochasticBoundsRateWise.matrix_sum(P, i, start_column, end_column);
            double new_probability = new_sum - current_assigned;
            if (new_probability > 0.0 && current_in_P > 0.0) {
                int j = start_column;
                while (j <= end_column) {
                    double new_prob = P.get(i, j) / current_in_P * new_probability;
                    R.set(i, j, new_prob);
                    ++j;
                }
            } else if (new_probability == 0.0) {
                int j = start_column;
                while (j <= end_column) {
                    R.set(i, j, 0.0);
                    ++j;
                }
            } else if (new_probability > 0.0 && current_in_P == 0.0) {
                double new_prob = new_probability / (double)(end_column - start_column + 1);
                int j = start_column;
                while (j <= end_column) {
                    R.set(i, j, new_prob);
                    ++j;
                }
            } else assert (false);
            current_maximum_in_R = Math.max(current_maximum_in_R, new_sum);
            ++i;
        }
    }

    private static double bound_divide(double num, double dem) {
        if (dem == 0.0) {
            if (num == 0.0) {
                return 1.0;
            }
            assert (false);
        }
        return num / dem;
    }

    private static void refresh_sum_rate_wise_lower(AbstractMatrix P, AbstractMatrix R, int start_column, int end_column, SequentialOrder order, ComponentRateContext context) {
        int n = R.numRows();
        double comparativeBound = context.getLowerComparativeBound();
        double internalBound = context.getLowerInternalBound();
        assert (comparativeBound >= 0.0);
        assert (internalBound >= 0.0);
        Point next_block = null;
        Point current_block = order.getCurrent(n - 1);
        double next_minimum_in_R = 1.0;
        double current_minimum_in_R = 1.0;
        double current_minimum_in_P = StochasticBoundsRateWise.min_sum_block(P, current_block.x, current_block.y, start_column, n - 1);
        double current_comparative_sum = 1.0 - Math.min(comparativeBound, context.getLowerRatio(current_block)) * (1.0 - current_minimum_in_P);
        assert (current_comparative_sum >= 0.0 && current_comparative_sum <= 1.0);
        double current_internal_sum = 0.0;
        int i = n - 1;
        while (i >= 0) {
            if (order.isComparableIndex(i)) {
                next_block = current_block;
                current_block = order.getCurrent(i);
                next_minimum_in_R = current_minimum_in_R;
                current_minimum_in_P = StochasticBoundsRateWise.min_sum_block(P, current_block.x, current_block.y, start_column, n - 1);
                current_comparative_sum = 1.0 - (1.0 - current_minimum_in_P) * Math.min(comparativeBound, context.getLowerRatio(current_block));
                current_internal_sum = 1.0 - (1.0 - next_minimum_in_R) * Math.min(internalBound, StochasticBoundsRateWise.rate_ratio(context.getLowerRate(next_block), context.getLowerRate(current_block)));
                assert (current_comparative_sum >= 0.0 && current_comparative_sum <= 1.0);
                assert (current_internal_sum >= 0.0 && current_internal_sum <= 1.0);
                assert (current_minimum_in_P >= 0.0 && current_minimum_in_P <= 1.0);
            }
            double current_assigned = StochasticBoundsRateWise.matrix_sum(R, i, end_column + 1, n - 1);
            double new_sum = Math.min(next_minimum_in_R, current_minimum_in_P);
            if (start_column <= i) {
                new_sum = Math.min(new_sum, Math.min(current_comparative_sum, current_internal_sum));
            }
            double current_in_P = StochasticBoundsRateWise.matrix_sum(P, i, start_column, end_column);
            double new_probability = new_sum - current_assigned;
            if (new_probability > 0.0 && current_in_P > 0.0) {
                int j = start_column;
                while (j <= end_column) {
                    double new_prob = P.get(i, j) / current_in_P * new_probability;
                    R.set(i, j, new_prob);
                    ++j;
                }
            } else if (new_probability == 0.0) {
                int j = start_column;
                while (j <= end_column) {
                    R.set(i, j, 0.0);
                    ++j;
                }
            } else if (new_probability > 0.0 && current_in_P == 0.0) {
                double new_prob = new_probability / (double)(end_column - start_column + 1);
                int j = start_column;
                while (j <= end_column) {
                    R.set(i, j, new_prob);
                    ++j;
                }
            } else assert (false);
            current_minimum_in_R = Math.min(current_minimum_in_R, new_sum);
            --i;
        }
    }

    private static void normalise_upper(AbstractMatrix R, int start_column, int end_column, PartitionIndices partitions) {
        int k = 0;
        while (k < partitions.size()) {
            int start_row = partitions.getStart(k);
            int end_row = partitions.getEnd(k);
            double max_assigned = StochasticBoundsRateWise.max_sum_block(R, start_row, end_row, start_column, end_column);
            int i = start_row;
            while (i <= end_row) {
                double new_prob;
                int j;
                double current_assigned = StochasticBoundsRateWise.matrix_sum(R, i, start_column, end_column);
                if (current_assigned > 0.0) {
                    j = start_column;
                    while (j <= end_column) {
                        new_prob = R.get(i, j) * max_assigned / current_assigned;
                        R.set(i, j, new_prob);
                        ++j;
                    }
                } else {
                    j = start_column;
                    while (j <= end_column) {
                        new_prob = max_assigned / (double)(end_column - start_column + 1);
                        R.set(i, j, new_prob);
                        ++j;
                    }
                }
                ++i;
            }
            ++k;
        }
    }

    private static void normalise_lower(AbstractMatrix R, int start_column, int end_column, PartitionIndices partitions) {
        int k = 0;
        while (k < partitions.size()) {
            int start_row = partitions.getStart(k);
            int end_row = partitions.getEnd(k);
            double min_assigned = StochasticBoundsRateWise.min_sum_block(R, start_row, end_row, start_column, end_column);
            int i = start_row;
            while (i <= end_row) {
                double new_prob;
                int j;
                double current_assigned = StochasticBoundsRateWise.matrix_sum(R, i, start_column, end_column);
                if (current_assigned > 0.0) {
                    j = start_column;
                    while (j <= end_column) {
                        new_prob = R.get(i, j) * min_assigned / current_assigned;
                        R.set(i, j, new_prob);
                        ++j;
                    }
                } else {
                    j = start_column;
                    while (j <= end_column) {
                        new_prob = min_assigned / (double)(end_column - start_column + 1);
                        R.set(i, j, new_prob);
                        ++j;
                    }
                }
                ++i;
            }
            ++k;
        }
    }

    private static void normalise_partition(AbstractMatrix R, int start_column, int end_column, PartitionIndices partitions) {
        int k = 0;
        while (k < partitions.size()) {
            int start_row = partitions.getStart(k);
            int end_row = partitions.getEnd(k);
            double new_probability = StochasticBoundsRateWise.average_sum_block(R, start_row, end_row, start_column, end_column);
            int i = start_row;
            while (i <= end_row) {
                int j = start_column;
                while (j <= end_column) {
                    R.set(i, j, new_probability);
                    ++j;
                }
                ++i;
            }
            ++k;
        }
    }

    private static FlexCompRowMatrix computeRateWiseUpperBound(AbstractMatrix P, PartitionIndices partitions, ComponentRateContext context, SequentialOrder order) {
        assert (P.numColumns() == P.numRows());
        int n = P.numColumns();
        FlexCompRowMatrix R = new FlexCompRowMatrix(n, n);
        if (order.isAnythingComparable()) {
            int end_partition = partitions.size() - 1;
            int k = partitions.size() - 1;
            while (k >= 0) {
                if (order.isComparableIndex(partitions.getStart(k))) {
                    StochasticBoundsRateWise.refresh_sum_rate_wise_upper(P, (AbstractMatrix)R, partitions.getStart(k), partitions.getEnd(end_partition), order, context);
                    assert (StochasticBoundsRateWise.isSubStochastic((AbstractMatrix)R));
                    StochasticBoundsRateWise.normalise_upper((AbstractMatrix)R, partitions.getStart(k), partitions.getEnd(end_partition), partitions);
                    assert (StochasticBoundsRateWise.isSubStochastic((AbstractMatrix)R));
                    int p = end_partition;
                    while (p >= k) {
                        StochasticBoundsRateWise.normalise_partition((AbstractMatrix)R, partitions.getStart(p), partitions.getEnd(p), partitions);
                        --p;
                    }
                    assert (StochasticBoundsRateWise.isSubStochastic((AbstractMatrix)R));
                    end_partition = k - 1;
                }
                --k;
            }
        } else {
            assert (false);
            int i = 0;
            while (i < n) {
                int j = 0;
                while (j < n) {
                    R.set(i, j, P.get(i, j));
                    ++j;
                }
                ++i;
            }
            int k = partitions.size() - 1;
            while (k >= 0) {
                StochasticBoundsRateWise.normalise_partition((AbstractMatrix)R, partitions.getStart(k), partitions.getEnd(k), partitions);
                --k;
            }
            assert (StochasticBoundsRateWise.isSubStochastic((AbstractMatrix)R));
        }
        assert (StochasticBoundsRateWise.isStochastic((AbstractMatrix)R));
        return R;
    }

    private static FlexCompRowMatrix computeRateWiseLowerBound(AbstractMatrix P, PartitionIndices partitions, ComponentRateContext context, SequentialOrder order) {
        assert (P.numColumns() == P.numRows());
        int n = P.numColumns();
        FlexCompRowMatrix R = new FlexCompRowMatrix(n, n);
        if (order.isAnythingComparable()) {
            int end_partition = partitions.size() - 1;
            int k = partitions.size() - 1;
            while (k >= 0) {
                if (order.isComparableIndex(partitions.getStart(k))) {
                    StochasticBoundsRateWise.refresh_sum_rate_wise_lower(P, (AbstractMatrix)R, partitions.getStart(k), partitions.getEnd(end_partition), order, context);
                    assert (StochasticBoundsRateWise.isSubStochastic((AbstractMatrix)R));
                    StochasticBoundsRateWise.normalise_lower((AbstractMatrix)R, partitions.getStart(k), partitions.getEnd(end_partition), partitions);
                    assert (StochasticBoundsRateWise.isSubStochastic((AbstractMatrix)R));
                    int p = end_partition;
                    while (p >= k) {
                        StochasticBoundsRateWise.normalise_partition((AbstractMatrix)R, partitions.getStart(p), partitions.getEnd(p), partitions);
                        --p;
                    }
                    assert (StochasticBoundsRateWise.isSubStochastic((AbstractMatrix)R));
                    end_partition = k - 1;
                }
                --k;
            }
        } else assert (false);
        assert (StochasticBoundsRateWise.isStochastic((AbstractMatrix)R));
        return R;
    }

    private static boolean isSubStochastic(AbstractMatrix R) {
        boolean isOK = true;
        int n = R.numColumns();
        int i = 0;
        while (i < n) {
            double sum = 0.0;
            int j = 0;
            while (j < n) {
                sum += R.get(i, j);
                ++j;
            }
            if (sum > 1.0000001) {
                isOK = false;
            }
            ++i;
        }
        return isOK;
    }

    private static boolean isStochastic(AbstractMatrix R) {
        boolean isOK = true;
        int n = R.numColumns();
        int i = 0;
        while (i < n) {
            double sum = 0.0;
            int j = 0;
            while (j < n) {
                sum += R.get(i, j);
                ++j;
            }
            if (sum <= 0.9999999 || sum >= 1.0000001) {
                isOK = false;
            }
            ++i;
        }
        return isOK;
    }

    public static FlexCompRowMatrix upperBoundMatrix(AbstractMatrix P, SequentialAbstraction abstraction, ComponentRateContext context, SequentialOrder order) {
        return StochasticBoundsRateWise.computeRateWiseUpperBound(P, new PartitionIndices(abstraction), context, order);
    }

    public static FlexCompRowMatrix lowerBoundMatrix(AbstractMatrix P, SequentialAbstraction abstraction, ComponentRateContext context, SequentialOrder order) {
        return StochasticBoundsRateWise.computeRateWiseLowerBound(P, new PartitionIndices(abstraction), context, order);
    }
}

