/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.modelchecking;

import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLAbstractPathProperty;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLAbstractProperty;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLAbstractStateProperty;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLTimeInterval;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.ModelCheckingException;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.StringPosition;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.ICSLVisitor;

public class CSLNextNode
extends CSLAbstractPathProperty {
    private CSLAbstractStateProperty property;
    private CSLTimeInterval timeBound;

    public CSLNextNode(CSLAbstractStateProperty property, CSLTimeInterval timeBound) {
        this.property = property;
        this.timeBound = timeBound;
    }

    public CSLAbstractStateProperty getProperty() {
        return this.property;
    }

    public CSLTimeInterval getTimeInterval() {
        return this.timeBound;
    }

    public String toString() {
        String s = this.property.isSimple() ? this.property.toString() : "(" + this.property.toString() + ")";
        return "X" + this.timeBound.toString() + " " + s;
    }

    public boolean containsPlaceHolder() {
        return this.property.containsPlaceHolder();
    }

    public CSLAbstractPathProperty replace(CSLAbstractProperty object1, CSLAbstractProperty object2) {
        if (this == object1 && object2 instanceof CSLAbstractPathProperty) {
            return (CSLAbstractPathProperty)object2;
        }
        this.property = this.property.replace(object1, object2);
        this.timeBound = this.timeBound.replace(object1, object2);
        return this;
    }

    public CSLAbstractPathProperty copy() {
        return new CSLNextNode(this.property.copy(), this.timeBound.copy());
    }

    public StringPosition[] getChildren() {
        int start1 = 1;
        StringPosition[] intervalChildren = this.timeBound.getChildren();
        int end1 = start1 + this.timeBound.toString().length();
        int start2 = end1 + 1 + (this.property.isSimple() ? 0 : 1);
        int end2 = start2 + this.property.toString().length();
        StringPosition position2 = new StringPosition(start2, end2, this.property);
        StringPosition[] children = new StringPosition[1 + intervalChildren.length];
        int i = 0;
        while (i < intervalChildren.length) {
            children[i] = intervalChildren[i].addOffset(start1);
            ++i;
        }
        children[intervalChildren.length] = position2;
        return children;
    }

    public boolean equals(Object o) {
        if (o instanceof CSLNextNode) {
            CSLNextNode node = (CSLNextNode)o;
            return this.property.equals(node.property) && this.timeBound.equals(node.timeBound);
        }
        return false;
    }

    public int hashCode() {
        return this.property.hashCode() + this.timeBound.hashCode() + 14;
    }

    public void accept(ICSLVisitor visitor) throws ModelCheckingException {
        this.property.accept(visitor);
        visitor.visit(this);
    }
}

