/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.modelchecking;

import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLAbstractProperty;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLAbstractStateProperty;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.ModelCheckingException;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.StringPosition;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.ICSLVisitor;

public class CSLOrNode
extends CSLAbstractStateProperty {
    private CSLAbstractStateProperty property1;
    private CSLAbstractStateProperty property2;

    public CSLAbstractStateProperty getProperty1() {
        return this.property1;
    }

    public CSLAbstractStateProperty getProperty2() {
        return this.property2;
    }

    public CSLOrNode(CSLAbstractStateProperty property1, CSLAbstractStateProperty property2) {
        this.property1 = property1;
        this.property2 = property2;
    }

    public boolean isSimple() {
        return false;
    }

    public String toString() {
        String s1 = this.property1.isSimple() ? this.property1.toString() : "(" + this.property1.toString() + ")";
        String s2 = this.property2.isSimple() ? this.property2.toString() : "(" + this.property2.toString() + ")";
        return String.valueOf(s1) + " \\/ " + s2;
    }

    public boolean containsPlaceHolder() {
        return this.property1.containsPlaceHolder() || this.property2.containsPlaceHolder();
    }

    public CSLAbstractStateProperty replace(CSLAbstractProperty object1, CSLAbstractProperty object2) {
        if (this == object1 && object2 instanceof CSLAbstractStateProperty) {
            return (CSLAbstractStateProperty)object2;
        }
        this.property1 = this.property1.replace(object1, object2);
        this.property2 = this.property2.replace(object1, object2);
        return this;
    }

    public CSLAbstractStateProperty copy() {
        return new CSLOrNode(this.property1.copy(), this.property2.copy());
    }

    public StringPosition[] getChildren() {
        int start1 = this.property1.isSimple() ? 0 : 1;
        int end1 = start1 + this.property1.toString().length();
        StringPosition position1 = new StringPosition(start1, end1, this.property1);
        int start2 = end1 + 4 + (this.property1.isSimple() ? 0 : 1) + (this.property2.isSimple() ? 0 : 1);
        int end2 = start2 + this.property2.toString().length();
        StringPosition position2 = new StringPosition(start2, end2, this.property2);
        StringPosition[] children = new StringPosition[]{position1, position2};
        return children;
    }

    public boolean equals(Object o) {
        if (o instanceof CSLOrNode) {
            CSLOrNode node = (CSLOrNode)o;
            return this.property1.equals(node.property1) && this.property2.equals(node.property2);
        }
        return false;
    }

    public int hashCode() {
        return this.property1.hashCode() + this.property2.hashCode() + 1;
    }

    public void accept(ICSLVisitor visitor) throws ModelCheckingException {
        this.property1.accept(visitor);
        this.property2.accept(visitor);
        visitor.visit(this);
    }

    protected void setCompositionality(boolean withinSteadyStateOperator) {
        this.property1.setCompositionality(withinSteadyStateOperator);
        this.property2.setCompositionality(withinSteadyStateOperator);
        this.isCompositional = this.property1.isCompositional() && this.property2.isCompositional();
    }
}

