/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.modelchecking;

import uk.ac.ed.inf.pepa.ctmc.modelchecking.AbstractBoolean;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLAbstractProbability;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLAbstractProperty;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLDouble;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.ProbabilityInterval;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.StringPosition;

public class CSLProbabilityComparator
extends CSLAbstractProbability {
    private boolean isLessThan;
    private CSLDouble probability;

    public CSLProbabilityComparator(boolean isLessThan, CSLDouble probability) {
        this.isLessThan = isLessThan;
        this.probability = probability;
    }

    public boolean checkProbability(double testProbability) {
        if (this.isLessThan) {
            return testProbability < this.probability.getValue();
        }
        return testProbability > this.probability.getValue();
    }

    public AbstractBoolean checkProbability(ProbabilityInterval testProbability) {
        return this.checkProbability(testProbability.getLower(), testProbability.getUpper());
    }

    public AbstractBoolean checkProbability(double lowerProbability, double upperProbability) {
        boolean lowerOK = this.checkProbability(lowerProbability);
        boolean upperOK = this.checkProbability(upperProbability);
        if (lowerOK && upperOK) {
            return AbstractBoolean.TRUE;
        }
        if (!lowerOK && !upperOK) {
            return AbstractBoolean.FALSE;
        }
        return AbstractBoolean.MAYBE;
    }

    public String toString() {
        if (this.isLessThan) {
            return "<" + this.probability.toString();
        }
        return ">" + this.probability.toString();
    }

    public boolean containsPlaceHolder() {
        return false;
    }

    public StringPosition[] getChildren() {
        int start = 1;
        int end = start + this.probability.toString().length();
        StringPosition position = new StringPosition(start, end, this.probability);
        return new StringPosition[]{position};
    }

    public CSLAbstractProbability replace(CSLAbstractProperty object1, CSLAbstractProperty object2) {
        if (this == object1 && object2 instanceof CSLAbstractProbability) {
            return (CSLAbstractProbability)object2;
        }
        return this;
    }

    public CSLAbstractProbability copy() {
        return new CSLProbabilityComparator(this.isLessThan, this.probability);
    }

    public boolean equals(Object o) {
        if (o instanceof CSLProbabilityComparator) {
            CSLProbabilityComparator node = (CSLProbabilityComparator)o;
            return this.isLessThan == node.isLessThan && this.probability.equals(node.probability);
        }
        return false;
    }

    public int hashCode() {
        return (this.isLessThan ? 0 : 1) + this.probability.hashCode() + 8;
    }
}

