/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.modelchecking;

import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLAbstractPathProperty;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLAbstractProperty;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLAbstractStateProperty;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLTimeInterval;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.ModelCheckingException;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.StringPosition;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.ICSLVisitor;

public class CSLUntilNode
extends CSLAbstractPathProperty {
    private CSLAbstractStateProperty property1;
    private CSLAbstractStateProperty property2;
    private CSLTimeInterval timeBound;

    public CSLUntilNode(CSLAbstractStateProperty property1, CSLAbstractStateProperty property2, CSLTimeInterval timeBound) {
        this.property1 = property1;
        this.property2 = property2;
        this.timeBound = timeBound;
    }

    public CSLAbstractStateProperty getProperty1() {
        return this.property1;
    }

    public CSLAbstractStateProperty getProperty2() {
        return this.property2;
    }

    public CSLTimeInterval getTimeInterval() {
        return this.timeBound;
    }

    public String toString() {
        String s1 = this.property1.isSimple() ? this.property1.toString() : "(" + this.property1.toString() + ")";
        String s2 = this.property2.isSimple() ? this.property2.toString() : "(" + this.property2.toString() + ")";
        return String.valueOf(s1) + " U" + this.timeBound.toString() + " " + s2;
    }

    public boolean containsPlaceHolder() {
        return this.property1.containsPlaceHolder() || this.property2.containsPlaceHolder();
    }

    public CSLAbstractPathProperty replace(CSLAbstractProperty object1, CSLAbstractProperty object2) {
        if (this == object1 && object2 instanceof CSLAbstractPathProperty) {
            return (CSLAbstractPathProperty)object2;
        }
        this.property1 = this.property1.replace(object1, object2);
        this.property2 = this.property2.replace(object1, object2);
        this.timeBound = this.timeBound.replace(object1, object2);
        return this;
    }

    public CSLAbstractPathProperty copy() {
        return new CSLUntilNode(this.property1.copy(), this.property2.copy(), this.timeBound.copy());
    }

    public StringPosition[] getChildren() {
        int start1 = this.property1.isSimple() ? 0 : 1;
        int end1 = start1 + this.property1.toString().length();
        StringPosition position1 = new StringPosition(start1, end1, this.property1);
        int start2 = end1 + 2 + (this.property1.isSimple() ? 0 : 1);
        StringPosition[] intervalChildren = this.timeBound.getChildren();
        int end2 = start2 + this.timeBound.toString().length();
        int start3 = end2 + 1 + (this.property2.isSimple() ? 0 : 1);
        int end3 = start3 + this.property2.toString().length();
        StringPosition position3 = new StringPosition(start3, end3, this.property2);
        StringPosition[] children = new StringPosition[2 + intervalChildren.length];
        children[0] = position1;
        int i = 0;
        while (i < intervalChildren.length) {
            children[i + 1] = intervalChildren[i].addOffset(start2);
            ++i;
        }
        children[intervalChildren.length + 1] = position3;
        return children;
    }

    public boolean equals(Object o) {
        if (o instanceof CSLUntilNode) {
            CSLUntilNode node = (CSLUntilNode)o;
            return this.property1.equals(node.property1) && this.property2.equals(node.property2) && this.timeBound.equals(node.timeBound);
        }
        return false;
    }

    public int hashCode() {
        return this.property1.hashCode() + this.property2.hashCode() + this.timeBound.hashCode() + 11;
    }

    public void accept(ICSLVisitor visitor) throws ModelCheckingException {
        this.property1.accept(visitor);
        this.property2.accept(visitor);
        visitor.visit(this);
    }
}

