/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.modelchecking.internal;

import java.util.Arrays;
import uk.ac.ed.inf.pepa.ctmc.abstraction.SequentialStateSpace;

public class AtomicProperty {
    private int numComponents;
    private SequentialStateSpace[] stateSpaces;
    private boolean[][] property;

    public AtomicProperty(int numComponents) {
        this.numComponents = numComponents;
        this.property = new boolean[numComponents][];
        this.stateSpaces = new SequentialStateSpace[numComponents];
    }

    public void addPropertyMap(int component, SequentialStateSpace stateSpace, boolean initialValue) {
        boolean[] propertyMap = new boolean[stateSpace.size()];
        Arrays.fill(propertyMap, initialValue);
        this.property[component] = propertyMap;
        this.stateSpaces[component] = stateSpace;
        stateSpace.register(this);
    }

    public boolean getProperty(int component, int index) {
        return this.property[component][index];
    }

    public void setProperty(int component, int index, boolean isTrue) {
        this.property[component][index] = isTrue;
    }

    public void setPropertyAll(int component, boolean isTrue) {
        boolean[] propertyMap = this.property[component];
        int i = 0;
        while (i < propertyMap.length) {
            propertyMap[i] = isTrue;
            ++i;
        }
    }

    public boolean checkProperty(short[] state) {
        assert (state.length == this.numComponents);
        boolean isTrue = true;
        int i = 0;
        while (i < this.numComponents) {
            int index = this.stateSpaces[i].getIndex(state[i]);
            isTrue = isTrue && this.property[i][index];
            ++i;
        }
        return isTrue;
    }

    public void notifySwap(SequentialStateSpace stateSpace, int index1, int index2) {
        int i = 0;
        while (i < this.numComponents) {
            if (this.stateSpaces[i] == stateSpace) {
                boolean value2;
                boolean value1 = this.property[i][index1];
                this.property[i][index1] = value2 = this.property[i][index2];
                this.property[i][index2] = value1;
            }
            ++i;
        }
    }
}

