/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.modelchecking.internal;

import java.util.HashMap;
import uk.ac.ed.inf.pepa.ctmc.abstraction.SequentialAbstraction;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.AbstractBoolean;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLAbstractStateProperty;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLAndNode;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLAtomicNode;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLBooleanNode;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLImpliesNode;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLNextNode;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLNotNode;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLOrNode;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLPathPlaceHolder;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLPathPropertyNode;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLStatePlaceHolder;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLSteadyStateNode;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLUntilNode;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.ModelCheckingException;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.AtomicProperty;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.CSLPropertyManager;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.CompositionalProperty;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.CompositionalPropertyList;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.ICSLVisitor;

public class CSLCompositionalModelChecker
implements ICSLVisitor {
    private CSLPropertyManager propertyManager;
    private SequentialAbstraction[] abstraction;
    private HashMap<CSLAbstractStateProperty, CompositionalPropertyList> properties;

    public CSLCompositionalModelChecker(CSLPropertyManager propertyManager, SequentialAbstraction[] abstraction) {
        this.propertyManager = propertyManager;
        this.abstraction = abstraction;
    }

    public CompositionalPropertyList getProperty(CSLAbstractStateProperty property) throws ModelCheckingException {
        this.init();
        property.accept(this);
        CompositionalPropertyList found = this.properties.get(property);
        this.unregisterAllExcept(found);
        return found;
    }

    private void init() {
        this.properties = new HashMap(10);
    }

    private void unregisterAllExcept(CompositionalPropertyList found) {
        for (CompositionalPropertyList property : this.properties.values()) {
            if (property == found) continue;
            property.unregister();
        }
    }

    public void visit(CSLAtomicNode node) throws ModelCheckingException {
        AtomicProperty atomicProperty = this.propertyManager.getPropertyBank().getAtomicProperty(node.getName());
        CompositionalProperty property = new CompositionalProperty(this.abstraction, atomicProperty);
        this.properties.put(node, new CompositionalPropertyList(property));
    }

    public void visit(CSLBooleanNode node) throws ModelCheckingException {
        CompositionalProperty property = new CompositionalProperty(this.abstraction, node.getValue());
        this.properties.put(node, new CompositionalPropertyList(property));
    }

    public void visit(CSLNotNode node) throws ModelCheckingException {
        CompositionalPropertyList property = this.properties.get(node.getProperty());
        this.properties.put(node, property.complement());
    }

    public void visit(CSLAndNode node) throws ModelCheckingException {
        CompositionalPropertyList property1 = this.properties.get(node.getProperty1());
        CompositionalPropertyList property2 = this.properties.get(node.getProperty2());
        this.properties.put(node, property1.intersection(property2));
    }

    public void visit(CSLOrNode node) throws ModelCheckingException {
        CompositionalPropertyList property1 = this.properties.get(node.getProperty1());
        CompositionalPropertyList property2 = this.properties.get(node.getProperty2());
        this.properties.put(node, property1.union(property2));
    }

    public void visit(CSLImpliesNode node) throws ModelCheckingException {
        CompositionalPropertyList property1 = this.properties.get(node.getProperty1());
        CompositionalPropertyList property2 = this.properties.get(node.getProperty2());
        CompositionalPropertyList tempProperty = property1.complement();
        this.properties.put(node, property2.union(tempProperty));
        tempProperty.unregister();
    }

    public void visit(CSLPathPropertyNode node) throws ModelCheckingException {
        throw new ModelCheckingException("A non-compositional node was reached.");
    }

    public void visit(CSLSteadyStateNode node) throws ModelCheckingException {
        AbstractBoolean value = this.propertyManager.getConstantProperty(node);
        if (value == null) {
            throw new ModelCheckingException("A nested steady state node has not been evaluated.");
        }
        CompositionalProperty property = value == AbstractBoolean.TRUE || value == AbstractBoolean.MAYBE ? new CompositionalProperty(this.abstraction, true) : new CompositionalProperty(this.abstraction, false);
        this.properties.put(node, new CompositionalPropertyList(property));
    }

    public void visit(CSLUntilNode node) throws ModelCheckingException {
        throw new ModelCheckingException("A non-compositional node was reached.");
    }

    public void visit(CSLNextNode node) throws ModelCheckingException {
        throw new ModelCheckingException("A non-compositional node was reached.");
    }

    public void visit(CSLPathPlaceHolder node) throws ModelCheckingException {
        throw new ModelCheckingException("A place-holder node was reached.");
    }

    public void visit(CSLStatePlaceHolder node) throws ModelCheckingException {
        throw new ModelCheckingException("A place-holder node was reached.");
    }
}

