/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.modelchecking.internal;

import java.util.ArrayList;
import java.util.HashMap;
import uk.ac.ed.inf.pepa.ctmc.abstraction.SequentialAbstraction;
import uk.ac.ed.inf.pepa.ctmc.abstraction.SequentialStateSpace;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.AbstractBoolean;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLAbstractPathProperty;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLAbstractProperty;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLAbstractStateProperty;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLAtomicNode;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLBooleanNode;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.ModelCheckingException;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.StringPosition;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.AbstractCTMCState;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.AtomicProperty;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.PropertyBank;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.PropertyTagFullException;

public class CSLPropertyManager {
    private static final int MAX_ENABLED = 32;
    private ArrayList<CSLAbstractStateProperty> properties;
    private CSLAbstractStateProperty[] propertiesAssigned;
    private HashMap<CSLAbstractStateProperty, AbstractBoolean> constantAnswers;
    private CSLAbstractStateProperty currentProperty;
    private int currentIndex;
    private int numAtomicProperties;
    private PropertyBank propertyBank;
    private SequentialAbstraction[] abstractStateSpace;

    public CSLPropertyManager(PropertyBank propertyBank, SequentialAbstraction[] abstractStateSpace) {
        this.propertyBank = propertyBank;
        this.abstractStateSpace = abstractStateSpace;
        this.properties = new ArrayList(32);
        this.propertiesAssigned = new CSLAbstractStateProperty[32];
        this.constantAnswers = new HashMap(10);
        this.constantAnswers.put(new CSLBooleanNode(true), AbstractBoolean.TRUE);
        this.constantAnswers.put(new CSLBooleanNode(false), AbstractBoolean.FALSE);
        this.addAtomicProperties();
    }

    private void addNewProperty(CSLAbstractStateProperty property) {
        if (!this.properties.contains(property)) {
            this.properties.add(property);
        }
    }

    private void addAtomicProperties() {
        String[] names = this.propertyBank.getAtomicPropertyNames();
        this.numAtomicProperties = names.length;
        int i = 0;
        while (i < names.length) {
            this.addNewProperty(new CSLAtomicNode(names[i]));
            ++i;
        }
    }

    private void addProperty(CSLAbstractPathProperty property) {
        StringPosition[] children = property.getChildren();
        int i = 0;
        while (i < children.length) {
            CSLAbstractProperty child = children[i].getObject();
            if (child instanceof CSLAbstractStateProperty) {
                this.addProperty((CSLAbstractStateProperty)child);
            }
            ++i;
        }
    }

    public void addProperty(CSLAbstractStateProperty property) {
        if (property.isCompositional()) {
            return;
        }
        StringPosition[] children = property.getChildren();
        int i = 0;
        while (i < children.length) {
            CSLAbstractProperty child = children[i].getObject();
            if (child instanceof CSLAbstractStateProperty) {
                this.addProperty((CSLAbstractStateProperty)child);
            } else if (child instanceof CSLAbstractPathProperty) {
                this.addProperty((CSLAbstractPathProperty)child);
            }
            ++i;
        }
        this.addNewProperty(property);
    }

    public void setConstantProperty(CSLAbstractStateProperty property, AbstractBoolean value) {
        this.constantAnswers.put(property, value);
    }

    public AbstractBoolean getConstantProperty(CSLAbstractStateProperty property) {
        return this.constantAnswers.get(property);
    }

    public void labelAtomicProperties(AbstractCTMCState state) {
        short[] stateID = state.getState();
        int i = 0;
        while (i < this.numAtomicProperties) {
            CSLAtomicNode CSLAtom = (CSLAtomicNode)this.properties.get(i);
            this.propertiesAssigned[i] = CSLAtom;
            AtomicProperty property = this.propertyBank.getAtomicProperty(CSLAtom.toString());
            boolean isTrue = true;
            boolean isFalse = false;
            int j = 0;
            while (j < stateID.length) {
                boolean isAbstractTrue = false;
                boolean isAbstractFalse = false;
                short abstractState = stateID[j];
                SequentialAbstraction abstraction = this.abstractStateSpace[j];
                SequentialStateSpace stateSpace = abstraction.getConcreteStateSpace();
                short[] concreteStates = abstraction.getConcreteStates(abstractState);
                int k = 0;
                while (k < concreteStates.length) {
                    short concreteState = concreteStates[k];
                    int index = stateSpace.getIndex(concreteState);
                    boolean isConcreteTrue = property.getProperty(j, index);
                    isAbstractTrue = isAbstractTrue || isConcreteTrue;
                    isAbstractFalse = isAbstractFalse || !isConcreteTrue;
                    ++k;
                }
                isTrue = isTrue && isAbstractTrue;
                isFalse = isFalse || isAbstractFalse;
                ++j;
            }
            state.setProperty(i, isTrue, isFalse);
            ++i;
        }
    }

    private void setProperty(CSLAbstractStateProperty property, AbstractCTMCState state, AbstractBoolean value) throws PropertyTagFullException {
        int index = this.getPropertyIndex(property);
        state.setProperty(index, value);
    }

    private AbstractBoolean getProperty(CSLAbstractStateProperty property, AbstractCTMCState state) {
        try {
            int index = this.getPropertyIndex(property);
            return state.getProperty(index);
        }
        catch (PropertyTagFullException propertyTagFullException) {
            return AbstractBoolean.NOT_SET;
        }
    }

    public AbstractBoolean test(CSLAbstractStateProperty property, AbstractCTMCState state) {
        AbstractBoolean value = this.constantAnswers.get(property);
        if (value != null) {
            return value;
        }
        return this.getProperty(property, state);
    }

    public void set(CSLAbstractStateProperty property, AbstractCTMCState state, AbstractBoolean value) throws ModelCheckingException {
        try {
            this.setProperty(property, state, value);
        }
        catch (PropertyTagFullException propertyTagFullException) {
            throw new ModelCheckingException("The property is too large to check.");
        }
    }

    private int getPropertyIndex(CSLAbstractStateProperty property) throws PropertyTagFullException {
        if (this.currentProperty != null && (this.currentProperty == property || this.currentProperty.equals(property))) {
            return this.currentIndex;
        }
        int index = this.properties.lastIndexOf(property);
        if (index < 0 || index >= 32) {
            throw new PropertyTagFullException();
        }
        this.currentProperty = property;
        this.currentIndex = index;
        return index;
    }

    public PropertyBank getPropertyBank() {
        return this.propertyBank;
    }
}

