/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.modelchecking.internal;

import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.ed.inf.pepa.ctmc.abstraction.AbstractState;
import uk.ac.ed.inf.pepa.ctmc.abstraction.SequentialAbstraction;
import uk.ac.ed.inf.pepa.ctmc.abstraction.SequentialStateSpace;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.ShortArray;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.KroneckerUtilities;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.AtomicProperty;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.CompositionalPropertyList;

public class CompositionalProperty {
    private int numComponents;
    private SequentialAbstraction[] abstraction;
    private short[][] upperConcreteProperty;
    private short[][] upperAbstractProperty;
    private short[][] lowerConcreteProperty;
    private short[][] lowerAbstractProperty;
    private boolean isTrue;
    private boolean isFalse;

    public CompositionalProperty(SequentialAbstraction[] abstraction, boolean isTrue) {
        this.numComponents = abstraction.length;
        this.abstraction = abstraction;
        this.upperAbstractProperty = null;
        this.upperConcreteProperty = null;
        this.lowerAbstractProperty = null;
        this.lowerConcreteProperty = null;
        this.isTrue = isTrue;
        this.isFalse = !isTrue;
    }

    public CompositionalProperty(SequentialAbstraction[] abstraction, short[][] property) {
        this.numComponents = abstraction.length;
        this.abstraction = abstraction;
        this.upperAbstractProperty = property;
        this.upperConcreteProperty = new short[this.numComponents][];
        this.lowerAbstractProperty = null;
        this.lowerConcreteProperty = null;
        this.isTrue = false;
        this.isFalse = false;
        this.setConcreteProperty();
        int i = 0;
        while (i < this.numComponents) {
            abstraction[i].registerProperty(this);
            ++i;
        }
    }

    public CompositionalProperty(SequentialAbstraction[] abstraction, AtomicProperty property) {
        this.numComponents = abstraction.length;
        this.abstraction = abstraction;
        this.upperAbstractProperty = new short[this.numComponents][];
        this.upperConcreteProperty = new short[this.numComponents][];
        this.lowerAbstractProperty = new short[this.numComponents][];
        this.lowerConcreteProperty = new short[this.numComponents][];
        this.isTrue = false;
        this.isFalse = false;
        int component = 0;
        while (component < this.numComponents) {
            SequentialStateSpace concreteStateSpace = abstraction[component].getConcreteStateSpace();
            AbstractState[] abstractStateSpace = abstraction[component].getAbstractStateSpace();
            ShortArray upperAbstractStateArray = new ShortArray(abstraction[component].size());
            ShortArray upperConcreteStateArray = new ShortArray(abstraction[component].getConcreteStateSpace().size());
            ShortArray lowerAbstractStateArray = new ShortArray(abstraction[component].size());
            ShortArray lowerConcreteStateArray = new ShortArray(abstraction[component].getConcreteStateSpace().size());
            int i = 0;
            while (i < abstractStateSpace.length) {
                AbstractState state = abstractStateSpace[i];
                short[] concreteStates = state.getConcrete();
                boolean allTrue = true;
                boolean allFalse = true;
                int j = 0;
                while (j < concreteStates.length) {
                    int index = concreteStateSpace.getIndex(concreteStates[j]);
                    if (property.getProperty(component, index)) {
                        allFalse = false;
                    } else {
                        allTrue = false;
                    }
                    ++j;
                }
                if (allTrue) {
                    lowerAbstractStateArray.addNew(state.getID());
                    lowerConcreteStateArray.add(concreteStates);
                }
                if (!allFalse) {
                    upperAbstractStateArray.addNew(state.getID());
                    upperConcreteStateArray.add(concreteStates);
                }
                ++i;
            }
            this.upperAbstractProperty[component] = upperAbstractStateArray.toArray();
            this.upperConcreteProperty[component] = upperConcreteStateArray.toArray();
            this.lowerAbstractProperty[component] = lowerAbstractStateArray.toArray();
            this.lowerConcreteProperty[component] = lowerConcreteStateArray.toArray();
            ++component;
        }
        int i = 0;
        while (i < this.numComponents) {
            abstraction[i].registerProperty(this);
            ++i;
        }
    }

    private CompositionalProperty(SequentialAbstraction[] abstraction) {
        this.numComponents = abstraction.length;
        this.abstraction = abstraction;
        this.isTrue = false;
        this.isFalse = false;
        int i = 0;
        while (i < this.numComponents) {
            abstraction[i].registerProperty(this);
            ++i;
        }
    }

    public void unregister() {
        if (!this.isTrue && !this.isFalse) {
            int i = 0;
            while (i < this.numComponents) {
                this.abstraction[i].unregisterProperty(this);
                ++i;
            }
        }
    }

    private void setConcreteProperty() {
        int component = 0;
        while (component < this.numComponents) {
            ShortArray concreteStates = new ShortArray(this.abstraction[component].getConcreteStateSpace().size());
            short[] abstractStates = this.upperAbstractProperty[component];
            int j = 0;
            while (j < abstractStates.length) {
                short[] states = this.abstraction[component].getConcreteStates(abstractStates[j]);
                int k = 0;
                while (k < states.length) {
                    concreteStates.add(states[k]);
                    ++k;
                }
                j = (short)(j + 1);
            }
            this.upperConcreteProperty[component] = concreteStates.toArray();
            ++component;
        }
    }

    public void notifyAbstractChange(SequentialAbstraction stateSpace, short[] IDMap) {
        int i = 0;
        while (i < this.numComponents) {
            if (this.abstraction[i] == stateSpace) {
                short[] upperStates = this.upperAbstractProperty[i];
                int j = 0;
                while (j < upperStates.length) {
                    upperStates[j] = IDMap[upperStates[j]];
                    ++j;
                }
                if (this.lowerAbstractProperty != null) {
                    short[] lowerStates = this.lowerAbstractProperty[i];
                    int j2 = 0;
                    while (j2 < lowerStates.length) {
                        lowerStates[j2] = IDMap[lowerStates[j2]];
                        ++j2;
                    }
                }
            }
            ++i;
        }
    }

    public CompositionalProperty union(CompositionalProperty property) {
        if (this.isFalse) {
            return property;
        }
        if (property.isFalse) {
            return this;
        }
        if (this.isTrue || property.isTrue) {
            return new CompositionalProperty(this.abstraction, true);
        }
        CompositionalProperty newProperty = new CompositionalProperty(this.abstraction);
        short[][] newConcreteProperty = new short[this.numComponents][];
        short[][] newAbstractProperty = new short[this.numComponents][];
        int component = 0;
        while (component < this.numComponents) {
            ShortArray newConcrete = new ShortArray(this.abstraction[component].getConcreteStateSpace().size());
            ShortArray newAbstract = new ShortArray(this.abstraction[component].size());
            int i = 0;
            while (i < this.upperAbstractProperty[component].length) {
                newAbstract.addNew(this.upperAbstractProperty[component][i]);
                ++i;
            }
            i = 0;
            while (i < property.upperAbstractProperty[component].length) {
                newAbstract.addNew(property.upperAbstractProperty[component][i]);
                ++i;
            }
            i = 0;
            while (i < this.upperConcreteProperty[component].length) {
                newConcrete.addNew(this.upperConcreteProperty[component][i]);
                ++i;
            }
            i = 0;
            while (i < property.upperConcreteProperty[component].length) {
                newConcrete.addNew(property.upperConcreteProperty[component][i]);
                ++i;
            }
            newConcreteProperty[component] = newConcrete.toArray();
            newAbstractProperty[component] = newAbstract.toArray();
            ++component;
        }
        newProperty.upperConcreteProperty = newConcreteProperty;
        newProperty.upperAbstractProperty = newAbstractProperty;
        return newProperty;
    }

    public CompositionalProperty intersection(CompositionalProperty property) {
        if (this.isTrue) {
            return property;
        }
        if (property.isTrue) {
            return this;
        }
        if (this.isFalse || property.isFalse) {
            return new CompositionalProperty(this.abstraction, false);
        }
        CompositionalProperty newProperty = new CompositionalProperty(this.abstraction);
        short[][] newUpperConcreteProperty = new short[this.numComponents][];
        short[][] newUpperAbstractProperty = new short[this.numComponents][];
        int component = 0;
        while (component < this.numComponents) {
            int j;
            short state;
            ShortArray newUpperConcrete = new ShortArray(this.abstraction[component].getConcreteStateSpace().size());
            ShortArray newUpperAbstract = new ShortArray(this.abstraction[component].size());
            int i = 0;
            while (i < this.upperAbstractProperty[component].length) {
                state = this.upperAbstractProperty[component][i];
                j = 0;
                while (j < property.upperAbstractProperty[component].length) {
                    if (state == property.upperAbstractProperty[component][j]) {
                        newUpperAbstract.add(state);
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < this.upperConcreteProperty[component].length) {
                state = this.upperConcreteProperty[component][i];
                j = 0;
                while (j < property.upperConcreteProperty[component].length) {
                    if (state == property.upperConcreteProperty[component][j]) {
                        newUpperConcrete.add(state);
                    }
                    ++j;
                }
                ++i;
            }
            newUpperConcreteProperty[component] = newUpperConcrete.toArray();
            newUpperAbstractProperty[component] = newUpperAbstract.toArray();
            ++component;
        }
        Object newLowerConcreteProperty = null;
        Object newLowerAbstractProperty = null;
        if (this.lowerAbstractProperty != null || property.lowerAbstractProperty != null) {
            newLowerConcreteProperty = new short[this.numComponents][];
            newLowerAbstractProperty = new short[this.numComponents][];
            int component2 = 0;
            while (component2 < this.numComponents) {
                int j;
                short state;
                short[][] lowerAbstract1 = this.lowerAbstractProperty == null ? this.upperAbstractProperty : this.lowerAbstractProperty;
                short[][] lowerConcrete1 = this.lowerConcreteProperty == null ? this.upperConcreteProperty : this.lowerConcreteProperty;
                short[][] lowerAbstract2 = property.lowerAbstractProperty == null ? property.upperAbstractProperty : property.lowerAbstractProperty;
                short[][] lowerConcrete2 = property.lowerConcreteProperty == null ? property.upperConcreteProperty : property.lowerConcreteProperty;
                ShortArray newLowerConcrete = new ShortArray(this.abstraction[component2].getConcreteStateSpace().size());
                ShortArray newLowerAbstract = new ShortArray(this.abstraction[component2].size());
                int i = 0;
                while (i < lowerAbstract1[component2].length) {
                    state = lowerAbstract1[component2][i];
                    j = 0;
                    while (j < lowerAbstract2[component2].length) {
                        if (state == lowerAbstract2[component2][j]) {
                            newLowerAbstract.add(state);
                        }
                        ++j;
                    }
                    ++i;
                }
                i = 0;
                while (i < lowerConcrete1[component2].length) {
                    state = lowerConcrete1[component2][i];
                    j = 0;
                    while (j < lowerConcrete2[component2].length) {
                        if (state == lowerConcrete2[component2][j]) {
                            newLowerConcrete.add(state);
                        }
                        ++j;
                    }
                    ++i;
                }
                newLowerConcreteProperty[component2] = newLowerConcrete.toArray();
                newLowerAbstractProperty[component2] = newLowerAbstract.toArray();
                ++component2;
            }
        }
        newProperty.upperConcreteProperty = newUpperConcreteProperty;
        newProperty.upperAbstractProperty = newUpperAbstractProperty;
        newProperty.lowerConcreteProperty = newLowerConcreteProperty;
        newProperty.lowerAbstractProperty = newLowerAbstractProperty;
        return newProperty;
    }

    private CompositionalProperty computeSelectiveComplement(boolean[] components) {
        boolean allTrue = true;
        int i = 0;
        while (i < components.length) {
            allTrue = allTrue && components[i];
            ++i;
        }
        assert (!allTrue);
        CompositionalProperty newProperty = new CompositionalProperty(this.abstraction);
        short[][] abstractProperty = this.lowerAbstractProperty == null ? this.upperAbstractProperty : this.lowerAbstractProperty;
        short[][] concreteProperty = this.lowerConcreteProperty == null ? this.upperConcreteProperty : this.lowerConcreteProperty;
        short[][] newAbstractProperty = new short[this.numComponents][];
        short[][] newConcreteProperty = new short[this.numComponents][];
        int component = 0;
        while (component < this.numComponents) {
            if (components[component]) {
                newAbstractProperty[component] = new short[abstractProperty[component].length];
                System.arraycopy(abstractProperty[component], 0, newAbstractProperty[component], 0, abstractProperty[component].length);
                newConcreteProperty[component] = new short[concreteProperty[component].length];
                System.arraycopy(concreteProperty[component], 0, newConcreteProperty[component], 0, concreteProperty[component].length);
            } else {
                ShortArray newConcrete = new ShortArray(this.abstraction[component].getConcreteStateSpace().size());
                ShortArray newAbstract = new ShortArray(this.abstraction[component].size());
                AbstractState[] abstractStateSpace = this.abstraction[component].getAbstractStateSpace();
                int i2 = 0;
                while (i2 < abstractStateSpace.length) {
                    AbstractState state = abstractStateSpace[i2];
                    boolean is_in_complement = true;
                    int j = 0;
                    while (j < abstractProperty[component].length) {
                        if (state.getID() == abstractProperty[component][j]) {
                            is_in_complement = false;
                        }
                        ++j;
                    }
                    if (is_in_complement) {
                        newAbstract.add(state.getID());
                        newConcrete.add(state.getConcrete());
                    }
                    ++i2;
                }
                newConcreteProperty[component] = newConcrete.toArray();
                newAbstractProperty[component] = newAbstract.toArray();
            }
            ++component;
        }
        newProperty.upperConcreteProperty = newConcreteProperty;
        newProperty.upperAbstractProperty = newAbstractProperty;
        return newProperty;
    }

    public CompositionalPropertyList complement() {
        if (this.isTrue) {
            return new CompositionalPropertyList(new CompositionalProperty(this.abstraction, false));
        }
        if (this.isFalse) {
            return new CompositionalPropertyList(new CompositionalProperty(this.abstraction, true));
        }
        ArrayList<CompositionalProperty> newProperty = new ArrayList<CompositionalProperty>(10);
        boolean[] components = new boolean[this.numComponents];
        int i = 0;
        while (i < components.length) {
            components[i] = false;
            ++i;
        }
        int combinations = (1 << this.numComponents) - 1;
        int i2 = 0;
        while (i2 < combinations) {
            CompositionalProperty property = this.computeSelectiveComplement(components);
            if (property.isTrue()) {
                property.unregister();
                for (CompositionalProperty p : newProperty) {
                    p.unregister();
                }
                return new CompositionalPropertyList(new CompositionalProperty(this.abstraction, true));
            }
            if (!property.isFalse()) {
                newProperty.add(property);
            } else {
                property.unregister();
            }
            KroneckerUtilities.incrementBooleanArray(components);
            ++i2;
        }
        return new CompositionalPropertyList(newProperty, this.abstraction);
    }

    public short[][] getConcreteProperty() {
        return this.upperConcreteProperty;
    }

    public short[][] getAbstractProperty() {
        return this.upperAbstractProperty;
    }

    public SequentialAbstraction[] getAbstraction() {
        return this.abstraction;
    }

    public boolean isTrue() {
        if (this.isTrue) {
            return true;
        }
        if (this.isFalse) {
            return false;
        }
        short[][] abstractProperty = this.lowerAbstractProperty == null ? this.upperAbstractProperty : this.lowerAbstractProperty;
        boolean isOK = true;
        int component = 0;
        while (component < this.numComponents) {
            boolean isComponentOK = abstractProperty[component].length == this.abstraction[component].size();
            isOK = isOK && isComponentOK;
            ++component;
        }
        return isOK;
    }

    public boolean isFalse() {
        if (this.isTrue) {
            return false;
        }
        if (this.isFalse) {
            return true;
        }
        boolean isOK = false;
        int component = 0;
        while (component < this.numComponents) {
            boolean isComponentOK = this.upperAbstractProperty[component].length == 0;
            isOK = isOK || isComponentOK;
            ++component;
        }
        return isOK;
    }

    public short[] anyTrueState() {
        short[] state = new short[this.numComponents];
        int component = 0;
        while (component < this.numComponents) {
            if (this.upperAbstractProperty[component].length == 0) {
                return null;
            }
            state[component] = this.upperAbstractProperty[component][0];
            ++component;
        }
        return state;
    }

    public short[] anyFalseState() {
        short[] state = new short[this.numComponents];
        int component = 0;
        while (component < this.numComponents) {
            if (this.lowerAbstractProperty[component].length == this.abstraction[component].size()) {
                return null;
            }
            int i = 0;
            while (i < this.abstraction[component].size()) {
                boolean found = false;
                int j = 0;
                while (j < this.lowerAbstractProperty[component].length) {
                    if (this.lowerAbstractProperty[component][j] == i) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    state[component] = i;
                }
                i = (short)(i + 1);
            }
            ++component;
        }
        return state;
    }

    public CompositionalPropertyList split() {
        boolean[] allTrue = new boolean[this.numComponents];
        int[] maximum = new int[this.numComponents];
        int size = 1;
        int component = 0;
        while (component < this.numComponents) {
            maximum[component] = this.upperAbstractProperty[component].length;
            boolean bl = allTrue[component] = maximum[component] == this.abstraction[component].size();
            if (allTrue[component]) {
                maximum[component] = 1;
            }
            size *= maximum[component];
            ++component;
        }
        int[] current = new int[this.numComponents];
        ArrayList<CompositionalProperty> properties = new ArrayList<CompositionalProperty>(size);
        int i = 0;
        while (i < size) {
            short[][] splitProperty = new short[this.numComponents][];
            int component2 = 0;
            while (component2 < this.numComponents) {
                if (!allTrue[component2]) {
                    splitProperty[component2] = new short[1];
                    splitProperty[component2][0] = this.upperAbstractProperty[component2][current[component2]];
                } else {
                    splitProperty[component2] = this.upperAbstractProperty[component2];
                }
                ++component2;
            }
            properties.add(new CompositionalProperty(this.abstraction, splitProperty));
            KroneckerUtilities.incrementArray(current, maximum);
            ++i;
        }
        return new CompositionalPropertyList(properties, this.abstraction);
    }

    public boolean isSingleComponent() {
        int numPropertyComponents = 0;
        int component = 0;
        while (component < this.numComponents) {
            if (this.upperAbstractProperty[component].length < this.abstraction[component].size()) {
                ++numPropertyComponents;
            }
            ++component;
        }
        return numPropertyComponents == 1;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CompositionalProperty)) {
            return false;
        }
        CompositionalProperty property = (CompositionalProperty)o;
        if (this.abstraction != property.abstraction) {
            return false;
        }
        boolean lowerAbstract = false;
        if (this.lowerAbstractProperty == null && property.lowerAbstractProperty == null) {
            lowerAbstract = true;
        } else if (this.lowerAbstractProperty != null && property.lowerAbstractProperty != null) {
            lowerAbstract = Arrays.deepEquals((Object[])this.lowerAbstractProperty, (Object[])property.lowerAbstractProperty);
        }
        boolean upperAbstract = false;
        if (this.upperAbstractProperty == null && property.upperAbstractProperty == null) {
            upperAbstract = true;
        } else if (this.upperAbstractProperty != null && property.upperAbstractProperty != null) {
            upperAbstract = Arrays.deepEquals((Object[])this.upperAbstractProperty, (Object[])property.upperAbstractProperty);
        }
        return lowerAbstract && upperAbstract;
    }

    public String toString() {
        if (this.isTrue) {
            return "Property: TRUE";
        }
        if (this.isFalse) {
            return "Property: FALSE";
        }
        String upperConcrete = Arrays.deepToString((Object[])this.upperConcreteProperty);
        String upperAbstract = Arrays.deepToString((Object[])this.upperAbstractProperty);
        String lowerConcrete = this.lowerConcreteProperty == null ? "[]" : Arrays.deepToString((Object[])this.lowerConcreteProperty);
        String lowerAbstract = this.lowerAbstractProperty == null ? "[]" : Arrays.deepToString((Object[])this.lowerAbstractProperty);
        return "Upper Concrete: " + upperConcrete + "\nUpper Abstract: " + upperAbstract + "\nLower Concrete: " + lowerConcrete + "\nLower Abstract: " + lowerAbstract;
    }
}

