/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.modelchecking.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import uk.ac.ed.inf.pepa.ctmc.kronecker.KroneckerDisplayPropertyMap;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLAbstractStateProperty;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLAtomicNode;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.IPropertyChangedListener;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.PropertyDependencyException;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.AtomicProperty;

public class PropertyBank {
    private int numComponents;
    private ArrayList<KroneckerDisplayPropertyMap> registeredMaps;
    private ArrayList<IPropertyChangedListener> listeners;
    private HashMap<String, AtomicProperty> atomicProperties;
    private HashMap<String, CSLAbstractStateProperty> CSLProperties;
    private HashMap<String, String> CSLValues;

    public PropertyBank(int numComponents) {
        this.numComponents = numComponents;
        this.registeredMaps = new ArrayList(10);
        this.listeners = new ArrayList(10);
        this.atomicProperties = new HashMap(10);
        this.CSLProperties = new HashMap();
        this.CSLValues = new HashMap();
    }

    public void register(KroneckerDisplayPropertyMap propertyMap) {
        this.registeredMaps.add(propertyMap);
    }

    public void addPropertyChangedListener(IPropertyChangedListener propertyChangedListener) {
        if (this.listeners.contains(propertyChangedListener)) {
            return;
        }
        this.listeners.add(propertyChangedListener);
    }

    private void notifyPropertyChanged() {
        for (IPropertyChangedListener listener : this.listeners) {
            listener.handlePropertiesChanged();
        }
    }

    private String getNewPropertyName() {
        String newName = "New Property ";
        int i = 1;
        while (this.atomicProperties.containsKey(String.valueOf(newName) + i)) {
            ++i;
        }
        return String.valueOf(newName) + i;
    }

    public String addAtomicProperty(String name) {
        if (this.atomicProperties.containsKey(name)) {
            return null;
        }
        AtomicProperty property = new AtomicProperty(this.numComponents);
        this.atomicProperties.put(name, property);
        for (KroneckerDisplayPropertyMap propertyMap : this.registeredMaps) {
            propertyMap.notifyAddProperty(name, property);
        }
        return name;
    }

    public String addAtomicProperty() {
        return this.addAtomicProperty(this.getNewPropertyName());
    }

    public String renameAtomicProperty(String oldName, String newName) {
        if (newName.length() == 0 || this.atomicProperties.containsKey(newName)) {
            return oldName;
        }
        AtomicProperty atom = this.atomicProperties.remove(oldName);
        this.atomicProperties.put(newName, atom);
        ArrayList<CSLAtomicNode> atomicNodes = new ArrayList<CSLAtomicNode>(10);
        for (CSLAbstractStateProperty property : this.CSLProperties.values()) {
            property.getAtomicNodes(atomicNodes);
        }
        for (CSLAtomicNode atomic : atomicNodes) {
            atomic.rename(oldName, newName);
        }
        for (KroneckerDisplayPropertyMap propertyMap : this.registeredMaps) {
            propertyMap.notifyRenameProperty(oldName, newName);
        }
        this.notifyPropertyChanged();
        return newName;
    }

    public void removeAtomicProperty(String name) throws PropertyDependencyException {
        boolean canRemove = true;
        ArrayList<CSLAtomicNode> atomicNodes = new ArrayList<CSLAtomicNode>(10);
        for (CSLAbstractStateProperty property : this.CSLProperties.values()) {
            property.getAtomicNodes(atomicNodes);
        }
        for (CSLAtomicNode atomic : atomicNodes) {
            if (!name.equals(atomic.toString())) continue;
            canRemove = false;
        }
        if (canRemove) {
            this.atomicProperties.remove(name);
            for (KroneckerDisplayPropertyMap propertyMap : this.registeredMaps) {
                propertyMap.notifyRemoveProperty(name);
            }
        } else {
            throw new PropertyDependencyException();
        }
    }

    public String[] getAtomicPropertyNames() {
        Object[] properties = new String[this.atomicProperties.size()];
        this.atomicProperties.keySet().toArray(properties);
        Arrays.sort(properties);
        return properties;
    }

    public boolean containsCSLPropertyName(String name) {
        return this.CSLProperties.containsKey(name);
    }

    public boolean addCSLProperty(String name, CSLAbstractStateProperty property) {
        if (this.CSLProperties.containsKey(name)) {
            return false;
        }
        this.CSLProperties.put(name, property);
        return true;
    }

    public void removeCSLProperty(String name) {
        this.CSLProperties.remove(name);
        this.removeCSLPropertyValue(name);
    }

    public boolean changeCSLProperty(String oldName, CSLAbstractStateProperty oldProperty, String newName, CSLAbstractStateProperty newProperty) {
        if (!oldName.equals(newName) && this.CSLProperties.containsKey(newName)) {
            return false;
        }
        this.CSLProperties.remove(oldName);
        this.CSLProperties.put(newName, newProperty);
        if (newProperty.equals(oldProperty)) {
            this.renameCSLPropertyValue(oldName, newName);
        } else {
            this.removeCSLPropertyValue(oldName);
        }
        return true;
    }

    public String[] getCSLPropertyNames() {
        Object[] names = new String[this.CSLProperties.size()];
        this.CSLProperties.keySet().toArray(names);
        Arrays.sort(names);
        return names;
    }

    private void renameCSLPropertyValue(String oldName, String newName) {
        String value = this.CSLValues.remove(oldName);
        if (value != null) {
            this.CSLValues.put(newName, value);
        }
    }

    private void removeCSLPropertyValue(String name) {
        this.CSLValues.remove(name);
    }

    public void clearCSLPropertyValues() {
        this.CSLValues.clear();
    }

    public String getCSLPropertyValue(String name) {
        return this.CSLValues.get(name);
    }

    public void setCSLPropertyValue(String name, String value) {
        this.CSLValues.put(name, value);
    }

    public void notifyCSLPropertyValueChanged(String name) {
        block0: for (Map.Entry<String, CSLAbstractStateProperty> entry : this.CSLProperties.entrySet()) {
            String propertyName = entry.getKey();
            CSLAbstractStateProperty property = entry.getValue();
            ArrayList<CSLAtomicNode> atomicNodes = new ArrayList<CSLAtomicNode>(10);
            property.getAtomicNodes(atomicNodes);
            for (CSLAtomicNode atomic : atomicNodes) {
                if (!name.equals(atomic.toString())) continue;
                this.removeCSLPropertyValue(propertyName);
                continue block0;
            }
        }
        this.notifyPropertyChanged();
    }

    public CSLAbstractStateProperty getCSLProperty(String name) {
        if (this.CSLProperties.containsKey(name)) {
            return this.CSLProperties.get(name);
        }
        return null;
    }

    public AtomicProperty getAtomicProperty(String name) {
        return this.atomicProperties.get(name);
    }
}

