/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.modelchecking.internal;

import java.util.ArrayList;
import java.util.HashSet;
import uk.ac.ed.inf.pepa.IProgressMonitor;
import uk.ac.ed.inf.pepa.ctmc.abstraction.SequentialAbstraction;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.ShortArray;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.KroneckerStateSpace;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.AbstractBoolean;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLAbstractStateProperty;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.ModelCheckingException;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.ProbabilityInterval;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.AbstractCTMC;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.AbstractCTMCProperty;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.AbstractCTMCState;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.CSLPropertyManager;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.CompositionalProperty;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.CompositionalPropertyList;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.ModelCheckingLog;
import uk.ac.ed.inf.pepa.ctmc.solution.ISolver;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.ctmc.solution.SolverException;
import uk.ac.ed.inf.pepa.ctmc.solution.SolverFactory;

public class SteadyStateAnalyser {
    private KroneckerStateSpace stateSpace;
    private SequentialAbstraction[] abstraction;
    private AbstractCTMC abstractCTMC;
    private CSLPropertyManager propertyManager;
    private ModelCheckingLog eventLog;

    public SteadyStateAnalyser(KroneckerStateSpace stateSpace, AbstractCTMC abstractCTMC, CSLPropertyManager propertyManager, SequentialAbstraction[] abstraction, ModelCheckingLog eventLog) {
        this.stateSpace = stateSpace;
        this.abstraction = abstraction;
        this.abstractCTMC = abstractCTMC;
        this.propertyManager = propertyManager;
        this.eventLog = eventLog;
    }

    public ProbabilityInterval checkSteadyState(CSLAbstractStateProperty property, OptionMap optionMap, IProgressMonitor monitor) throws ModelCheckingException {
        CompositionalProperty lowerProperty;
        CompositionalProperty upperProperty;
        int i;
        int numComponents = this.stateSpace.getDisplayModel().getNumComponents();
        if (!this.isAbstracted()) {
            AbstractCTMCProperty trueStates = new AbstractCTMCProperty(this.abstractCTMC);
            for (AbstractCTMCState state : this.abstractCTMC) {
                AbstractBoolean value = this.propertyManager.test(property, state);
                if (value != AbstractBoolean.TRUE && value != AbstractBoolean.MAYBE) continue;
                trueStates.addState(state);
            }
            return this.concreteSteadyStateInterval(trueStates, optionMap, monitor);
        }
        ArrayList maybeTrueSet = new ArrayList(numComponents);
        ArrayList maybeFalseSet = new ArrayList(numComponents);
        int i2 = 0;
        while (i2 < numComponents) {
            maybeTrueSet.add(new HashSet());
            maybeFalseSet.add(new HashSet());
            ++i2;
        }
        for (AbstractCTMCState state : this.abstractCTMC) {
            AbstractBoolean value = this.propertyManager.test(property, state);
            short[] stateID = state.getState();
            if (value == AbstractBoolean.TRUE) {
                i = 0;
                while (i < numComponents) {
                    ((HashSet)maybeTrueSet.get(i)).add(stateID[i]);
                    ++i;
                }
                continue;
            }
            if (value == AbstractBoolean.FALSE) {
                i = 0;
                while (i < numComponents) {
                    ((HashSet)maybeFalseSet.get(i)).add(stateID[i]);
                    ++i;
                }
                continue;
            }
            if (value != AbstractBoolean.MAYBE) continue;
            i = 0;
            while (i < numComponents) {
                ((HashSet)maybeTrueSet.get(i)).add(stateID[i]);
                ((HashSet)maybeFalseSet.get(i)).add(stateID[i]);
                ++i;
            }
        }
        short[][] trueProperty = new short[numComponents][];
        short[][] falseProperty = new short[numComponents][];
        boolean isMaybeTrueEmpty = false;
        boolean isMaybeFalseEmpty = false;
        i = 0;
        while (i < numComponents) {
            HashSet maybeTrue = (HashSet)maybeTrueSet.get(i);
            if (maybeTrue.size() == 0) {
                isMaybeTrueEmpty = true;
            } else {
                HashSet maybeFalse = (HashSet)maybeFalseSet.get(i);
                if (maybeFalse.size() == 0) {
                    isMaybeFalseEmpty = true;
                } else {
                    ShortArray trueStates = new ShortArray(10);
                    ShortArray falseStates = new ShortArray(10);
                    short j = 0;
                    while (j < this.abstraction[i].size()) {
                        if (maybeTrue.contains(j)) {
                            trueStates.add(j);
                        }
                        if (maybeFalse.contains(j)) {
                            falseStates.add(j);
                        }
                        j = (short)(j + 1);
                    }
                    trueProperty[i] = trueStates.toArray();
                    falseProperty[i] = falseStates.toArray();
                }
            }
            ++i;
        }
        if (isMaybeTrueEmpty) {
            lowerProperty = upperProperty = new CompositionalProperty(this.abstraction, false);
        } else if (isMaybeFalseEmpty) {
            lowerProperty = upperProperty = new CompositionalProperty(this.abstraction, true);
        } else {
            upperProperty = new CompositionalProperty(this.abstraction, trueProperty);
            lowerProperty = new CompositionalProperty(this.abstraction, falseProperty);
        }
        return this.abstractSteadyStateInterval(new CompositionalPropertyList(lowerProperty), new CompositionalPropertyList(upperProperty), optionMap, monitor);
    }

    public ProbabilityInterval checkSteadyState(CompositionalPropertyList property, OptionMap optionMap, IProgressMonitor monitor) throws ModelCheckingException {
        if (!this.isAbstracted()) {
            return this.concreteSteadyStateInterval(property, optionMap, monitor);
        }
        CompositionalPropertyList lowerProperty = property.complement();
        return this.abstractSteadyStateInterval(lowerProperty, property, optionMap, monitor);
    }

    private ProbabilityInterval concreteSteadyStateInterval(AbstractCTMCProperty property, OptionMap optionMap, IProgressMonitor monitor) throws ModelCheckingException {
        double[] solution = this.solve(this.stateSpace, optionMap, monitor);
        double probability = this.steadyStateProbability(this.stateSpace, solution, property);
        return new ProbabilityInterval(probability, probability);
    }

    private ProbabilityInterval concreteSteadyStateInterval(CompositionalPropertyList properties, OptionMap optionMap, IProgressMonitor monitor) throws ModelCheckingException {
        double[] solution = this.solve(this.stateSpace, optionMap, monitor);
        double probability = 0.0;
        for (CompositionalProperty property : properties) {
            if (property.isTrue()) {
                probability = 1.0;
                break;
            }
            if (property.isFalse()) continue;
            probability += this.steadyStateProbability(this.stateSpace, solution, property.getConcreteProperty());
        }
        properties.unregister();
        return new ProbabilityInterval(probability, probability);
    }

    private ProbabilityInterval abstractSteadyStateInterval(CompositionalPropertyList lowerProperty, CompositionalPropertyList upperProperty, OptionMap optionMap, IProgressMonitor monitor) throws ModelCheckingException {
        double upperProbability = 0.0;
        double lowerProbability = 0.0;
        if (upperProperty.isFalse()) {
            lowerProbability = 0.0;
            upperProbability = 0.0;
        } else if (lowerProperty.isTrue()) {
            lowerProbability = 1.0;
            upperProbability = 1.0;
        } else {
            if (!upperProperty.isSingleComponent()) {
                upperProperty.unregister();
                upperProperty = upperProperty.split();
            }
            if (!lowerProperty.isSingleComponent()) {
                lowerProperty.unregister();
                lowerProperty = lowerProperty.split();
            }
            for (CompositionalProperty property : upperProperty) {
                if (property.isTrue()) {
                    upperProbability += 1.0;
                    continue;
                }
                if (property.isFalse()) continue;
                KroneckerStateSpace upperStateSpace = this.stateSpace.getUpperBoundingStateSpace(property);
                double[] upperSolution = this.solve(upperStateSpace, optionMap, monitor);
                upperProbability += this.steadyStateProbability(upperStateSpace, upperSolution, property.getAbstractProperty());
            }
            upperProbability = Math.min(1.0, upperProbability);
            for (CompositionalProperty property : lowerProperty) {
                if (property.isTrue()) {
                    lowerProbability += 1.0;
                    continue;
                }
                if (property.isFalse()) continue;
                KroneckerStateSpace lowerStateSpace = this.stateSpace.getUpperBoundingStateSpace(property);
                double[] lowerSolution = this.solve(lowerStateSpace, optionMap, monitor);
                lowerProbability += this.steadyStateProbability(lowerStateSpace, lowerSolution, property.getAbstractProperty());
            }
            lowerProbability = Math.max(0.0, 1.0 - lowerProbability);
        }
        upperProperty.unregister();
        lowerProperty.unregister();
        return new ProbabilityInterval(lowerProbability, upperProbability);
    }

    private double steadyStateProbability(KroneckerStateSpace stateSpace, double[] solution, short[][] property) throws ModelCheckingException {
        double probability = 0.0;
        int i = 0;
        while (i < solution.length) {
            short[] state = stateSpace.getSystemState(i);
            boolean isOK = true;
            int j = 0;
            while (j < state.length) {
                boolean isComponentOK = false;
                int k = 0;
                while (k < property[j].length) {
                    if (property[j][k] == state[j]) {
                        isComponentOK = true;
                        break;
                    }
                    ++k;
                }
                isOK = isOK && isComponentOK;
                ++j;
            }
            if (isOK) {
                probability += solution[i];
            }
            ++i;
        }
        return probability;
    }

    private double steadyStateProbability(KroneckerStateSpace stateSpace, double[] solution, AbstractCTMCProperty property) throws ModelCheckingException {
        double probability = 0.0;
        int i = 0;
        while (i < solution.length) {
            AbstractCTMCState state = new AbstractCTMCState(stateSpace.getSystemState(i));
            if (property.containsState(state)) {
                probability += solution[i];
            }
            if (probability > 1.0) break;
            ++i;
        }
        return Math.max(1.0, probability);
    }

    private double[] solve(KroneckerStateSpace stateSpace, OptionMap optionMap, IProgressMonitor monitor) throws ModelCheckingException {
        ISolver solver = SolverFactory.createSolver(stateSpace, optionMap);
        try {
            double[] solution = solver.solve(monitor);
            this.eventLog.addEntry("Solved a CTMC of size " + solution.length);
            return solution;
        }
        catch (SolverException e) {
            e.printStackTrace();
            throw new ModelCheckingException("Unable to solve the steady state distribution.");
        }
    }

    private boolean isAbstracted() {
        boolean isAbstracted = false;
        int i = 0;
        while (i < this.abstraction.length) {
            if (this.abstraction[i].isAbstracted()) {
                isAbstracted = true;
                break;
            }
            ++i;
        }
        return isAbstracted;
    }
}

