/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.solution;

import java.io.IOException;
import java.util.BitSet;
import uk.ac.ed.inf.pepa.ctmc.derivation.DerivationException;
import uk.ac.ed.inf.pepa.ctmc.derivation.IFilterRunner;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpace;
import uk.ac.ed.inf.pepa.ctmc.derivation.filters.ActionsFilter;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.jhydra.driver.passagetimesolver.PassageTimeResults;
import uk.ac.ed.inf.pepa.jhydra.driver.passagetimesolver.PassageTimeSolver;
import uk.ac.ed.inf.pepa.jhydra.driver.steadystatesolver.SteadyStateSolver;
import uk.ac.ed.inf.pepa.jhydra.matrix.Matrix;
import uk.ac.ed.inf.pepa.jhydra.matrix.MatrixElement;
import uk.ac.ed.inf.pepa.jhydra.matrix.MatrixRow;
import uk.ac.ed.inf.pepa.parsing.ModelNode;
import uk.ac.ed.inf.pepa.tools.PepaTools;

public class PepaJHydra {
    private String modelFileName;
    private ModelNode modelNode;
    private double startTime = 0.1;
    private double timeStep = 0.1;
    private double stopTime = 10.0;
    private String[] sourceActions;
    private String[] targetActions;

    public PepaJHydra(String fileName, ModelNode modelNode) {
        this.modelNode = modelNode;
        this.modelFileName = fileName;
    }

    public void setStartTime(double startTime) {
        this.startTime = startTime;
    }

    public void setTimeStep(double timeStep) {
        this.timeStep = timeStep;
    }

    public void setStopTime(double stopTime) {
        this.stopTime = stopTime;
    }

    public void setSourceActions(String[] actions2) {
        this.sourceActions = actions2;
    }

    public void setTargetActions(String[] actions2) {
        this.targetActions = actions2;
    }

    public PassageTimeResults performPassageTime(String cdfName, String pdfName) throws IOException, DerivationException {
        IStateSpace stateSpace = PepaTools.derive(new OptionMap(), this.modelNode, null, null);
        Matrix myMatrix = new Matrix();
        BitSet sourceStates = new BitSet(stateSpace.size());
        sourceStates.clear();
        BitSet targetStates = new BitSet(stateSpace.size());
        targetStates.clear();
        ActionsFilter sourceActFilter = new ActionsFilter(this.sourceActions, true);
        IFilterRunner srcFilterRunner = sourceActFilter.getRunner(stateSpace);
        ActionsFilter targetActFilter = new ActionsFilter(this.targetActions, true);
        IFilterRunner tgtFilterRunner = targetActFilter.getRunner(stateSpace);
        int i = 0;
        while (i < stateSpace.size()) {
            int[] targetStateIndices = stateSpace.getOutgoingStateIndices(i);
            MatrixRow newRow = new MatrixRow(i);
            if (srcFilterRunner.select(i)) {
                sourceStates.set(i);
            } else if (tgtFilterRunner.select(i)) {
                targetStates.set(i);
            }
            int[] nArray = targetStateIndices;
            int n = targetStateIndices.length;
            int n2 = 0;
            while (n2 < n) {
                int target = nArray[n2];
                double rate = stateSpace.getRate(i, target);
                MatrixElement matrixElement = new MatrixElement(target, rate);
                newRow.add(matrixElement);
                ++n2;
            }
            myMatrix.addRow(newRow, i);
            ++i;
        }
        myMatrix.print();
        myMatrix.columnify();
        SteadyStateSolver mySteadyStateSolver = new SteadyStateSolver(myMatrix);
        double[] alphaVector = mySteadyStateSolver.solve(sourceStates);
        PassageTimeSolver myPassageTimeSolver = new PassageTimeSolver(myMatrix, alphaVector, targetStates, this.startTime, this.stopTime, this.timeStep);
        PassageTimeResults ptResults = myPassageTimeSolver.uniformise(this.modelFileName, cdfName, pdfName);
        return ptResults;
    }

    private static String getProcessString(IStateSpace stateSpace, int stateIndex) {
        StringBuffer buf = new StringBuffer();
        String separator = " | ";
        int i = 0;
        while (i < stateSpace.getMaximumNumberOfSequentialComponents()) {
            buf.append(stateSpace.getLabel(stateIndex, i));
            if (i < stateSpace.getMaximumNumberOfSequentialComponents() - 1) {
                buf.append(separator);
            }
            ++i;
        }
        return buf.toString();
    }
}

