/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.solution;

import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.sparse.AbstractIterativeSolver;
import no.uib.cipr.matrix.sparse.FlexCompRowMatrix;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpace;
import uk.ac.ed.inf.pepa.ctmc.solution.ISolver;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.ctmc.solution.internal.hydra.SteadyStateAnalyser;
import uk.ac.ed.inf.pepa.ctmc.solution.internal.mtj.DirectSolver;
import uk.ac.ed.inf.pepa.ctmc.solution.internal.mtj.MTJFactory;
import uk.ac.ed.inf.pepa.ctmc.solution.internal.mtj.MTJSolver;
import uk.ac.ed.inf.pepa.ctmc.solution.internal.simple.CGS;
import uk.ac.ed.inf.pepa.ctmc.solution.internal.simple.GaussSeidel;
import uk.ac.ed.inf.pepa.ctmc.solution.internal.simple.Generator;
import uk.ac.ed.inf.pepa.ctmc.solution.internal.simple.JacobiSolver;

public class SolverFactory {
    public static ISolver createSolver(IStateSpace stateSpace, OptionMap options) {
        int solverId;
        if (stateSpace == null) {
            throw new NullPointerException();
        }
        if (options == null) {
            options = new OptionMap();
        }
        if ((solverId = ((Integer)options.get("ctmc.steadystate.solver")).intValue()) == 12) {
            SteadyStateAnalyser hydraSolver = new SteadyStateAnalyser(stateSpace, options);
            return hydraSolver;
        }
        if (solverId == 9 || solverId == 10 || solverId == 11) {
            Generator generator = (Generator)stateSpace.getGeneratorMatrix(Generator.class);
            if (generator == null) {
                throw new IllegalArgumentException("Could not create solver");
            }
            if (solverId == 9) {
                return new JacobiSolver(generator, options);
            }
            if (solverId == 10) {
                return new GaussSeidel(generator, options);
            }
            if (solverId == 11) {
                return new CGS(generator, options);
            }
            throw new IllegalArgumentException();
        }
        return SolverFactory.handleMTJSolver(stateSpace, options);
    }

    private static ISolver handleMTJSolver(IStateSpace stateSpace, OptionMap options) {
        FlexCompRowMatrix generator = (FlexCompRowMatrix)stateSpace.getGeneratorMatrix(FlexCompRowMatrix.class);
        if (generator == null) {
            return null;
        }
        SolverFactory.prepareGeneratorForSolution(generator);
        DenseVector b = new DenseVector(stateSpace.size());
        b.set(stateSpace.size() - 1, 1.0);
        DenseVector x = new DenseVector(stateSpace.size());
        int solverId = (Integer)options.get("ctmc.steadystate.solver");
        ISolver solver = null;
        if (solverId == 7) {
            solver = new DirectSolver(generator, b, x);
        } else {
            AbstractIterativeSolver s = MTJFactory.createSolver(solverId, x, options);
            solver = new MTJSolver(s, (Matrix)generator, b, x, options);
        }
        return solver;
    }

    private static void prepareGeneratorForSolution(FlexCompRowMatrix generator) {
        int size = generator.numRows();
        SolverFactory.diagonalSetup(generator);
        generator.transpose();
        int column = 0;
        while (column < size) {
            generator.set(size - 1, column, 1.0);
            ++column;
        }
    }

    private static void diagonalSetup(FlexCompRowMatrix generator) {
        int size = generator.numRows();
        int i = 0;
        while (i < size) {
            double sum = 0.0;
            int j = 0;
            while (j < size) {
                sum += generator.get(i, j);
                ++j;
            }
            generator.set(i, i, -(sum -= generator.get(i, i)));
            ++i;
        }
    }
}

