/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.solution.internal.hydra;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.FlexCompColMatrix;
import no.uib.cipr.matrix.sparse.SparseVector;
import uk.ac.ed.inf.pepa.DoNothingMonitor;
import uk.ac.ed.inf.pepa.IProgressMonitor;
import uk.ac.ed.inf.pepa.ctmc.ThroughputResult;
import uk.ac.ed.inf.pepa.ctmc.derivation.DerivationException;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpace;
import uk.ac.ed.inf.pepa.ctmc.solution.ISolver;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.ctmc.solution.SolverException;
import uk.ac.ed.inf.pepa.ctmc.solution.SolverFactory;
import uk.ac.ed.inf.pepa.parsing.ASTNode;
import uk.ac.ed.inf.pepa.parsing.ModelNode;
import uk.ac.ed.inf.pepa.tools.PepaTools;

public class SteadyStateAnalyser
implements ISolver {
    private static final boolean DEBUG = false;
    private long trans;
    private int maxIterations = 5000;
    private double accuracy = 1.0E-10;
    private double EPS = 2.22045E-16;
    private int tangible;
    private MatrixType solver;
    private FlexCompColMatrix Q;
    private FlexCompColMatrix QC;
    private double[] ai_b;
    private double[] ai_d;
    private double ai_start;
    private IStateSpace stateSpace;
    private double[] scale;

    public SteadyStateAnalyser(IStateSpace ss, OptionMap map) {
        if (map == null) {
            map = new OptionMap();
        }
        this.stateSpace = ss;
        this.accuracy = (Double)map.get("cmtc.hydra.accuracy");
        this.maxIterations = (Integer)map.get("ctmc.hydra.max_iter");
        this.tangible = ss.size();
        this.solver = MatrixType.COLUMN;
        this.Q = this.QC = new FlexCompColMatrix(this.tangible, this.tangible);
        this.scale = new double[this.tangible];
    }

    private void readStatesQC() {
        int states = 0;
        int n = 0;
        double weight = 0.0;
        double sum = 0.0;
        double factor = 0.0;
        this.ai_b = new double[this.tangible];
        this.ai_d = new double[this.tangible];
        this.ai_start = 0.0;
        n = 0;
        while (n < this.tangible) {
            this.ai_d[n] = 0.0;
            this.ai_b[n] = 0.0;
            ++n;
        }
        int i = 0;
        while (i < this.tangible) {
            int j;
            int[] jj;
            sum = 0.0;
            int[] nArray = jj = this.stateSpace.getOutgoingStateIndices(i);
            int n2 = jj.length;
            int n3 = 0;
            while (n3 < n2) {
                j = nArray[n3];
                sum += this.stateSpace.getRate(i, j);
                ++n3;
            }
            factor = 1.0 / sum;
            nArray = jj;
            n2 = jj.length;
            n3 = 0;
            while (n3 < n2) {
                j = nArray[n3];
                weight = this.stateSpace.getRate(i, j) * factor;
                if (j > states) {
                    int n4 = states;
                    this.ai_b[n4] = this.ai_b[n4] + weight;
                } else {
                    int n5 = states;
                    this.ai_d[n5] = this.ai_d[n5] + weight;
                }
                this.QC.add(i, j, weight);
                ++n3;
            }
            if (states == 0) {
                nArray = jj;
                n2 = jj.length;
                n3 = 0;
                while (n3 < n2) {
                    j = nArray[n3];
                    weight = this.stateSpace.getRate(i, j) * factor;
                    if (j > 1) {
                        this.ai_start += weight;
                    }
                    ++n3;
                }
            }
            this.scale[states] = factor;
            this.trans += (long)jj.length;
            ++states;
            ++i;
        }
    }

    public double[] solve(IProgressMonitor monitor) throws SolverException {
        double residInfNorm;
        double res_i;
        double sol_i;
        this.readStatesQC();
        if (monitor == null) {
            monitor = new DoNothingMonitor();
        }
        monitor.beginTask(this.maxIterations);
        double[] solutionArray = new double[this.tangible];
        solutionArray[0] = 1.0 / (double)this.tangible;
        int i = 1;
        while (i < this.tangible) {
            solutionArray[i] = solutionArray[0];
            ++i;
        }
        DenseVector solution = new DenseVector(solutionArray);
        double omega = 1.0;
        double convergence = 1.0;
        int iterations = 0;
        double[] last = new double[this.tangible];
        DenseVector result = new DenseVector(solutionArray);
        double tol = this.EPS / (double)this.tangible;
        int[] count = new int[41];
        int index = 0;
        int maxIndex = 0;
        boolean stop = false;
        double[] average = new double[41];
        double max = 0.0;
        int i2 = 0;
        while (i2 < 41) {
            count[i2] = 0;
            average[i2] = 0.0;
            ++i2;
        }
        double QC01 = this.QC.get(0, 1);
        double QCnn = this.QC.get(this.tangible - 1, this.tangible - 1);
        double QCnn_1 = this.QC.get(this.tangible - 1, this.tangible - 2);
        i2 = 0;
        while (i2 < this.tangible) {
            last[i2] = solution.get(i2);
            ++i2;
        }
        this.Q.transMult((Vector)solution, (Vector)result);
        i2 = 0;
        while (i2 < this.tangible) {
            sol_i = solution.get(i2);
            res_i = result.get(i2);
            result.set(i2, res_i - sol_i);
            ++i2;
        }
        double lastResidInfNorm = result.norm(Vector.Norm.Infinity);
        while (iterations < this.maxIterations && convergence > this.accuracy) {
            double cc;
            int k;
            if (monitor.isCanceled()) {
                throw new SolverException("Operation cancelled by the user.", -1);
            }
            if (iterations > 0 && iterations % 5 == 0) {
                monitor.worked(5);
            }
            double l = solution.get(0);
            double u = 1.0 - (solution.get(0) + solution.get(1));
            double c = QC01;
            double aa = this.ai_start * l;
            double a = this.ai_start;
            SparseVector _col = this.QC.getColumn(0);
            double ff = 0.0;
            int rk = 0;
            while (rk < _col.getIndex().length) {
                k = _col.getIndex()[rk];
                if (k > 1) {
                    ff += solution.get(k) * _col.getData()[rk];
                }
                ++rk;
            }
            double f = ff / u;
            _col = this.QC.getColumn(1);
            double ee = 0.0;
            rk = 0;
            while (rk < _col.getIndex().length) {
                k = _col.getIndex()[rk];
                if (k > 1) {
                    ee += solution.get(k) * _col.getData()[rk];
                }
                ++rk;
            }
            double e = ee / u;
            double b = this.ai_b[1];
            double d = this.ai_d[1];
            double sum = 1.0 / (e + f);
            double pi = (c += (a *= sum) * e) / (d += (b *= sum) * f);
            double _u = a + pi * b;
            l = sum = 1.0 / (1.0 + pi + _u);
            pi *= sum;
            if (l < tol) {
                l = tol;
            }
            if (pi < tol) {
                pi = tol;
            }
            solution.set(0, l);
            solution.set(1, pi);
            l = solution.get(0) + solution.get(1);
            i2 = 2;
            while (i2 < this.tangible - 2) {
                _col = this.QC.getColumn(i2);
                d = this.ai_d[i2];
                ff = ff + ee - solution.get(i2) * d;
                f = ff / (u -= solution.get(i2));
                cc = 0.0;
                ee = 0.0;
                rk = 0;
                while (rk < _col.getIndex().length) {
                    k = _col.getIndex()[rk];
                    if (k < i2) {
                        cc += solution.get(k) * _col.getData()[rk];
                    } else if (k > i2) {
                        ee += solution.get(k) * _col.getData()[rk];
                    }
                    ++rk;
                }
                c = cc / l;
                e = ee / u;
                aa = aa - cc + solution.get(i2 - 1) * this.ai_b[i2 - 1];
                a = aa / l;
                sum = 1.0 / (e + f);
                b = this.ai_b[i2];
                pi = (c += (a *= sum) * e) / (d += (b *= sum) * f);
                _u = a + pi * b;
                l = sum = 1.0 / (1.0 + pi + _u);
                if ((pi *= sum) < tol) {
                    pi = tol;
                }
                solution.set(i2, pi);
                l += solution.get(i2);
                ++i2;
            }
            u -= solution.get(this.tangible - 2);
            i2 = this.tangible - 2;
            d = this.ai_d[i2];
            _col = this.QC.getColumn(i2);
            cc = 0.0;
            rk = 0;
            while (rk < _col.getIndex().length) {
                k = _col.getIndex()[rk];
                if (k < i2) {
                    cc += solution.get(k) * _col.getData()[rk];
                }
                ++rk;
            }
            c = cc / l;
            aa = aa + solution.get(i2 - 1) * this.ai_b[i2 - 1] - cc;
            a = aa / l;
            e = QCnn_1;
            f = 1.0 - (QCnn + e);
            b = this.ai_b[i2];
            sum = 1.0 / (e + f);
            pi = (c += (a *= sum) * e) / (d += (b *= sum) * f);
            u = a + pi * b;
            l = sum = 1.0 / (1.0 + pi + u);
            pi *= sum;
            u *= sum;
            if (pi < tol) {
                pi = tol;
            }
            if (u < tol) {
                u = tol;
            }
            solution.set(this.tangible - 2, pi);
            solution.set(this.tangible - 1, u);
            this.normalise((Vector)solution);
            i2 = 0;
            while (i2 < this.tangible) {
                solution.set(i2, (1.0 - omega) * last[i2] + omega * solution.get(i2));
                if (solution.get(i2) < tol) {
                    solution.set(i2, tol);
                }
                ++i2;
            }
            this.normalise((Vector)solution);
            if (++iterations % 5 == 0) continue;
            double maxDiff = 0.0;
            double solNorm = 0.0;
            i2 = 0;
            while (i2 < this.tangible) {
                if (Math.abs(solution.get(i2)) > solNorm) {
                    solNorm = Math.abs(solution.get(i2));
                }
                if (Math.abs(solution.get(i2) - last[i2]) > maxDiff) {
                    maxDiff = Math.abs(solution.get(i2) - last[i2]);
                }
                last[i2] = solution.get(i2);
                ++i2;
            }
            convergence = maxDiff != 0.0 ? maxDiff / solNorm : 0.0;
            residInfNorm = 0.0;
            this.QC.transMult((Vector)solution, (Vector)result);
            i2 = 0;
            while (i2 < this.tangible) {
                sol_i = solution.get(i2);
                res_i = result.get(i2);
                result.set(i2, res_i - sol_i);
                if (Math.abs(result.get(i2)) > residInfNorm) {
                    residInfNorm = Math.abs(result.get(i2));
                }
                ++i2;
            }
            double improve = (lastResidInfNorm - residInfNorm) / lastResidInfNorm;
            if (improve < 0.0) {
                improve = 0.0;
            }
            average[index] = count[index] != 0 ? improve : (improve > average[index] ? 0.1 * average[index] + 0.9 * improve : 0.3 * average[index] + 0.7 * improve);
            if (average[index] > max) {
                max = average[index];
                maxIndex = index;
            } else {
                max = 0.0;
                i2 = 0;
                while (i2 < 41) {
                    if (average[i2] > max) {
                        max = average[i2];
                        maxIndex = i2;
                    }
                    ++i2;
                }
            }
            int n = index;
            count[n] = count[n] + 1;
            if (improve <= 0.0 && iterations > 5) {
                stop = true;
            }
            if (iterations < 200 && stop) {
                omega += 0.05;
                index += 2;
            } else {
                omega = 0.025 * (double)maxIndex + 1.0;
                index = maxIndex;
                if (index < 40 && count[index + 1] == 0) {
                    omega += 0.025;
                    ++index;
                }
            }
            if (omega > 2.0) {
                omega = 2.0;
                index = 40;
            }
            lastResidInfNorm = residInfNorm;
        }
        if (convergence > this.accuracy) {
            monitor.done();
            throw new SolverException("AIR failed to converge within " + this.maxIterations + " iterations", 0);
        }
        residInfNorm = 0.0;
        this.QC.transMult((Vector)solution, (Vector)result);
        i2 = 0;
        while (i2 < this.tangible) {
            sol_i = solution.get(i2);
            res_i = result.get(i2);
            result.set(i2, res_i - sol_i);
            if (Math.abs(result.get(i2)) > residInfNorm) {
                residInfNorm = Math.abs(result.get(i2));
            }
            ++i2;
        }
        try {
            this.checkVector(solution, residInfNorm);
        }
        finally {
            monitor.done();
        }
        this.unScale((Vector)solution);
        this.normalise((Vector)solution);
        return solution.getData();
    }

    private void checkVector(DenseVector solution, double infNorm) throws SolverException {
        int n = 0;
        while (n < this.tangible) {
            if (solution.get(n) < 0.0 && solution.get(n) > -this.EPS) {
                solution.set(n, 0.0);
            }
            ++n;
        }
        double oneNorm = solution.norm(Vector.Norm.One);
        double min = solution.get(0);
        double max = solution.get(0);
        int n2 = 1;
        while (n2 < this.tangible) {
            double current = solution.get(n2);
            if (current < min) {
                min = current;
            }
            if (current > max) {
                max = current;
            }
            if (!(current > 0.0) && !(current <= 0.0)) {
                throw new SolverException("NaN found in solution vector", -1);
            }
            ++n2;
        }
        if (infNorm > 10000.0 * this.accuracy) {
            throw new SolverException("Unacceptably large normalised residual norm", -1);
        }
        if (min < 0.0 || max > 1.0) {
            throw new SolverException("Steady-state element range violation", -1);
        }
        if (Math.abs(oneNorm - 1.0) > 1.0E-10) {
            throw new SolverException("Steady-state vector sum violation", -1);
        }
    }

    private void normalise(Vector v) {
        v.scale(1.0 / v.norm(Vector.Norm.One));
    }

    private void unScale(Vector v) {
        int i = 0;
        while (i < this.scale.length) {
            v.set(i, v.get(i) * this.scale[i]);
            ++i;
        }
    }

    public static void main(String[] args) throws IOException, DerivationException, InterruptedException, SolverException {
        String modelName = args[0];
        ASTNode node = PepaTools.parse(SteadyStateAnalyser.readText(modelName));
        OptionMap map = new OptionMap();
        map.put("ctmc.derivation.aggregate_arrays", true);
        IStateSpace ss = PepaTools.derive(map, (ModelNode)node, new IProgressMonitor(){
            int worked = 0;

            public void beginTask(int amount) {
            }

            public void done() {
            }

            public boolean isCanceled() {
                return false;
            }

            public void setCanceled(boolean state) {
            }

            public void worked(int worked) {
                this.worked += worked;
                System.out.println("Worked:" + this.worked);
            }
        }, null);
        long tic = System.currentTimeMillis();
        map.put("ctmc.steadystate.solver", 12);
        ISolver analyser = SolverFactory.createSolver(ss, map);
        double[] newSolution = analyser.solve(new IProgressMonitor(){

            public void beginTask(int amount) {
                System.out.println("Solution:");
            }

            public void done() {
                System.out.println();
            }

            public boolean isCanceled() {
                return false;
            }

            public void setCanceled(boolean state) {
            }

            public void worked(int worked) {
                System.out.print(".");
            }
        });
        System.out.println("Solution took:" + (System.currentTimeMillis() - tic) + " ms");
        ss.setSolution(newSolution);
        ThroughputResult[] throughputResultArray = ss.getThroughput();
        int n = throughputResultArray.length;
        int n2 = 0;
        while (n2 < n) {
            ThroughputResult r = throughputResultArray[n2];
            System.out.printf("%s : %f\n", r.getActionType(), r.getThroughput());
            ++n2;
        }
    }

    private static String readText(String fileName) throws IOException {
        String result = null;
        if (fileName != null) {
            File file = new File(fileName);
            StringBuffer sb = new StringBuffer();
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(file));
                String line = null;
                String lineSearator = System.getProperty("line.separator");
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    sb.append(lineSearator);
                }
                result = sb.toString();
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace(System.err);
                    }
                }
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MatrixType {
        COLUMN;

    }
}

