/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.solution.internal.simple;

import java.util.ArrayList;
import java.util.Iterator;
import uk.ac.ed.inf.pepa.DoNothingMonitor;
import uk.ac.ed.inf.pepa.IProgressMonitor;
import uk.ac.ed.inf.pepa.ctmc.solution.ISolver;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.ctmc.solution.SolverException;
import uk.ac.ed.inf.pepa.ctmc.solution.internal.simple.Generator;

public abstract class AbstractSolver
implements ISolver {
    protected Generator generator;
    protected OptionMap options;
    protected int maxIteration;
    protected static final int REFRESH_RATE = 20;

    public AbstractSolver(Generator generator, OptionMap options) {
        this.generator = generator;
        this.options = options;
    }

    public final double[] solve(IProgressMonitor monitor) throws SolverException {
        if (monitor == null) {
            monitor = new DoNothingMonitor();
        }
        this.maxIteration = (Integer)this.options.get("ctmc.solver.simple.max_iter");
        int ticks = this.maxIteration + this.generator.row.length;
        monitor.beginTask(ticks);
        double[] solution = this.transposeAndSolve(this.generator.row, this.generator.column, this.generator.value, this.generator.diagonal, monitor);
        monitor.done();
        return solution;
    }

    private final double[] transposeAndSolve(int[] row, int[] column, double[] value, double[] diagonal, IProgressMonitor monitor) throws SolverException {
        ArrayList array;
        int[] tempRows = new int[row.length];
        int i = 0;
        while (i < tempRows.length) {
            tempRows[i] = 0;
            ++i;
        }
        ArrayList[] tempColumns = new ArrayList[row.length];
        int i2 = 0;
        while (i2 < row.length) {
            tempColumns[i2] = new ArrayList();
            ++i2;
        }
        ArrayList[] tempValues = new ArrayList[row.length];
        int i3 = 0;
        while (i3 < row.length) {
            tempValues[i3] = new ArrayList();
            ++i3;
        }
        ArrayList lastValue = tempValues[row.length - 1];
        ArrayList lastColumn = tempColumns[row.length - 1];
        int i4 = 0;
        while (i4 < row.length) {
            lastValue.add(1.0);
            lastColumn.add(i4);
            ++i4;
        }
        tempRows[row.length - 1] = row.length;
        int nzc = 0;
        int valuesPtr = 0;
        int i5 = 0;
        while (i5 < row.length) {
            if (i5 % 20 == 0 && i5 != 0) {
                monitor.worked(20);
            }
            int start = row[i5];
            int end = i5 == row.length - 1 ? column.length : row[i5 + 1];
            int j = start;
            while (j < end) {
                int index = column[j];
                if (index == row.length - 1) {
                    ++valuesPtr;
                } else {
                    int n = index;
                    tempRows[n] = tempRows[n] + 1;
                    ArrayList c = tempColumns[index];
                    c.add(i5);
                    tempValues[index].add(value[valuesPtr]);
                    ++nzc;
                    ++valuesPtr;
                }
                ++j;
            }
            ++i5;
        }
        int[] trows = new int[row.length];
        int[] tcolumns = new int[nzc += row.length];
        double[] tvalues = new double[tcolumns.length];
        int i6 = 0;
        int c = 0;
        while (i6 < tempColumns.length) {
            array = tempColumns[i6];
            Iterator iterator = array.iterator();
            while (iterator.hasNext()) {
                int v = (Integer)iterator.next();
                tcolumns[c++] = v;
            }
            ++i6;
        }
        i6 = 0;
        c = 0;
        while (i6 < tempValues.length) {
            array = tempValues[i6];
            Iterator iterator = array.iterator();
            while (iterator.hasNext()) {
                double v = (Double)iterator.next();
                tvalues[c++] = v;
            }
            ++i6;
        }
        trows[0] = 0;
        i6 = 1;
        while (i6 < tempRows.length) {
            trows[i6] = trows[i6 - 1] + tempRows[i6 - 1];
            ++i6;
        }
        diagonal[diagonal.length - 1] = 1.0;
        return this.doSolve(trows, tcolumns, tvalues, diagonal, monitor);
    }

    protected abstract double[] doSolve(int[] var1, int[] var2, double[] var3, double[] var4, IProgressMonitor var5) throws SolverException;

    protected static String createMaximumIterationsMessage(int iterations, double norm) {
        return "Maximum number of iterations (" + iterations + ") reached. Residual norm: " + norm;
    }

    protected static String createDivergenceDetected(int iterations, double norm) {
        return "Divergence detected at iteration " + iterations + ". Residual norm: " + norm;
    }
}

