/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.jhydra.driver;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Hashtable;
import uk.ac.ed.inf.pepa.jhydra.driver.generator.Generator;
import uk.ac.ed.inf.pepa.jhydra.driver.parser.Parser;
import uk.ac.ed.inf.pepa.jhydra.driver.passagetimesolver.PassageTimeResults;
import uk.ac.ed.inf.pepa.jhydra.driver.passagetimesolver.PassageTimeSolver;
import uk.ac.ed.inf.pepa.jhydra.driver.steadystatesolver.SteadyStateSolver;
import uk.ac.ed.inf.pepa.jhydra.matrix.Matrix;
import uk.ac.ed.inf.pepa.jhydra.petrinet.PetriNet;

public class Driver {
    private PetriNet myPN;
    private Matrix myMatrix;
    private double[] alphaVector;
    private Hashtable<String, Double> constants;
    private String modelFileName;
    private Parser myParser;
    private Generator myGenerator;
    private SteadyStateSolver mySteadyStateSolver;
    private PassageTimeSolver myPassageTimeSolver;

    public Driver(String model) {
        this.modelFileName = model;
        this.myPN = new PetriNet();
        this.myMatrix = new Matrix();
        this.constants = new Hashtable();
        try {
            this.myParser = new Parser(new FileInputStream(this.modelFileName), this.myPN, this.constants);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Parser:  File " + this.modelFileName + " not found.");
            System.exit(-1);
        }
    }

    public void go() {
        System.out.println("\nStarting analysis of " + this.modelFileName + "...");
        this.myParser.parse();
        this.myGenerator = new Generator(this.myPN, this.myMatrix, this.myParser.getSourceCondition(), this.myParser.getTargetCondition(), this.myParser.getConstants());
        this.myGenerator.generate();
        this.mySteadyStateSolver = new SteadyStateSolver(this.myMatrix);
        this.myMatrix.print();
        this.alphaVector = this.mySteadyStateSolver.solve(this.myGenerator.getSourceStates());
        this.myPassageTimeSolver = new PassageTimeSolver(this.myMatrix, this.alphaVector, this.myGenerator.getTargetStates(), this.myParser.getTStart(), this.myParser.getTStop(), this.myParser.getTStep());
        PassageTimeResults ptResults = this.myPassageTimeSolver.uniformise(this.modelFileName, "cdf", "pdf");
        ptResults.printOutResults(this.modelFileName);
        System.out.println("\nFinished analysis of " + this.modelFileName + "...");
    }
}

