/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.jhydra.driver.generator;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Vector;
import uk.ac.ed.inf.pepa.jhydra.matrix.Matrix;
import uk.ac.ed.inf.pepa.jhydra.matrix.MatrixElement;
import uk.ac.ed.inf.pepa.jhydra.matrix.MatrixRow;
import uk.ac.ed.inf.pepa.jhydra.petrinet.Marking;
import uk.ac.ed.inf.pepa.jhydra.petrinet.PetriNet;
import uk.ac.ed.inf.pepa.jhydra.petrinet.TimedTransition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Generator {
    private PetriNet myPN;
    private Matrix myMatrix;
    private Integer tangible;
    private String sourceCondition;
    private String targetCondition;
    private BitSet sourceStates;
    private BitSet targetStates;
    private int sources;
    private int targets;

    public Generator(PetriNet net, Matrix mat, String sC, String tC, Hashtable<String, Double> c) {
        this.myPN = net;
        this.myMatrix = mat;
        this.tangible = new Integer(0);
        this.sourceCondition = sC;
        this.targetCondition = tC;
        this.myPN.setConstants(c);
        this.sources = 0;
        this.targets = 0;
    }

    public void generate() {
        System.out.println("\n\nGenerating underlying state space...");
        Vector<Integer> sourceMarkings = new Vector<Integer>(0, 1);
        Vector<Integer> targetMarkings = new Vector<Integer>(0, 1);
        Integer stateNumber = new Integer(0);
        int row = 0;
        Hashtable<Marking, Integer> explored = new Hashtable<Marking, Integer>();
        LinkedList<Marking> pending = new LinkedList<Marking>();
        Marking initialMarking = this.myPN.getCurrentMarking();
        explored.put(initialMarking, stateNumber);
        pending.addLast(initialMarking);
        while (pending.size() > 0) {
            Integer currStateNo;
            Marking currentMarking = (Marking)pending.removeFirst();
            MatrixRow matrixRow = new MatrixRow(row);
            if (this.myPN.conditionHolds(this.sourceCondition, currentMarking)) {
                ++this.sources;
                currStateNo = (Integer)explored.get(currentMarking);
                sourceMarkings.add(currStateNo);
            }
            if (this.myPN.conditionHolds(this.targetCondition, currentMarking)) {
                ++this.targets;
                currStateNo = (Integer)explored.get(currentMarking);
                targetMarkings.add(currStateNo);
            }
            int i = 0;
            while (i < this.myPN.getNumberOfTimedTransitions()) {
                TimedTransition t = this.myPN.getTimedTransition(i);
                if (this.myPN.isEnabled(currentMarking, t)) {
                    MatrixElement child;
                    Marking nextMarking = this.myPN.fire(currentMarking, t);
                    if (!explored.containsKey(nextMarking)) {
                        stateNumber = stateNumber + 1;
                        pending.addLast(nextMarking);
                        explored.put(nextMarking, stateNumber);
                        Double rate = new Double(this.myPN.conditionValue(t.getRate(), currentMarking));
                        child = new MatrixElement(stateNumber, rate);
                        matrixRow.add(child);
                        if ((stateNumber + 1) % 10000 == 0) {
                            System.out.println(String.valueOf(stateNumber + 1) + " states generated (" + pending.size() + " unexplored) ...");
                        }
                    } else {
                        Integer col = (Integer)explored.get(nextMarking);
                        Double rate = new Double(this.myPN.conditionValue(t.getRate(), currentMarking));
                        child = new MatrixElement(col, rate);
                        matrixRow.add(child);
                    }
                }
                ++i;
            }
            this.myMatrix.addRow(matrixRow, row);
            ++row;
        }
        this.tangible = row;
        System.out.println("\nFinished generating underlying state space of " + this.tangible + " states...");
        this.myMatrix.columnify();
        this.setupBitSets(sourceMarkings, targetMarkings);
        System.out.println("\nThere were:");
        System.out.println("    " + this.sources + " source states");
        System.out.println("    " + this.targets + " target states");
    }

    public BitSet getSourceStates() {
        return this.sourceStates;
    }

    public BitSet getTargetStates() {
        return this.targetStates;
    }

    private void setupBitSets(Vector<Integer> sources, Vector<Integer> targets) {
        this.sourceStates = new BitSet(this.tangible);
        this.targetStates = new BitSet(this.tangible);
        this.sourceStates.clear();
        this.targetStates.clear();
        int i = 0;
        while (i < sources.size()) {
            this.sourceStates.set(sources.get(i));
            ++i;
        }
        i = 0;
        while (i < targets.size()) {
            this.targetStates.set(targets.get(i));
            ++i;
        }
    }
}

