/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.jhydra.driver.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class JavaCharStream {
    public static final boolean staticFlag = true;
    public static int bufpos = -1;
    static int bufsize;
    static int available;
    static int tokenBegin;
    protected static int[] bufline;
    protected static int[] bufcolumn;
    protected static int column;
    protected static int line;
    protected static boolean prevCharIsCR;
    protected static boolean prevCharIsLF;
    protected static Reader inputStream;
    protected static char[] nextCharBuf;
    protected static char[] buffer;
    protected static int maxNextCharInd;
    protected static int nextCharInd;
    protected static int inBuf;
    protected static int tabSize;

    static {
        column = 0;
        line = 1;
        prevCharIsCR = false;
        prevCharIsLF = false;
        maxNextCharInd = 0;
        nextCharInd = -1;
        inBuf = 0;
        tabSize = 8;
    }

    static final int hexval(char c) throws IOException {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        throw new IOException();
    }

    protected static void setTabSize(int i) {
        tabSize = i;
    }

    protected static int getTabSize(int i) {
        return tabSize;
    }

    protected static void ExpandBuff(boolean wrapAround) {
        char[] newbuffer = new char[bufsize + 2048];
        int[] newbufline = new int[bufsize + 2048];
        int[] newbufcolumn = new int[bufsize + 2048];
        try {
            if (wrapAround) {
                System.arraycopy(buffer, tokenBegin, newbuffer, 0, bufsize - tokenBegin);
                System.arraycopy(buffer, 0, newbuffer, bufsize - tokenBegin, bufpos);
                buffer = newbuffer;
                System.arraycopy(bufline, tokenBegin, newbufline, 0, bufsize - tokenBegin);
                System.arraycopy(bufline, 0, newbufline, bufsize - tokenBegin, bufpos);
                bufline = newbufline;
                System.arraycopy(bufcolumn, tokenBegin, newbufcolumn, 0, bufsize - tokenBegin);
                System.arraycopy(bufcolumn, 0, newbufcolumn, bufsize - tokenBegin, bufpos);
                bufcolumn = newbufcolumn;
                bufpos += bufsize - tokenBegin;
            } else {
                System.arraycopy(buffer, tokenBegin, newbuffer, 0, bufsize - tokenBegin);
                buffer = newbuffer;
                System.arraycopy(bufline, tokenBegin, newbufline, 0, bufsize - tokenBegin);
                bufline = newbufline;
                System.arraycopy(bufcolumn, tokenBegin, newbufcolumn, 0, bufsize - tokenBegin);
                bufcolumn = newbufcolumn;
                bufpos -= tokenBegin;
            }
        }
        catch (Throwable t) {
            throw new Error(t.getMessage());
        }
        available = bufsize += 2048;
        tokenBegin = 0;
    }

    protected static void FillBuff() throws IOException {
        if (maxNextCharInd == 4096) {
            nextCharInd = 0;
            maxNextCharInd = 0;
        }
        try {
            int i = inputStream.read(nextCharBuf, maxNextCharInd, 4096 - maxNextCharInd);
            if (i == -1) {
                inputStream.close();
                throw new IOException();
            }
            maxNextCharInd += i;
            return;
        }
        catch (IOException e) {
            if (bufpos != 0) {
                --bufpos;
                JavaCharStream.backup(0);
            } else {
                JavaCharStream.bufline[JavaCharStream.bufpos] = line;
                JavaCharStream.bufcolumn[JavaCharStream.bufpos] = column;
            }
            throw e;
        }
    }

    protected static char ReadByte() throws IOException {
        if (++nextCharInd >= maxNextCharInd) {
            JavaCharStream.FillBuff();
        }
        return nextCharBuf[nextCharInd];
    }

    public static char BeginToken() throws IOException {
        if (inBuf > 0) {
            --inBuf;
            if (++bufpos == bufsize) {
                bufpos = 0;
            }
            tokenBegin = bufpos;
            return buffer[bufpos];
        }
        tokenBegin = 0;
        bufpos = -1;
        return JavaCharStream.readChar();
    }

    protected static void AdjustBuffSize() {
        if (available == bufsize) {
            if (tokenBegin > 2048) {
                bufpos = 0;
                available = tokenBegin;
            } else {
                JavaCharStream.ExpandBuff(false);
            }
        } else if (available > tokenBegin) {
            available = bufsize;
        } else if (tokenBegin - available < 2048) {
            JavaCharStream.ExpandBuff(true);
        } else {
            available = tokenBegin;
        }
    }

    protected static void UpdateLineColumn(char c) {
        ++column;
        if (prevCharIsLF) {
            prevCharIsLF = false;
            column = 1;
            ++line;
        } else if (prevCharIsCR) {
            prevCharIsCR = false;
            if (c == '\n') {
                prevCharIsLF = true;
            } else {
                column = 1;
                ++line;
            }
        }
        switch (c) {
            case '\r': {
                prevCharIsCR = true;
                break;
            }
            case '\n': {
                prevCharIsLF = true;
                break;
            }
            case '\t': {
                --column;
                column += tabSize - column % tabSize;
                break;
            }
        }
        JavaCharStream.bufline[JavaCharStream.bufpos] = line;
        JavaCharStream.bufcolumn[JavaCharStream.bufpos] = column;
    }

    /*
     * Unable to fully structure code
     */
    public static char readChar() throws IOException {
        block12: {
            if (JavaCharStream.inBuf > 0) {
                --JavaCharStream.inBuf;
                if (++JavaCharStream.bufpos == JavaCharStream.bufsize) {
                    JavaCharStream.bufpos = 0;
                }
                return JavaCharStream.buffer[JavaCharStream.bufpos];
            }
            if (++JavaCharStream.bufpos == JavaCharStream.available) {
                JavaCharStream.AdjustBuffSize();
            }
            JavaCharStream.buffer[JavaCharStream.bufpos] = c = JavaCharStream.ReadByte();
            if (c != '\\') break block12;
            JavaCharStream.UpdateLineColumn(c);
            backSlashCnt = 1;
            while (true) {
                block11: {
                    if (++JavaCharStream.bufpos == JavaCharStream.available) {
                        JavaCharStream.AdjustBuffSize();
                    }
                    try {
                        block13: {
                            JavaCharStream.buffer[JavaCharStream.bufpos] = c = JavaCharStream.ReadByte();
                            if (c == '\\') break block11;
                            JavaCharStream.UpdateLineColumn(c);
                            if (c != 'u' || (backSlashCnt & 1) != 1) break block13;
                            if (--JavaCharStream.bufpos >= 0) ** GOTO lbl36
                            JavaCharStream.bufpos = JavaCharStream.bufsize - 1;
                            if (true) ** GOTO lbl36
                        }
                        JavaCharStream.backup(backSlashCnt);
                        return '\\';
                    }
                    catch (IOException v0) {
                        if (backSlashCnt > 1) {
                            JavaCharStream.backup(backSlashCnt - 1);
                        }
                        return '\\';
                    }
                }
                JavaCharStream.UpdateLineColumn(c);
                ++backSlashCnt;
            }
            {
                do {
                    ++JavaCharStream.column;
lbl36:
                    // 3 sources

                } while ((c = JavaCharStream.ReadByte()) == 'u');
                JavaCharStream.buffer[JavaCharStream.bufpos] = c = (char)(JavaCharStream.hexval(c) << 12 | JavaCharStream.hexval(JavaCharStream.ReadByte()) << 8 | JavaCharStream.hexval(JavaCharStream.ReadByte()) << 4 | JavaCharStream.hexval(JavaCharStream.ReadByte()));
                JavaCharStream.column += 4;
            }
            if (backSlashCnt == 1) {
                return c;
            }
            JavaCharStream.backup(backSlashCnt - 1);
            return '\\';
        }
        JavaCharStream.UpdateLineColumn(c);
        return c;
    }

    public static int getColumn() {
        return bufcolumn[bufpos];
    }

    public static int getLine() {
        return bufline[bufpos];
    }

    public static int getEndColumn() {
        return bufcolumn[bufpos];
    }

    public static int getEndLine() {
        return bufline[bufpos];
    }

    public static int getBeginColumn() {
        return bufcolumn[tokenBegin];
    }

    public static int getBeginLine() {
        return bufline[tokenBegin];
    }

    public static void backup(int amount) {
        inBuf += amount;
        if ((bufpos -= amount) < 0) {
            bufpos += bufsize;
        }
    }

    public JavaCharStream(Reader dstream, int startline, int startcolumn, int buffersize) {
        if (inputStream != null) {
            throw new Error("\n   ERROR: Second call to the constructor of a static JavaCharStream.\n       You must either use ReInit() or set the JavaCC option STATIC to false\n       during the generation of this class.");
        }
        inputStream = dstream;
        line = startline;
        column = startcolumn - 1;
        available = bufsize = buffersize;
        buffer = new char[buffersize];
        bufline = new int[buffersize];
        bufcolumn = new int[buffersize];
        nextCharBuf = new char[4096];
    }

    public JavaCharStream(Reader dstream, int startline, int startcolumn) {
        this(dstream, startline, startcolumn, 4096);
    }

    public JavaCharStream(Reader dstream) {
        this(dstream, 1, 1, 4096);
    }

    public void ReInit(Reader dstream, int startline, int startcolumn, int buffersize) {
        inputStream = dstream;
        line = startline;
        column = startcolumn - 1;
        if (buffer == null || buffersize != buffer.length) {
            available = bufsize = buffersize;
            buffer = new char[buffersize];
            bufline = new int[buffersize];
            bufcolumn = new int[buffersize];
            nextCharBuf = new char[4096];
        }
        prevCharIsCR = false;
        prevCharIsLF = false;
        maxNextCharInd = 0;
        inBuf = 0;
        tokenBegin = 0;
        bufpos = -1;
        nextCharInd = -1;
    }

    public void ReInit(Reader dstream, int startline, int startcolumn) {
        this.ReInit(dstream, startline, startcolumn, 4096);
    }

    public void ReInit(Reader dstream) {
        this.ReInit(dstream, 1, 1, 4096);
    }

    public JavaCharStream(InputStream dstream, String encoding, int startline, int startcolumn, int buffersize) throws UnsupportedEncodingException {
        this(encoding == null ? new InputStreamReader(dstream) : new InputStreamReader(dstream, encoding), startline, startcolumn, buffersize);
    }

    public JavaCharStream(InputStream dstream, int startline, int startcolumn, int buffersize) {
        this(new InputStreamReader(dstream), startline, startcolumn, 4096);
    }

    public JavaCharStream(InputStream dstream, String encoding, int startline, int startcolumn) throws UnsupportedEncodingException {
        this(dstream, encoding, startline, startcolumn, 4096);
    }

    public JavaCharStream(InputStream dstream, int startline, int startcolumn) {
        this(dstream, startline, startcolumn, 4096);
    }

    public JavaCharStream(InputStream dstream, String encoding) throws UnsupportedEncodingException {
        this(dstream, encoding, 1, 1, 4096);
    }

    public JavaCharStream(InputStream dstream) {
        this(dstream, 1, 1, 4096);
    }

    public void ReInit(InputStream dstream, String encoding, int startline, int startcolumn, int buffersize) throws UnsupportedEncodingException {
        this.ReInit(encoding == null ? new InputStreamReader(dstream) : new InputStreamReader(dstream, encoding), startline, startcolumn, buffersize);
    }

    public void ReInit(InputStream dstream, int startline, int startcolumn, int buffersize) {
        this.ReInit(new InputStreamReader(dstream), startline, startcolumn, buffersize);
    }

    public void ReInit(InputStream dstream, String encoding, int startline, int startcolumn) throws UnsupportedEncodingException {
        this.ReInit(dstream, encoding, startline, startcolumn, 4096);
    }

    public void ReInit(InputStream dstream, int startline, int startcolumn) {
        this.ReInit(dstream, startline, startcolumn, 4096);
    }

    public void ReInit(InputStream dstream, String encoding) throws UnsupportedEncodingException {
        this.ReInit(dstream, encoding, 1, 1, 4096);
    }

    public void ReInit(InputStream dstream) {
        this.ReInit(dstream, 1, 1, 4096);
    }

    public static String GetImage() {
        if (bufpos >= tokenBegin) {
            return new String(buffer, tokenBegin, bufpos - tokenBegin + 1);
        }
        return String.valueOf(new String(buffer, tokenBegin, bufsize - tokenBegin)) + new String(buffer, 0, bufpos + 1);
    }

    public static char[] GetSuffix(int len) {
        char[] ret = new char[len];
        if (bufpos + 1 >= len) {
            System.arraycopy(buffer, bufpos - len + 1, ret, 0, len);
        } else {
            System.arraycopy(buffer, bufsize - (len - bufpos - 1), ret, 0, len - bufpos - 1);
            System.arraycopy(buffer, 0, ret, len - bufpos - 1, bufpos + 1);
        }
        return ret;
    }

    public static void Done() {
        nextCharBuf = null;
        buffer = null;
        bufline = null;
        bufcolumn = null;
    }

    public static void adjustBeginLineColumn(int newLine, int newCol) {
        int start = tokenBegin;
        int len = bufpos >= tokenBegin ? bufpos - tokenBegin + inBuf + 1 : bufsize - tokenBegin + bufpos + 1 + inBuf;
        int i = 0;
        int j = 0;
        int k = 0;
        int nextColDiff = 0;
        int columnDiff = 0;
        while (i < len && bufline[j = start % bufsize] == bufline[k = ++start % bufsize]) {
            JavaCharStream.bufline[j] = newLine;
            nextColDiff = columnDiff + bufcolumn[k] - bufcolumn[j];
            JavaCharStream.bufcolumn[j] = newCol + columnDiff;
            columnDiff = nextColDiff;
            ++i;
        }
        if (i < len) {
            JavaCharStream.bufline[j] = newLine++;
            JavaCharStream.bufcolumn[j] = newCol + columnDiff;
            while (i++ < len) {
                j = start % bufsize;
                JavaCharStream.bufline[j] = bufline[j] != bufline[++start % bufsize] ? newLine++ : newLine;
            }
        }
        line = bufline[j];
        column = bufcolumn[j];
    }
}

