/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.jhydra.driver.parser;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import uk.ac.ed.inf.pepa.jhydra.driver.parser.JavaCharStream;
import uk.ac.ed.inf.pepa.jhydra.driver.parser.ParseException;
import uk.ac.ed.inf.pepa.jhydra.driver.parser.ParserConstants;
import uk.ac.ed.inf.pepa.jhydra.driver.parser.ParserTokenManager;
import uk.ac.ed.inf.pepa.jhydra.driver.parser.Token;
import uk.ac.ed.inf.pepa.jhydra.petrinet.PetriNet;
import uk.ac.ed.inf.pepa.jhydra.petrinet.Place;
import uk.ac.ed.inf.pepa.jhydra.petrinet.TimedTransition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser
implements ParserConstants {
    private static PetriNet myPN;
    private static Hashtable<String, Double> constants;
    private static double tStart;
    private static double tStop;
    private static double tStep;
    private static String sourceCondition;
    private static String targetCondition;
    private static boolean jj_initialized_once;
    public static ParserTokenManager token_source;
    static JavaCharStream jj_input_stream;
    public static Token token;
    public static Token jj_nt;
    private static int jj_ntk;
    private static Token jj_scanpos;
    private static Token jj_lastpos;
    private static int jj_la;
    private static int jj_gen;
    private static final int[] jj_la1;
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private static int[] jj_la1_5;
    private static final JJCalls[] jj_2_rtns;
    private static boolean jj_rescan;
    private static int jj_gc;
    private static final LookaheadSuccess jj_ls;
    private static List jj_expentries;
    private static int[] jj_expentry;
    private static int jj_kind;
    private static int[] jj_lasttokens;
    private static int jj_endpos;

    static {
        tStart = 0.0;
        tStop = 0.0;
        tStep = 0.0;
        jj_initialized_once = false;
        jj_la1 = new int[73];
        Parser.jj_la1_init_0();
        Parser.jj_la1_init_1();
        Parser.jj_la1_init_2();
        Parser.jj_la1_init_3();
        Parser.jj_la1_init_4();
        Parser.jj_la1_init_5();
        jj_2_rtns = new JJCalls[9];
        jj_rescan = false;
        jj_gc = 0;
        jj_ls = new LookaheadSuccess();
        jj_expentries = new ArrayList();
        jj_kind = -1;
        jj_lasttokens = new int[100];
    }

    public double getTStart() {
        return tStart;
    }

    public double getTStop() {
        return tStop;
    }

    public double getTStep() {
        return tStep;
    }

    public String getSourceCondition() {
        return sourceCondition;
    }

    public String getTargetCondition() {
        return targetCondition;
    }

    public Hashtable<String, Double> getConstants() {
        return constants;
    }

    public void parse() {
        try {
            System.out.println("\n\nParsing model file...");
            Parser.InputFile();
            System.out.println("\n\nModel file parsed successfully...");
            System.out.println("\nPetri net has:");
            System.out.println("  " + myPN.getNumberOfPlaces() + " places");
            System.out.println("  " + myPN.getNumberOfTimedTransitions() + " timed transitions");
            System.out.println("  " + myPN.getNumberOfImmTransitions() + " immediate transitions");
        }
        catch (ParseException e) {
            System.out.println("Encountered errors during parse:");
            System.out.println(e);
            System.exit(-1);
        }
    }

    public static final void InputFile() throws ParseException {
        Parser.ModelDescription();
        block6: while (true) {
            switch (jj_ntk == -1 ? Parser.jj_ntk() : jj_ntk) {
                case 31: {
                    break;
                }
                default: {
                    Parser.jj_la1[0] = jj_gen;
                    break block6;
                }
            }
            Parser.SolutionControl();
        }
        block7: while (true) {
            switch (jj_ntk == -1 ? Parser.jj_ntk() : jj_ntk) {
                case 49: {
                    break;
                }
                default: {
                    Parser.jj_la1[1] = jj_gen;
                    break block7;
                }
            }
            Parser.PassageTimeDeclaration();
        }
        Parser.jj_consume_token(0);
    }

    public static final void ModelDescription() throws ParseException {
        block10: {
            Parser.jj_consume_token(7);
            Parser.jj_consume_token(132);
            block9: while (true) {
                switch (jj_ntk == -1 ? Parser.jj_ntk() : jj_ntk) {
                    case 8: 
                    case 13: 
                    case 14: 
                    case 26: {
                        break;
                    }
                    default: {
                        Parser.jj_la1[2] = jj_gen;
                        break block10;
                    }
                }
                switch (jj_ntk == -1 ? Parser.jj_ntk() : jj_ntk) {
                    case 8: {
                        Parser.StateVector();
                        continue block9;
                    }
                    case 14: {
                        Parser.InitialState();
                        continue block9;
                    }
                    case 13: {
                        Parser.Transition();
                        continue block9;
                    }
                    case 26: {
                        Parser.Constant();
                        continue block9;
                    }
                }
                break;
            }
            Parser.jj_la1[3] = jj_gen;
            Parser.jj_consume_token(-1);
            throw new ParseException();
        }
        Parser.jj_consume_token(133);
    }

    public static final void StateVector() throws ParseException {
        Parser.jj_consume_token(8);
        Parser.jj_consume_token(132);
        block6: while (true) {
            switch (jj_ntk == -1 ? Parser.jj_ntk() : jj_ntk) {
                case 9: {
                    break;
                }
                default: {
                    Parser.jj_la1[4] = jj_gen;
                    break block6;
                }
            }
            Parser.jj_consume_token(9);
            Parser.jj_consume_token(132);
            Parser.PrimitiveType();
            Parser.jj_consume_token(133);
            Parser.jj_consume_token(132);
            Token t = Parser.jj_consume_token(127);
            System.out.println("Found place " + t.toString() + "...");
            myPN.addPlace(t.toString());
            block7: while (true) {
                switch (jj_ntk == -1 ? Parser.jj_ntk() : jj_ntk) {
                    case 137: {
                        break;
                    }
                    default: {
                        Parser.jj_la1[5] = jj_gen;
                        break block7;
                    }
                }
                Parser.jj_consume_token(137);
                Token t2 = Parser.jj_consume_token(127);
                System.out.println("Found place " + t2.toString() + "...");
                myPN.addPlace(t2.toString());
            }
            Parser.jj_consume_token(133);
        }
        Parser.jj_consume_token(133);
    }

    public static final void InitialState() throws ParseException {
        Parser.jj_consume_token(14);
        Parser.jj_consume_token(132);
        block3: while (true) {
            switch (jj_ntk == -1 ? Parser.jj_ntk() : jj_ntk) {
                case 127: {
                    break;
                }
                default: {
                    Parser.jj_la1[6] = jj_gen;
                    break block3;
                }
            }
            Parser.StateAssignment();
        }
        Parser.jj_consume_token(133);
    }

    public static final void StateAssignment() throws ParseException {
        Token placeName = Parser.jj_consume_token(127);
        Parser.jj_consume_token(139);
        switch (jj_ntk == -1 ? Parser.jj_ntk() : jj_ntk) {
            case 127: {
                Token constantName = Parser.jj_consume_token(127);
                Double iC = constants.get(constantName.toString());
                if (iC != null) {
                    myPN.setTokens(placeName.toString(), iC.intValue());
                    break;
                }
                System.exit(-1);
                break;
            }
            case 119: {
                Token tokens = Parser.jj_consume_token(119);
                myPN.setTokens(placeName.toString(), new Integer(tokens.toString()));
                break;
            }
            default: {
                Parser.jj_la1[7] = jj_gen;
                Parser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Parser.jj_consume_token(136);
    }

    public static final void Transition() throws ParseException {
        boolean isTimed;
        String condition = "";
        String rate = "";
        Vector<String> inputPlaceNames = new Vector<String>(0, 1);
        Vector<String> outputPlaceNames = new Vector<String>(0, 1);
        Vector<Integer> inputArcWeights = new Vector<Integer>(0, 1);
        Vector<Integer> outputArcWeights = new Vector<Integer>(0, 1);
        Parser.jj_consume_token(13);
        Parser.jj_consume_token(132);
        Token t_name = Parser.jj_consume_token(127);
        Parser.jj_consume_token(133);
        Parser.jj_consume_token(132);
        condition = Parser.TransitionEnablingCondition();
        System.out.println(condition);
        Parser.jj_consume_token(16);
        Parser.jj_consume_token(132);
        block14: while (true) {
            switch (jj_ntk == -1 ? Parser.jj_ntk() : jj_ntk) {
                case 108: {
                    break;
                }
                default: {
                    Parser.jj_la1[8] = jj_gen;
                    break block14;
                }
            }
            Parser.TransitionFiringAction(inputPlaceNames, inputArcWeights, outputPlaceNames, outputArcWeights);
        }
        Parser.jj_consume_token(133);
        switch (jj_ntk == -1 ? Parser.jj_ntk() : jj_ntk) {
            case 17: {
                isTimed = true;
                Parser.jj_consume_token(17);
                Parser.jj_consume_token(132);
                rate = Parser.Expression();
                Parser.jj_consume_token(133);
                break;
            }
            case 18: {
                isTimed = false;
                Parser.jj_consume_token(18);
                Parser.jj_consume_token(132);
                Parser.jj_consume_token(123);
                Parser.jj_consume_token(133);
                break;
            }
            default: {
                Parser.jj_la1[9] = jj_gen;
                Parser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (jj_ntk == -1 ? Parser.jj_ntk() : jj_ntk) {
            case 19: {
                Parser.jj_consume_token(19);
                Parser.jj_consume_token(132);
                switch (jj_ntk == -1 ? Parser.jj_ntk() : jj_ntk) {
                    case 119: {
                        Parser.jj_consume_token(119);
                        break;
                    }
                    case 123: {
                        Parser.jj_consume_token(123);
                        break;
                    }
                    default: {
                        Parser.jj_la1[10] = jj_gen;
                        Parser.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                Parser.jj_consume_token(133);
                break;
            }
            default: {
                Parser.jj_la1[11] = jj_gen;
            }
        }
        Parser.jj_consume_token(133);
        if (isTimed) {
            if (inputPlaceNames.size() != inputArcWeights.size()) {
                System.out.println("INTERNAL ERROR: Differing number of input places and arcs for transition " + t_name.toString() + "...");
                System.exit(-1);
            }
            if (outputPlaceNames.size() != outputArcWeights.size()) {
                System.out.println("INTERNAL ERROR: Differing number of output places and arcs for transition " + t_name.toString() + "...");
                System.exit(-1);
            }
            TimedTransition tT = myPN.addTimedTransition(t_name.toString(), rate, condition);
            int i = 0;
            while (i < inputPlaceNames.size()) {
                Place inputPlace = myPN.getPlace(inputPlaceNames.get(i));
                myPN.addArc(inputPlace, tT, inputArcWeights.get(i));
                ++i;
            }
            i = 0;
            while (i < outputPlaceNames.size()) {
                Place outputPlace = myPN.getPlace(outputPlaceNames.get(i));
                myPN.addArc(tT, outputPlace, outputArcWeights.get(i));
                ++i;
            }
        } else {
            System.out.println("ERROR: immediate transition detected (not currently supported by JHydra)...");
        }
    }

    public static final String TransitionEnablingCondition() throws ParseException {
        Parser.jj_consume_token(15);
        Parser.jj_consume_token(132);
        String tECondition = Parser.Condition();
        Parser.jj_consume_token(133);
        return tECondition;
    }

    public static final String Expression() throws ParseException {
        String expression;
        block16: {
            expression = new String("");
            block15: while (true) {
                switch (jj_ntk == -1 ? Parser.jj_ntk() : jj_ntk) {
                    case 119: 
                    case 123: 
                    case 127: 
                    case 130: 
                    case 131: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 161: {
                        break;
                    }
                    default: {
                        Parser.jj_la1[12] = jj_gen;
                        break block16;
                    }
                }
                switch (jj_ntk == -1 ? Parser.jj_ntk() : jj_ntk) {
                    case 127: {
                        Token t = Parser.jj_consume_token(127);
                        expression = String.valueOf(expression) + " " + t.toString();
                        continue block15;
                    }
                    case 119: {
                        Token t = Parser.jj_consume_token(119);
                        expression = String.valueOf(expression) + " " + t.toString();
                        continue block15;
                    }
                    case 123: {
                        Token t = Parser.jj_consume_token(123);
                        expression = String.valueOf(expression) + " " + t.toString();
                        continue block15;
                    }
                    case 130: {
                        Token t = Parser.jj_consume_token(130);
                        expression = String.valueOf(expression) + " " + t.toString();
                        continue block15;
                    }
                    case 131: {
                        Token t = Parser.jj_consume_token(131);
                        expression = String.valueOf(expression) + " " + t.toString();
                        continue block15;
                    }
                    case 156: {
                        Token t = Parser.jj_consume_token(156);
                        expression = String.valueOf(expression) + " " + t.toString();
                        continue block15;
                    }
                    case 157: {
                        Token t = Parser.jj_consume_token(157);
                        expression = String.valueOf(expression) + " " + t.toString();
                        continue block15;
                    }
                    case 161: {
                        Token t = Parser.jj_consume_token(161);
                        expression = String.valueOf(expression) + " " + t.toString();
                        continue block15;
                    }
                    case 154: {
                        Token t = Parser.jj_consume_token(154);
                        expression = String.valueOf(expression) + " " + t.toString();
                        continue block15;
                    }
                    case 155: {
                        Token t = Parser.jj_consume_token(155);
                        expression = String.valueOf(expression) + " " + t.toString();
                        continue block15;
                    }
                }
                break;
            }
            Parser.jj_la1[13] = jj_gen;
            Parser.jj_consume_token(-1);
            throw new ParseException();
        }
        expression = String.valueOf(expression) + " ";
        return expression;
    }

    public static final String Condition() throws ParseException {
        String condition;
        block24: {
            condition = new String("");
            block23: while (true) {
                switch (jj_ntk == -1 ? Parser.jj_ntk() : jj_ntk) {
                    case 119: 
                    case 127: 
                    case 130: 
                    case 131: 
                    case 140: 
                    case 141: 
                    case 142: 
                    case 146: 
                    case 147: 
                    case 148: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 161: {
                        break;
                    }
                    default: {
                        Parser.jj_la1[12] = jj_gen;
                        break block24;
                    }
                }
                switch (jj_ntk == -1 ? Parser.jj_ntk() : jj_ntk) {
                    case 127: {
                        Token t = Parser.jj_consume_token(127);
                        condition = String.valueOf(condition) + " " + t.toString();
                        continue block23;
                    }
                    case 119: {
                        Token t = Parser.jj_consume_token(119);
                        condition = String.valueOf(condition) + " " + t.toString();
                        continue block23;
                    }
                    case 130: {
                        Token t = Parser.jj_consume_token(130);
                        condition = String.valueOf(condition) + " " + t.toString();
                        continue block23;
                    }
                    case 131: {
                        Token t = Parser.jj_consume_token(131);
                        condition = String.valueOf(condition) + " " + t.toString();
                        continue block23;
                    }
                    case 156: {
                        Token t = Parser.jj_consume_token(156);
                        condition = String.valueOf(condition) + " " + t.toString();
                        continue block23;
                    }
                    case 157: {
                        Token t = Parser.jj_consume_token(157);
                        condition = String.valueOf(condition) + " " + t.toString();
                        continue block23;
                    }
                    case 161: {
                        Token t = Parser.jj_consume_token(161);
                        condition = String.valueOf(condition) + " " + t.toString();
                        continue block23;
                    }
                    case 154: {
                        Token t = Parser.jj_consume_token(154);
                        condition = String.valueOf(condition) + " " + t.toString();
                        continue block23;
                    }
                    case 155: {
                        Token t = Parser.jj_consume_token(155);
                        condition = String.valueOf(condition) + " " + t.toString();
                        continue block23;
                    }
                    case 151: {
                        Token t = Parser.jj_consume_token(151);
                        condition = String.valueOf(condition) + " " + t.toString();
                        continue block23;
                    }
                    case 150: {
                        Token t = Parser.jj_consume_token(150);
                        condition = String.valueOf(condition) + " " + t.toString();
                        continue block23;
                    }
                    case 146: {
                        Token t = Parser.jj_consume_token(146);
                        condition = String.valueOf(condition) + " " + t.toString();
                        continue block23;
                    }
                    case 149: {
                        Token t = Parser.jj_consume_token(149);
                        condition = String.valueOf(condition) + " " + t.toString();
                        continue block23;
                    }
                    case 147: {
                        Token t = Parser.jj_consume_token(147);
                        condition = String.valueOf(condition) + " " + t.toString();
                        continue block23;
                    }
                    case 148: {
                        Token t = Parser.jj_consume_token(148);
                        condition = String.valueOf(condition) + " " + t.toString();
                        continue block23;
                    }
                    case 141: {
                        Token t = Parser.jj_consume_token(141);
                        condition = String.valueOf(condition) + " " + t.toString();
                        continue block23;
                    }
                    case 140: {
                        Token t = Parser.jj_consume_token(140);
                        condition = String.valueOf(condition) + " " + t.toString();
                        continue block23;
                    }
                    case 142: {
                        Token t = Parser.jj_consume_token(142);
                        condition = String.valueOf(condition) + " " + t.toString();
                        continue block23;
                    }
                }
                break;
            }
            Parser.jj_la1[13] = jj_gen;
            Parser.jj_consume_token(-1);
            throw new ParseException();
        }
        condition = String.valueOf(condition) + " ";
        return condition;
    }

    public static final void TransitionFiringAction(Vector<String> inputPlaceNames, Vector<Integer> inputArcWeights, Vector<String> outputPlaceNames, Vector<Integer> outputArcWeights) throws ParseException {
        Token t_arcWeight;
        boolean outputAction;
        Parser.jj_consume_token(108);
        Parser.jj_consume_token(176);
        Token t_place1 = Parser.jj_consume_token(127);
        Parser.jj_consume_token(139);
        Token t_place2 = Parser.jj_consume_token(127);
        if (!t_place1.toString().equals(t_place2.toString())) {
            System.out.println("ERROR: Confused over place names in transition action specification (names " + t_place1.toString() + " and " + t_place2.toString() + " don't match)...");
            System.exit(-1);
        }
        switch (jj_ntk == -1 ? Parser.jj_ntk() : jj_ntk) {
            case 154: {
                Parser.jj_consume_token(154);
                outputAction = true;
                break;
            }
            case 155: {
                Parser.jj_consume_token(155);
                outputAction = false;
                break;
            }
            default: {
                Parser.jj_la1[16] = jj_gen;
                Parser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (jj_ntk == -1 ? Parser.jj_ntk() : jj_ntk) {
            case 119: {
                t_arcWeight = Parser.jj_consume_token(119);
                break;
            }
            default: {
                Parser.jj_la1[17] = jj_gen;
                Parser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Parser.jj_consume_token(136);
        if (outputAction) {
            outputPlaceNames.add(t_place1.toString());
            outputArcWeights.add(new Integer(t_arcWeight.toString()));
        } else {
            inputPlaceNames.add(t_place1.toString());
            inputArcWeights.add(new Integer(t_arcWeight.toString()));
        }
    }

    public static final void Constant() throws ParseException {
        Parser.jj_consume_token(26);
        Parser.jj_consume_token(132);
        Token t_name = Parser.jj_consume_token(127);
        Parser.jj_consume_token(133);
        Parser.jj_consume_token(132);
        switch (jj_ntk == -1 ? Parser.jj_ntk() : jj_ntk) {
            case 119: {
                Token t_int = Parser.jj_consume_token(119);
                constants.put(t_name.toString(), (double)new Double(t_int.toString()));
                break;
            }
            case 123: {
                Token t_float = Parser.jj_consume_token(123);
                constants.put(t_name.toString(), (double)new Double(t_float.toString()));
                break;
            }
            default: {
                Parser.jj_la1[11] = jj_gen;
                Parser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Parser.jj_consume_token(133);
    }

    public static final void SolutionControl() throws ParseException {
        block9: {
            Parser.jj_consume_token(31);
            Parser.jj_consume_token(132);
            block8: while (true) {
                switch (jj_ntk == -1 ? Parser.jj_ntk() : jj_ntk) {
                    case 32: 
                    case 33: 
                    case 34: {
                        break;
                    }
                    default: {
                        Parser.jj_la1[12] = jj_gen;
                        break block9;
                    }
                }
                switch (jj_ntk == -1 ? Parser.jj_ntk() : jj_ntk) {
                    case 32: {
                        Parser.SolutionMethod();
                        continue block8;
                    }
                    case 33: {
                        Parser.SolutionAccuracy();
                        continue block8;
                    }
                    case 34: {
                        Parser.MaxIterations();
                        continue block8;
                    }
                }
                break;
            }
            Parser.jj_la1[13] = jj_gen;
            Parser.jj_consume_token(-1);
            throw new ParseException();
        }
        Parser.jj_consume_token(133);
    }

    public static final void SolutionMethod() throws ParseException {
        Parser.jj_consume_token(32);
        Parser.jj_consume_token(132);
        Parser.jj_consume_token(73);
        Parser.jj_consume_token(133);
    }

    public static final void SolutionAccuracy() throws ParseException {
        Parser.jj_consume_token(33);
        Parser.jj_consume_token(132);
        Parser.jj_consume_token(123);
        Parser.jj_consume_token(133);
    }

    public static final void MaxIterations() throws ParseException {
        Parser.jj_consume_token(34);
        Parser.jj_consume_token(132);
        Parser.jj_consume_token(119);
        Parser.jj_consume_token(133);
    }

    public static final void PassageTimeDeclaration() throws ParseException {
        Parser.jj_consume_token(49);
        Parser.jj_consume_token(132);
        Parser.jj_consume_token(51);
        Parser.jj_consume_token(132);
        sourceCondition = Parser.Condition();
        System.out.println("Found passage time source state specification: " + sourceCondition);
        Parser.jj_consume_token(133);
        Parser.jj_consume_token(50);
        Parser.jj_consume_token(132);
        targetCondition = Parser.Condition();
        System.out.println("Found passage time target state specification: " + targetCondition);
        Parser.jj_consume_token(133);
        Parser.jj_consume_token(54);
        Parser.jj_consume_token(132);
        Token t_tStart = Parser.jj_consume_token(123);
        tStart = new Double(t_tStart.toString());
        System.out.println("Found passage time start time = " + tStart);
        Parser.jj_consume_token(133);
        Parser.jj_consume_token(55);
        Parser.jj_consume_token(132);
        Token t_tStop = Parser.jj_consume_token(123);
        tStop = new Double(t_tStop.toString());
        System.out.println("Found passage time start time = " + tStop);
        Parser.jj_consume_token(133);
        Parser.jj_consume_token(56);
        Parser.jj_consume_token(132);
        Token t_tStep = Parser.jj_consume_token(123);
        tStep = new Double(t_tStep.toString());
        System.out.println("Found passage time step parameter = " + tStep);
        Parser.jj_consume_token(133);
        Parser.jj_consume_token(133);
    }

    public static final void PrimitiveType() throws ParseException {
        switch (jj_ntk == -1 ? Parser.jj_ntk() : jj_ntk) {
            case 93: {
                Parser.jj_consume_token(93);
                break;
            }
            case 111: {
                Parser.jj_consume_token(111);
                break;
            }
            case 105: {
                Parser.jj_consume_token(105);
                break;
            }
            case 107: {
                Parser.jj_consume_token(107);
                break;
            }
            default: {
                Parser.jj_la1[21] = jj_gen;
                Parser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    private static boolean jj_2_1(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !Parser.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            return true;
        }
        finally {
            Parser.jj_save(0, xla);
        }
    }

    private static boolean jj_2_2(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !Parser.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            return true;
        }
        finally {
            Parser.jj_save(1, xla);
        }
    }

    private static boolean jj_2_3(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !Parser.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            return true;
        }
        finally {
            Parser.jj_save(2, xla);
        }
    }

    private static boolean jj_2_4(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !Parser.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            return true;
        }
        finally {
            Parser.jj_save(3, xla);
        }
    }

    private static boolean jj_2_5(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !Parser.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            return true;
        }
        finally {
            Parser.jj_save(4, xla);
        }
    }

    private static boolean jj_2_6(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !Parser.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            return true;
        }
        finally {
            Parser.jj_save(5, xla);
        }
    }

    private static boolean jj_2_7(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !Parser.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            return true;
        }
        finally {
            Parser.jj_save(6, xla);
        }
    }

    private static boolean jj_2_8(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !Parser.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            return true;
        }
        finally {
            Parser.jj_save(7, xla);
        }
    }

    private static boolean jj_2_9(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !Parser.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            return true;
        }
        finally {
            Parser.jj_save(8, xla);
        }
    }

    private static boolean jj_3R_74() {
        Token xsp;
        if (Parser.jj_3R_76()) {
            return true;
        }
        do {
            xsp = jj_scanpos;
        } while (!Parser.jj_3R_81());
        jj_scanpos = xsp;
        return false;
    }

    private static boolean jj_3R_71() {
        if (Parser.jj_scan_token(137)) {
            return true;
        }
        return Parser.jj_3R_36();
    }

    private static boolean jj_3R_70() {
        if (Parser.jj_scan_token(150)) {
            return true;
        }
        return Parser.jj_3R_63();
    }

    private static boolean jj_3R_72() {
        Token xsp;
        if (Parser.jj_3R_74()) {
            return true;
        }
        do {
            xsp = jj_scanpos;
        } while (!Parser.jj_3R_79());
        jj_scanpos = xsp;
        return false;
    }

    private static boolean jj_3R_67() {
        if (Parser.jj_scan_token(144)) {
            return true;
        }
        if (Parser.jj_3R_36()) {
            return true;
        }
        if (Parser.jj_scan_token(145)) {
            return true;
        }
        return Parser.jj_3R_53();
    }

    private static boolean jj_3R_69() {
        Token xsp;
        if (Parser.jj_3R_72()) {
            return true;
        }
        do {
            xsp = jj_scanpos;
        } while (!Parser.jj_3R_77());
        jj_scanpos = xsp;
        return false;
    }

    private static boolean jj_3R_65() {
        return Parser.jj_3R_68();
    }

    private static boolean jj_3R_68() {
        Token xsp;
        if (Parser.jj_3R_36()) {
            return true;
        }
        do {
            xsp = jj_scanpos;
        } while (!Parser.jj_3R_71());
        jj_scanpos = xsp;
        return false;
    }

    private static boolean jj_3R_66() {
        Token xsp;
        if (Parser.jj_3R_69()) {
            return true;
        }
        do {
            xsp = jj_scanpos;
        } while (!Parser.jj_3R_75());
        jj_scanpos = xsp;
        return false;
    }

    private static boolean jj_3R_62() {
        if (Parser.jj_scan_token(130)) {
            return true;
        }
        Token xsp = jj_scanpos;
        if (Parser.jj_3R_65()) {
            jj_scanpos = xsp;
        }
        return Parser.jj_scan_token(131);
    }

    private static boolean jj_3R_63() {
        Token xsp;
        if (Parser.jj_3R_66()) {
            return true;
        }
        do {
            xsp = jj_scanpos;
        } while (!Parser.jj_3R_73());
        jj_scanpos = xsp;
        return false;
    }

    private static boolean jj_3R_60() {
        Token xsp;
        if (Parser.jj_3R_63()) {
            return true;
        }
        do {
            xsp = jj_scanpos;
        } while (!Parser.jj_3R_70());
        jj_scanpos = xsp;
        return false;
    }

    private static boolean jj_3_9() {
        if (Parser.jj_3R_38()) {
            return true;
        }
        return Parser.jj_scan_token(127);
    }

    private static boolean jj_3R_64() {
        Token xsp = jj_scanpos;
        if (Parser.jj_scan_token(115)) {
            jj_scanpos = xsp;
            if (Parser.jj_scan_token(100)) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_53() {
        if (Parser.jj_3R_60()) {
            return true;
        }
        Token xsp = jj_scanpos;
        if (Parser.jj_3R_67()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    private static boolean jj_3R_35() {
        Token xsp = jj_scanpos;
        if (Parser.jj_scan_token(139)) {
            jj_scanpos = xsp;
            if (Parser.jj_scan_token(167)) {
                jj_scanpos = xsp;
                if (Parser.jj_scan_token(168)) {
                    jj_scanpos = xsp;
                    if (Parser.jj_scan_token(172)) {
                        jj_scanpos = xsp;
                        if (Parser.jj_scan_token(165)) {
                            jj_scanpos = xsp;
                            if (Parser.jj_scan_token(166)) {
                                jj_scanpos = xsp;
                                if (Parser.jj_scan_token(173)) {
                                    jj_scanpos = xsp;
                                    if (Parser.jj_scan_token(174)) {
                                        jj_scanpos = xsp;
                                        if (Parser.jj_scan_token(175)) {
                                            jj_scanpos = xsp;
                                            if (Parser.jj_scan_token(169)) {
                                                jj_scanpos = xsp;
                                                if (Parser.jj_scan_token(171)) {
                                                    jj_scanpos = xsp;
                                                    if (Parser.jj_scan_token(170)) {
                                                        return true;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private static boolean jj_3R_61() {
        return Parser.jj_3R_64();
    }

    private static boolean jj_3_3() {
        if (Parser.jj_3R_34()) {
            return true;
        }
        return Parser.jj_3R_35();
    }

    private static boolean jj_3R_52() {
        if (Parser.jj_3R_34()) {
            return true;
        }
        if (Parser.jj_3R_35()) {
            return true;
        }
        return Parser.jj_3R_36();
    }

    private static boolean jj_3R_56() {
        Token xsp = jj_scanpos;
        if (Parser.jj_scan_token(119)) {
            jj_scanpos = xsp;
            if (Parser.jj_scan_token(123)) {
                jj_scanpos = xsp;
                if (Parser.jj_scan_token(125)) {
                    jj_scanpos = xsp;
                    if (Parser.jj_scan_token(126)) {
                        jj_scanpos = xsp;
                        if (Parser.jj_3R_61()) {
                            jj_scanpos = xsp;
                            if (Parser.jj_scan_token(109)) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private static boolean jj_3R_44() {
        return Parser.jj_3R_53();
    }

    private static boolean jj_3R_43() {
        return Parser.jj_3R_52();
    }

    private static boolean jj_3R_36() {
        Token xsp = jj_scanpos;
        if (Parser.jj_3R_43()) {
            jj_scanpos = xsp;
            if (Parser.jj_3R_44()) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_59() {
        return Parser.jj_3R_62();
    }

    private static boolean jj_3R_58() {
        if (Parser.jj_scan_token(138)) {
            return true;
        }
        return Parser.jj_scan_token(127);
    }

    private static boolean jj_3R_57() {
        if (Parser.jj_scan_token(134)) {
            return true;
        }
        if (Parser.jj_3R_36()) {
            return true;
        }
        return Parser.jj_scan_token(135);
    }

    private static boolean jj_3R_51() {
        Token xsp = jj_scanpos;
        if (Parser.jj_3R_57()) {
            jj_scanpos = xsp;
            if (Parser.jj_3R_58()) {
                jj_scanpos = xsp;
                if (Parser.jj_3R_59()) {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean jj_3R_42() {
        return Parser.jj_3R_51();
    }

    private static boolean jj_3R_50() {
        if (Parser.jj_scan_token(130)) {
            return true;
        }
        if (Parser.jj_3R_36()) {
            return true;
        }
        return Parser.jj_scan_token(131);
    }

    private static boolean jj_3_2() {
        if (Parser.jj_scan_token(138)) {
            return true;
        }
        return Parser.jj_scan_token(127);
    }

    private static boolean jj_3R_49() {
        return Parser.jj_3R_55();
    }

    private static boolean jj_3R_48() {
        return Parser.jj_3R_56();
    }

    private static boolean jj_3R_41() {
        Token xsp = jj_scanpos;
        if (Parser.jj_3R_48()) {
            jj_scanpos = xsp;
            if (Parser.jj_3R_49()) {
                jj_scanpos = xsp;
                if (Parser.jj_3R_50()) {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean jj_3R_98() {
        Token xsp = jj_scanpos;
        if (Parser.jj_scan_token(152)) {
            jj_scanpos = xsp;
            if (Parser.jj_scan_token(153)) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_55() {
        Token xsp;
        if (Parser.jj_scan_token(127)) {
            return true;
        }
        do {
            xsp = jj_scanpos;
        } while (!Parser.jj_3_2());
        jj_scanpos = xsp;
        return false;
    }

    private static boolean jj_3R_34() {
        Token xsp;
        if (Parser.jj_3R_41()) {
            return true;
        }
        do {
            xsp = jj_scanpos;
        } while (!Parser.jj_3R_42());
        jj_scanpos = xsp;
        return false;
    }

    private static boolean jj_3_8() {
        if (Parser.jj_3R_34()) {
            return true;
        }
        return Parser.jj_3R_35();
    }

    private static boolean jj_3R_47() {
        if (Parser.jj_scan_token(134)) {
            return true;
        }
        return Parser.jj_scan_token(135);
    }

    private static boolean jj_3R_46() {
        return Parser.jj_3R_55();
    }

    private static boolean jj_3R_97() {
        if (Parser.jj_3R_34()) {
            return true;
        }
        Token xsp = jj_scanpos;
        if (Parser.jj_3R_98()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    private static boolean jj_3R_54() {
        Token xsp = jj_scanpos;
        if (Parser.jj_scan_token(89)) {
            jj_scanpos = xsp;
            if (Parser.jj_scan_token(93)) {
                jj_scanpos = xsp;
                if (Parser.jj_scan_token(91)) {
                    jj_scanpos = xsp;
                    if (Parser.jj_scan_token(111)) {
                        jj_scanpos = xsp;
                        if (Parser.jj_scan_token(105)) {
                            jj_scanpos = xsp;
                            if (Parser.jj_scan_token(107)) {
                                jj_scanpos = xsp;
                                if (Parser.jj_scan_token(101)) {
                                    jj_scanpos = xsp;
                                    if (Parser.jj_scan_token(98)) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private static boolean jj_3R_45() {
        return Parser.jj_3R_54();
    }

    private static boolean jj_3R_38() {
        Token xsp = jj_scanpos;
        if (Parser.jj_3R_45()) {
            jj_scanpos = xsp;
            if (Parser.jj_3R_46()) {
                return true;
            }
        }
        do {
            xsp = jj_scanpos;
        } while (!Parser.jj_3R_47());
        jj_scanpos = xsp;
        return false;
    }

    private static boolean jj_3_7() {
        if (Parser.jj_3R_38()) {
            return true;
        }
        return Parser.jj_scan_token(127);
    }

    private static boolean jj_3R_96() {
        return Parser.jj_3R_97();
    }

    private static boolean jj_3R_95() {
        Token xsp = jj_scanpos;
        if (Parser.jj_scan_token(143)) {
            jj_scanpos = xsp;
            if (Parser.jj_scan_token(142)) {
                return true;
            }
        }
        return Parser.jj_3R_84();
    }

    private static boolean jj_3R_93() {
        Token xsp = jj_scanpos;
        if (Parser.jj_3R_95()) {
            jj_scanpos = xsp;
            if (Parser.jj_3R_96()) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_92() {
        if (Parser.jj_scan_token(153)) {
            return true;
        }
        return Parser.jj_3R_34();
    }

    private static boolean jj_3R_90() {
        Token xsp = jj_scanpos;
        if (Parser.jj_scan_token(154)) {
            jj_scanpos = xsp;
            if (Parser.jj_scan_token(155)) {
                return true;
            }
        }
        return Parser.jj_3R_82();
    }

    private static boolean jj_3R_94() {
        Token xsp = jj_scanpos;
        if (Parser.jj_scan_token(156)) {
            jj_scanpos = xsp;
            if (Parser.jj_scan_token(157)) {
                jj_scanpos = xsp;
                if (Parser.jj_scan_token(161)) {
                    return true;
                }
            }
        }
        return Parser.jj_3R_84();
    }

    private static boolean jj_3R_37() {
        if (Parser.jj_scan_token(127)) {
            return true;
        }
        return Parser.jj_scan_token(145);
    }

    private static boolean jj_3R_91() {
        if (Parser.jj_scan_token(152)) {
            return true;
        }
        return Parser.jj_3R_34();
    }

    private static boolean jj_3_5() {
        if (Parser.jj_scan_token(134)) {
            return true;
        }
        return Parser.jj_scan_token(135);
    }

    private static boolean jj_3R_89() {
        return Parser.jj_3R_93();
    }

    private static boolean jj_3R_85() {
        Token xsp = jj_scanpos;
        if (Parser.jj_scan_token(162)) {
            jj_scanpos = xsp;
            if (Parser.jj_scan_token(163)) {
                jj_scanpos = xsp;
                if (Parser.jj_scan_token(164)) {
                    return true;
                }
            }
        }
        return Parser.jj_3R_80();
    }

    private static boolean jj_3R_88() {
        return Parser.jj_3R_92();
    }

    private static boolean jj_3_1() {
        if (Parser.jj_scan_token(137)) {
            return true;
        }
        return Parser.jj_3R_33();
    }

    private static boolean jj_3R_87() {
        return Parser.jj_3R_91();
    }

    private static boolean jj_3R_84() {
        Token xsp = jj_scanpos;
        if (Parser.jj_3R_86()) {
            jj_scanpos = xsp;
            if (Parser.jj_3R_87()) {
                jj_scanpos = xsp;
                if (Parser.jj_3R_88()) {
                    jj_scanpos = xsp;
                    if (Parser.jj_3R_89()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean jj_3R_86() {
        Token xsp = jj_scanpos;
        if (Parser.jj_scan_token(154)) {
            jj_scanpos = xsp;
            if (Parser.jj_scan_token(155)) {
                return true;
            }
        }
        return Parser.jj_3R_84();
    }

    private static boolean jj_3R_83() {
        Token xsp = jj_scanpos;
        if (Parser.jj_scan_token(141)) {
            jj_scanpos = xsp;
            if (Parser.jj_scan_token(140)) {
                jj_scanpos = xsp;
                if (Parser.jj_scan_token(147)) {
                    jj_scanpos = xsp;
                    if (Parser.jj_scan_token(148)) {
                        return true;
                    }
                }
            }
        }
        return Parser.jj_3R_78();
    }

    private static boolean jj_3R_82() {
        Token xsp;
        if (Parser.jj_3R_84()) {
            return true;
        }
        do {
            xsp = jj_scanpos;
        } while (!Parser.jj_3R_94());
        jj_scanpos = xsp;
        return false;
    }

    private static boolean jj_3R_80() {
        Token xsp;
        if (Parser.jj_3R_82()) {
            return true;
        }
        do {
            xsp = jj_scanpos;
        } while (!Parser.jj_3R_90());
        jj_scanpos = xsp;
        return false;
    }

    private static boolean jj_3R_81() {
        Token xsp = jj_scanpos;
        if (Parser.jj_scan_token(146)) {
            jj_scanpos = xsp;
            if (Parser.jj_scan_token(149)) {
                return true;
            }
        }
        return Parser.jj_3R_76();
    }

    private static boolean jj_3R_78() {
        Token xsp;
        if (Parser.jj_3R_80()) {
            return true;
        }
        do {
            xsp = jj_scanpos;
        } while (!Parser.jj_3R_85());
        jj_scanpos = xsp;
        return false;
    }

    private static boolean jj_3_6() {
        return Parser.jj_3R_37();
    }

    private static boolean jj_3R_79() {
        if (Parser.jj_scan_token(158)) {
            return true;
        }
        return Parser.jj_3R_74();
    }

    private static boolean jj_3R_76() {
        Token xsp;
        if (Parser.jj_3R_78()) {
            return true;
        }
        do {
            xsp = jj_scanpos;
        } while (!Parser.jj_3R_83());
        jj_scanpos = xsp;
        return false;
    }

    private static boolean jj_3R_40() {
        return Parser.jj_3R_36();
    }

    private static boolean jj_3R_33() {
        Token xsp = jj_scanpos;
        if (Parser.jj_3R_39()) {
            jj_scanpos = xsp;
            if (Parser.jj_3R_40()) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_39() {
        return Parser.jj_scan_token(132);
    }

    private static boolean jj_3_4() {
        if (Parser.jj_scan_token(134)) {
            return true;
        }
        return Parser.jj_3R_36();
    }

    private static boolean jj_3R_75() {
        if (Parser.jj_scan_token(159)) {
            return true;
        }
        return Parser.jj_3R_69();
    }

    private static boolean jj_3R_77() {
        if (Parser.jj_scan_token(160)) {
            return true;
        }
        return Parser.jj_3R_72();
    }

    private static boolean jj_3R_73() {
        if (Parser.jj_scan_token(151)) {
            return true;
        }
        return Parser.jj_3R_66();
    }

    private static void jj_la1_init_0() {
        int[] nArray = new int[73];
        nArray[0] = Integer.MIN_VALUE;
        nArray[2] = 67133696;
        nArray[3] = 67133696;
        nArray[4] = 512;
        nArray[10] = 524288;
        jj_la1_0 = nArray;
    }

    private static void jj_la1_init_1() {
        int[] nArray = new int[73];
        nArray[1] = 131072;
        nArray[12] = 7;
        nArray[13] = 7;
        jj_la1_1 = nArray;
    }

    private static void jj_la1_init_2() {
        int[] nArray = new int[73];
        nArray[19] = 0x2A000000;
        nArray[21] = 0x2A000000;
        nArray[22] = 0x2A000000;
        nArray[55] = -2080374784;
        nArray[56] = -1375731712;
        nArray[57] = -2080374784;
        nArray[61] = 0x10000000;
        nArray[62] = -1375731712;
        nArray[63] = 0x10000000;
        nArray[65] = 0x2A000000;
        jj_la1_2 = nArray;
    }

    private static void jj_la1_init_3() {
        int[] nArray = new int[73];
        nArray[6] = Integer.MIN_VALUE;
        nArray[7] = -2004877312;
        nArray[8] = 4096;
        nArray[9] = 0x8800000;
        nArray[11] = 0x8800000;
        nArray[16] = -393732080;
        nArray[18] = -393732080;
        nArray[19] = -2147448284;
        nArray[21] = 35364;
        nArray[22] = -2145351132;
        nArray[24] = -393732080;
        nArray[43] = -393732080;
        nArray[45] = -393732080;
        nArray[49] = -393732080;
        nArray[51] = 1753751568;
        nArray[52] = 524304;
        nArray[53] = -393732080;
        nArray[55] = -389258926;
        nArray[56] = -389223562;
        nArray[57] = -389258926;
        nArray[60] = -393732080;
        nArray[61] = 1;
        nArray[62] = -389223562;
        nArray[63] = 1;
        nArray[64] = 8;
        nArray[65] = -393696716;
        nArray[66] = -393732080;
        nArray[67] = -393732080;
        nArray[68] = -393732080;
        nArray[70] = Integer.MIN_VALUE;
        nArray[71] = Integer.MIN_VALUE;
        nArray[72] = -393732080;
        jj_la1_3 = nArray;
    }

    private static void jj_la1_init_4() {
        int[] nArray = new int[73];
        nArray[5] = 512;
        nArray[14] = 2048;
        nArray[15] = 64;
        nArray[16] = 251707412;
        nArray[17] = 512;
        nArray[18] = 251707412;
        nArray[20] = 64;
        nArray[23] = 512;
        nArray[24] = 251707396;
        nArray[25] = 2048;
        nArray[26] = 65536;
        nArray[27] = 0x400000;
        nArray[28] = 0x800000;
        nArray[29] = Integer.MIN_VALUE;
        nArray[31] = 0x40000000;
        nArray[32] = 0x240000;
        nArray[33] = 0x240000;
        nArray[34] = 1585152;
        nArray[35] = 1585152;
        nArray[38] = 0xC000000;
        nArray[39] = 0xC000000;
        nArray[40] = 0x30000000;
        nArray[41] = 0x30000000;
        nArray[42] = 0xC000000;
        nArray[43] = 251707396;
        nArray[44] = 49152;
        nArray[45] = 49156;
        nArray[46] = 0x3000000;
        nArray[47] = 0x3000000;
        nArray[48] = 1092;
        nArray[49] = 4;
        nArray[50] = 1092;
        nArray[53] = 251707396;
        nArray[54] = 512;
        nArray[55] = 50331924;
        nArray[56] = 50331924;
        nArray[57] = 50331924;
        nArray[58] = 512;
        nArray[59] = 0x3000000;
        nArray[60] = 4;
        nArray[62] = 50331924;
        nArray[65] = 0x3000004;
        nArray[66] = 251707396;
        nArray[67] = 0x3000004;
        nArray[68] = 0x3000004;
        nArray[69] = 512;
        nArray[72] = 251707396;
        jj_la1_4 = nArray;
    }

    private static void jj_la1_init_5() {
        int[] nArray = new int[73];
        nArray[25] = 65504;
        nArray[30] = 1;
        nArray[36] = 28;
        nArray[37] = 28;
        nArray[40] = 2;
        nArray[41] = 2;
        jj_la1_5 = nArray;
    }

    public Parser(InputStream stream, PetriNet net, Hashtable<String, Double> cT) {
        this(stream, null, net, cT);
    }

    public Parser(InputStream stream, String encoding, PetriNet net, Hashtable<String, Double> cT) {
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser.  ");
            System.out.println("       You must either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        try {
            jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        token_source = new ParserTokenManager(jj_input_stream);
        token = new Token();
        myPN = net;
        constants = cT;
        jj_ntk = -1;
        jj_gen = 0;
        int i = 0;
        while (i < 73) {
            Parser.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < jj_2_rtns.length) {
            Parser.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public static void ReInit(InputStream stream) {
        Parser.ReInit(stream, null);
    }

    public static void ReInit(InputStream stream, String encoding) {
        try {
            jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        ParserTokenManager.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        int i = 0;
        while (i < 73) {
            Parser.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < jj_2_rtns.length) {
            Parser.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public Parser(Reader stream) {
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser. ");
            System.out.println("       You must either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        jj_input_stream = new JavaCharStream(stream, 1, 1);
        token_source = new ParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        int i = 0;
        while (i < 73) {
            Parser.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < jj_2_rtns.length) {
            Parser.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public static void ReInit(Reader stream) {
        jj_input_stream.ReInit(stream, 1, 1);
        ParserTokenManager.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        int i = 0;
        while (i < 73) {
            Parser.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < jj_2_rtns.length) {
            Parser.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public Parser(ParserTokenManager tm) {
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser. ");
            System.out.println("       You must either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        int i = 0;
        while (i < 73) {
            Parser.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < jj_2_rtns.length) {
            Parser.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(ParserTokenManager tm) {
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        int i = 0;
        while (i < 73) {
            Parser.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < jj_2_rtns.length) {
            Parser.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    private static Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = token;
        token = oldToken.next != null ? Parser.token.next : (Parser.token.next = ParserTokenManager.getNextToken());
        jj_ntk = -1;
        if (Parser.token.kind == kind) {
            ++jj_gen;
            if (++jj_gc > 100) {
                jj_gc = 0;
                int i = 0;
                while (i < jj_2_rtns.length) {
                    JJCalls c = jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                    ++i;
                }
            }
            return token;
        }
        token = oldToken;
        jj_kind = kind;
        throw Parser.generateParseException();
    }

    private static boolean jj_scan_token(int kind) {
        if (jj_scanpos == jj_lastpos) {
            --jj_la;
            if (Parser.jj_scanpos.next == null) {
                jj_scanpos = Parser.jj_scanpos.next = ParserTokenManager.getNextToken();
                jj_lastpos = Parser.jj_scanpos.next;
            } else {
                jj_lastpos = jj_scanpos = Parser.jj_scanpos.next;
            }
        } else {
            jj_scanpos = Parser.jj_scanpos.next;
        }
        if (jj_rescan) {
            int i = 0;
            Token tok = token;
            while (tok != null && tok != jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                Parser.jj_add_error_token(kind, i);
            }
        }
        if (Parser.jj_scanpos.kind != kind) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            throw jj_ls;
        }
        return false;
    }

    public static final Token getNextToken() {
        token = Parser.token.next != null ? Parser.token.next : (Parser.token.next = ParserTokenManager.getNextToken());
        jj_ntk = -1;
        ++jj_gen;
        return token;
    }

    public static final Token getToken(int index) {
        Token t = token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = ParserTokenManager.getNextToken());
            ++i;
        }
        return t;
    }

    private static int jj_ntk() {
        jj_nt = Parser.token.next;
        if (jj_nt == null) {
            Parser.token.next = ParserTokenManager.getNextToken();
            jj_ntk = Parser.token.next.kind;
            return jj_ntk;
        }
        jj_ntk = Parser.jj_nt.kind;
        return jj_ntk;
    }

    private static void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == jj_endpos + 1) {
            Parser.jj_lasttokens[Parser.jj_endpos++] = kind;
        } else if (jj_endpos != 0) {
            jj_expentry = new int[jj_endpos];
            int i = 0;
            while (i < jj_endpos) {
                Parser.jj_expentry[i] = jj_lasttokens[i];
                ++i;
            }
            block1: for (int[] oldentry : jj_expentries) {
                if (oldentry.length != jj_expentry.length) continue;
                int i2 = 0;
                while (i2 < jj_expentry.length) {
                    if (oldentry[i2] != jj_expentry[i2]) continue block1;
                    ++i2;
                }
                jj_expentries.add(jj_expentry);
                break;
            }
            if (pos != 0) {
                jj_endpos = pos;
                Parser.jj_lasttokens[Parser.jj_endpos - 1] = kind;
            }
        }
    }

    public static ParseException generateParseException() {
        jj_expentries.clear();
        boolean[] la1tokens = new boolean[177];
        if (jj_kind >= 0) {
            la1tokens[Parser.jj_kind] = true;
            jj_kind = -1;
        }
        int i = 0;
        while (i < 73) {
            if (jj_la1[i] == jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((jj_la1_0[i] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    if ((jj_la1_1[i] & 1 << j) != 0) {
                        la1tokens[32 + j] = true;
                    }
                    if ((jj_la1_2[i] & 1 << j) != 0) {
                        la1tokens[64 + j] = true;
                    }
                    if ((jj_la1_3[i] & 1 << j) != 0) {
                        la1tokens[96 + j] = true;
                    }
                    if ((jj_la1_4[i] & 1 << j) != 0) {
                        la1tokens[128 + j] = true;
                    }
                    if ((jj_la1_5[i] & 1 << j) != 0) {
                        la1tokens[160 + j] = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 177) {
            if (la1tokens[i]) {
                jj_expentry = new int[1];
                Parser.jj_expentry[0] = i;
                jj_expentries.add(jj_expentry);
            }
            ++i;
        }
        jj_endpos = 0;
        Parser.jj_rescan_token();
        Parser.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[jj_expentries.size()][];
        int i2 = 0;
        while (i2 < jj_expentries.size()) {
            exptokseq[i2] = (int[])jj_expentries.get(i2);
            ++i2;
        }
        return new ParseException(token, exptokseq, tokenImage);
    }

    public static final void enable_tracing() {
    }

    public static final void disable_tracing() {
    }

    private static void jj_rescan_token() {
        jj_rescan = true;
        int i = 0;
        while (i < 9) {
            try {
                JJCalls p = jj_2_rtns[i];
                do {
                    if (p.gen <= jj_gen) continue;
                    jj_la = p.arg;
                    jj_lastpos = jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            Parser.jj_3_1();
                            break;
                        }
                        case 1: {
                            Parser.jj_3_2();
                            break;
                        }
                        case 2: {
                            Parser.jj_3_3();
                            break;
                        }
                        case 3: {
                            Parser.jj_3_4();
                            break;
                        }
                        case 4: {
                            Parser.jj_3_5();
                            break;
                        }
                        case 5: {
                            Parser.jj_3_6();
                            break;
                        }
                        case 6: {
                            Parser.jj_3_7();
                            break;
                        }
                        case 7: {
                            Parser.jj_3_8();
                            break;
                        }
                        case 8: {
                            Parser.jj_3_9();
                        }
                    }
                } while ((p = p.next) != null);
            }
            catch (LookaheadSuccess lookaheadSuccess) {}
            ++i;
        }
        jj_rescan = false;
    }

    private static void jj_save(int index, int xla) {
        JJCalls p = jj_2_rtns[index];
        while (p.gen > jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = jj_gen + xla - jj_la;
        p.first = token;
        p.arg = xla;
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

