/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.jhydra.driver.steadystatesolver;

import java.util.BitSet;
import uk.ac.ed.inf.pepa.jhydra.matrix.Matrix;
import uk.ac.ed.inf.pepa.jhydra.matrix.MatrixElement;
import uk.ac.ed.inf.pepa.jhydra.matrix.MatrixRow;

public class SteadyStateSolver {
    private Matrix myMatrix;

    public SteadyStateSolver(Matrix m) {
        this.myMatrix = m;
    }

    public double[] solve(BitSet sources) {
        this.myMatrix.pify();
        boolean converged = false;
        int iterations = 0;
        double accuracy = 1.0E-8;
        double sum = 0.0;
        int tangible = (int)this.myMatrix.getTangible();
        double[] x = new double[tangible];
        double[] result = new double[tangible];
        System.out.println("\nCalculating steady state solution...\n");
        int i = 0;
        while (i < tangible) {
            x[i] = 1.0 / (double)tangible;
            result[i] = x[i];
            ++i;
        }
        System.out.println("         Iteration |        Accuracy |");
        System.out.println("-------------------+-----------------+");
        while (!converged) {
            i = 0;
            while (i < tangible) {
                MatrixRow mC = this.myMatrix.getCol(i);
                sum = 0.0;
                int j = 0;
                while (j < mC.size()) {
                    MatrixElement mE = mC.getElement(j);
                    if (mE.getOffset() != (long)i) {
                        sum += mE.getValue() * result[(int)mE.getOffset()];
                    }
                    ++j;
                }
                result[i] = sum;
                ++i;
            }
            if (iterations != 0 && iterations % 5 == 0) {
                double maxSoln = 0.0;
                double maxDiff = 0.0;
                i = 0;
                while (i < tangible) {
                    if (result[i] > maxSoln) {
                        maxSoln = result[i];
                    }
                    if (Math.abs(result[i] - x[i]) > maxDiff) {
                        maxDiff = Math.abs(result[i] - x[i]);
                    }
                    ++i;
                }
                System.out.println("                 " + iterations + " |             " + maxDiff / maxSoln + " |");
                if (maxDiff / maxSoln < accuracy) {
                    converged = true;
                }
            }
            i = 0;
            while (i < tangible) {
                x[i] = result[i];
                ++i;
            }
            ++iterations;
        }
        System.out.println("-------------------+-----------------+\n");
        sum = 0.0;
        i = 0;
        while (i < tangible) {
            sum += result[i];
            ++i;
        }
        i = 0;
        while (i < tangible) {
            int n = i++;
            result[n] = result[n] / sum;
        }
        System.out.println("Finished calculating steady state solution in " + iterations + " iterations...");
        this.myMatrix.unpify();
        double targetStatePiSum = 0.0;
        int i2 = 0;
        while (i2 < tangible) {
            if (sources.get(i2)) {
                targetStatePiSum += result[i2];
            } else {
                result[i2] = 0.0;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < tangible) {
            int n = i2++;
            result[n] = result[n] / targetStatePiSum;
        }
        return result;
    }
}

