/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.jhydra.evaluator;

import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;

public class ExpressionEvaluator {
    private String[] separators = new String[]{"*", "/", "%", "+", "-", "&&", "||", "==", "!=", "<=", ">=", "<", ">", "!", "(", ")", ",", "?", ":"};
    private Hashtable<String, Opr> operatorTable = new Hashtable();
    private Stack<String> operatorStack = new Stack();
    private Stack<String> operandStack = new Stack();

    public ExpressionEvaluator() {
        this.operatorTable.put("*", Opr.MULT);
        this.operatorTable.put("/", Opr.DIV);
        this.operatorTable.put("%", Opr.MOD);
        this.operatorTable.put("+", Opr.PLUS);
        this.operatorTable.put("-", Opr.MINUS);
        this.operatorTable.put("&&", Opr.AND);
        this.operatorTable.put("||", Opr.OR);
        this.operatorTable.put("==", Opr.EQUALS);
        this.operatorTable.put("!=", Opr.NEQUALS);
        this.operatorTable.put("<=", Opr.LEQ);
        this.operatorTable.put(">=", Opr.GEQ);
        this.operatorTable.put("<", Opr.LESS);
        this.operatorTable.put(">", Opr.GREATER);
        this.operatorTable.put("!", Opr.NOT);
    }

    public void addSpace(String input) {
        int i = 0;
        while (i < this.separators.length) {
            String str = this.separators[i];
            input = input.replace(str, " " + str + " ");
            ++i;
        }
        input = input.replace("=  =", "==");
        input = input.replace("< =", "<=");
        input = input.replace("> =", ">=");
        input = input.replace("! =", "!=");
    }

    public String evaluate(String infix) {
        String postfixString = this.toPostfix(infix);
        String resultString = this.evaluatePostfix(postfixString);
        return resultString;
    }

    /*
     * Unable to fully structure code
     */
    private String toPostfix(String infix) {
        s = new StringTokenizer(infix);
        postfix = "";
        while (s.hasMoreTokens()) {
            symbol = s.nextToken();
            if (!this.isSeparator(symbol)) {
                postfix = String.valueOf(postfix) + " " + symbol;
                continue;
            }
            if (symbol.equals("(")) {
                operator = new String("(");
                this.operatorStack.push(operator);
                continue;
            }
            if (!symbol.equals(")")) ** GOTO lbl21
            while (!this.operatorStack.peek().equals("(")) {
                postfix = String.valueOf(postfix) + " " + this.operatorStack.pop();
            }
            this.operatorStack.pop();
            continue;
lbl-1000:
            // 1 sources

            {
                postfix = String.valueOf(postfix) + " " + this.operatorStack.pop();
lbl21:
                // 2 sources

                ** while (!this.operatorStack.empty() && !this.operatorStack.peek().equals((Object)"(") && this.prec((String)symbol) <= this.prec((String)this.operatorStack.peek()))
            }
lbl22:
            // 1 sources

            operator = new String(symbol);
            this.operatorStack.push(operator);
        }
        while (!this.operatorStack.empty()) {
            postfix = String.valueOf(postfix) + " " + this.operatorStack.pop();
        }
        return postfix;
    }

    private String evaluatePostfix(String postfix) {
        StringTokenizer s = new StringTokenizer(postfix);
        while (s.hasMoreTokens()) {
            String symbol = s.nextToken();
            if (!this.isSeparator(symbol)) {
                this.operandStack.push(symbol);
                continue;
            }
            String result = "";
            if (symbol.equals("!")) {
                String op = this.operandStack.pop();
                result = op.toLowerCase().equals("true") ? "false" : "true";
            } else {
                String op2 = this.operandStack.pop();
                String op1 = this.operandStack.pop();
                Opr op = this.operatorTable.get(symbol);
                switch (op) {
                    case MULT: {
                        Double res = Double.parseDouble(op1) * Double.parseDouble(op2);
                        result = res.toString();
                        break;
                    }
                    case PLUS: {
                        Double res = Double.parseDouble(op1) + Double.parseDouble(op2);
                        result = res.toString();
                        break;
                    }
                    case MINUS: {
                        Double res = Double.parseDouble(op1) - Double.parseDouble(op2);
                        result = res.toString();
                        break;
                    }
                    case DIV: {
                        Double res = Double.parseDouble(op1) / Double.parseDouble(op2);
                        result = res.toString();
                        break;
                    }
                    case MOD: {
                        Double res = Double.parseDouble(op1) % Double.parseDouble(op2);
                        result = res.toString();
                        break;
                    }
                    case AND: {
                        if (op1.toLowerCase().equals("true") && op2.toLowerCase().equals("true")) {
                            result = "true";
                            break;
                        }
                        result = "false";
                        break;
                    }
                    case OR: {
                        if (op1.toLowerCase().equals("true") || op2.toLowerCase().equals("true")) {
                            result = "true";
                            break;
                        }
                        result = "false";
                        break;
                    }
                    case EQUALS: {
                        if (op1.equals(op2)) {
                            result = "true";
                            break;
                        }
                        result = "false";
                        break;
                    }
                    case NEQUALS: {
                        if (!op1.equals(op2)) {
                            result = "true";
                            break;
                        }
                        result = "false";
                        break;
                    }
                    case LESS: {
                        if (Double.parseDouble(op1) < Double.parseDouble(op2)) {
                            result = "true";
                            break;
                        }
                        result = "false";
                        break;
                    }
                    case LEQ: {
                        if (Double.parseDouble(op1) <= Double.parseDouble(op2)) {
                            result = "true";
                            break;
                        }
                        result = "false";
                        break;
                    }
                    case GREATER: {
                        if (Double.parseDouble(op1) > Double.parseDouble(op2)) {
                            result = "true";
                            break;
                        }
                        result = "false";
                        break;
                    }
                    case GEQ: {
                        result = Double.parseDouble(op1) >= Double.parseDouble(op2) ? "true" : "false";
                    }
                }
            }
            String operand = new String(result);
            this.operandStack.push(operand);
        }
        String value = this.operandStack.pop();
        return value;
    }

    private int prec(String x) {
        if (x.equals("=")) {
            return 1;
        }
        if (x.equals("?") || x.equals(":")) {
            return 2;
        }
        if (x.equals("||")) {
            return 3;
        }
        if (x.equals("&&")) {
            return 4;
        }
        if (x.equals("==") || x.equals("!=")) {
            return 8;
        }
        if (x.equals("<") || x.equals("<=") || x.equals(">") || x.equals(">=")) {
            return 9;
        }
        if (x.equals("+") || x.equals("-")) {
            return 11;
        }
        if (x.equals("*") || x.equals("/") || x.equals("%")) {
            return 12;
        }
        if (x.equals("!")) {
            return 13;
        }
        return 0;
    }

    private boolean isSeparator(String s) {
        int i = 0;
        while (i < this.separators.length) {
            String str = this.separators[i];
            if (str.equals(s)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Opr {
        MULT,
        DIV,
        MOD,
        PLUS,
        MINUS,
        AND,
        OR,
        EQUALS,
        NEQUALS,
        LEQ,
        GEQ,
        LESS,
        GREATER,
        NOT;

    }
}

