/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.jhydra.petrinet;

import java.awt.Graphics2D;
import java.io.Serializable;
import uk.ac.ed.inf.pepa.jhydra.petrinet.Arc;
import uk.ac.ed.inf.pepa.jhydra.petrinet.Element;
import uk.ac.ed.inf.pepa.jhydra.petrinet.PetriNet;

public abstract class Node
extends Element
implements Serializable {
    protected PetriNet myPN;
    protected int centreX;
    protected int centreY;
    protected int width;
    protected int height;

    public Node(int m, int n, int w, int h, PetriNet pn) {
        this.centreX = m;
        this.centreY = n;
        this.width = w;
        this.height = h;
        this.myPN = pn;
        this.comment = null;
    }

    public Node(String s) {
        super(s);
    }

    public Node(String s, PetriNet pn) {
        super(s);
        this.myPN = pn;
    }

    public boolean contains(int m, int n) {
        int xmin = this.getX() - this.getWidth() / 2;
        int xmax = this.getX() + this.getWidth() / 2;
        int ymin = this.getY() - this.getHeight() / 2;
        int ymax = this.getY() + this.getHeight() / 2;
        return xmin < m && xmax > m && ymin < n && ymax > n;
    }

    public void moveNode(int x, int y) {
        this.centreX = x;
        this.centreY = y;
        this.moveArcs();
    }

    private void moveArcs() {
        int count = 0;
        while (count < this.myPN.getNumberOfArcs()) {
            Arc arc = this.myPN.getArc(count);
            if (arc.getStart() == this) {
                arc.setStart(this);
            } else if (arc.getEnd() == this) {
                arc.setEnd(this);
            }
            int x = arc.calcBoxX();
            int y = arc.calcBoxY();
            arc.setBoxX(x);
            arc.setBoxY(y);
            ++count;
        }
    }

    public abstract void draw(Graphics2D var1);

    public int getX() {
        return this.centreX;
    }

    public int getY() {
        return this.centreY;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

