/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.jhydra.petrinet;

import java.awt.Color;
import java.awt.Graphics2D;
import uk.ac.ed.inf.pepa.jhydra.petrinet.ImmediateTransition;
import uk.ac.ed.inf.pepa.jhydra.petrinet.PetriNet;
import uk.ac.ed.inf.pepa.jhydra.petrinet.Transition;

public class TimedTransition
extends Transition {
    private String rate;

    public TimedTransition(int x, int y, PetriNet pn) {
        super(x, y, pn);
    }

    public TimedTransition(String n, String r, PetriNet pn, String c) {
        super(n, pn, c);
        this.rate = r;
        System.out.println("Created new timed transition " + this.name + " with rate " + r + "...");
    }

    public boolean isEnabled() {
        int count = 0;
        while (count < this.myPN.getNumberOfImmTransitions()) {
            ImmediateTransition iT = this.myPN.getImmediateTransition(count);
            if (iT != null && iT.isEnabled()) {
                return false;
            }
            ++count;
        }
        return this.myPN.conditionHolds(this.enablingCondition, this.myPN.getCurrentMarking());
    }

    public void draw(Graphics2D g2) {
        super.draw(g2);
        if (!this.myPN.isAnimating() || !this.isEnabled()) {
            g2.setColor(Color.white);
            g2.fillRect(this.centreX - this.width / 2 + 1, this.centreY - this.height / 2 + 1, this.width - 2, this.height - 2);
        }
    }

    public String getRate() {
        return this.rate;
    }

    public void setRate(String r) {
        this.rate = r;
    }
}

