/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.largescale;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Map;
import uk.ac.ed.inf.pepa.largescale.IGeneratingFunction;
import uk.ac.ed.inf.pepa.largescale.IParametricDerivationGraph;
import uk.ac.ed.inf.pepa.largescale.ISequentialComponent;
import uk.ac.ed.inf.pepa.largescale.ParametricDerivationGraphBuilder;
import uk.ac.ed.inf.pepa.largescale.expressions.Coordinate;
import uk.ac.ed.inf.pepa.largescale.expressions.DivisionExpression;
import uk.ac.ed.inf.pepa.largescale.expressions.Expression;
import uk.ac.ed.inf.pepa.largescale.expressions.ExpressionVisitor;
import uk.ac.ed.inf.pepa.largescale.expressions.MinimumExpression;
import uk.ac.ed.inf.pepa.largescale.expressions.MultiplicationExpression;
import uk.ac.ed.inf.pepa.largescale.expressions.RateExpression;
import uk.ac.ed.inf.pepa.largescale.expressions.SubtractionExpression;
import uk.ac.ed.inf.pepa.largescale.expressions.SummationExpression;
import uk.ac.ed.inf.pepa.ode.DifferentialAnalysisException;
import uk.ac.ed.inf.pepa.parsing.ModelNode;
import uk.ac.ed.inf.pepa.tools.PepaTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatlabConverter {
    private static final boolean REDUCE_PROBLEM = false;
    private IParametricDerivationGraph graph;
    private ArrayList<Coordinate[]> list;
    private StringBuffer model = new StringBuffer();

    public static void main(String[] args) throws DifferentialAnalysisException, InterruptedException, IOException {
        String modelText = PepaTools.readText(args[0]);
        ModelNode model = (ModelNode)PepaTools.parse(modelText);
        IParametricDerivationGraph graph = ParametricDerivationGraphBuilder.createDerivationGraph(model, null);
        MatlabConverter mc = new MatlabConverter(graph);
        String matlab = mc.getMatlabModel();
        System.out.println(matlab);
    }

    public MatlabConverter(IParametricDerivationGraph graph) throws DifferentialAnalysisException {
        if (graph == null) {
            throw new NullPointerException();
        }
        this.graph = graph;
        this.list = this.getCoordinatesPerComponent();
        int problemSize = graph.getInitialState().length;
        Expression[] expression = new Expression[problemSize];
        int i = 0;
        while (i < expression.length) {
            expression[i] = new RateExpression(0.0);
            ++i;
        }
        IGeneratingFunction[] iGeneratingFunctionArray = graph.getGeneratingFunctions();
        int n = iGeneratingFunctionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IGeneratingFunction function = iGeneratingFunctionArray[n2];
            short[] jump = function.getJump();
            int i2 = 0;
            while (i2 < jump.length) {
                if (jump[i2] == -1) {
                    expression[i2] = new SubtractionExpression(expression[i2], function.getRate());
                } else if (jump[i2] == 1) {
                    expression[i2] = new SummationExpression(expression[i2], function.getRate());
                }
                ++i2;
            }
            ++n2;
        }
        this.createModel(graph.getInitialState(), expression);
    }

    private void createModel(double[] initialState, Expression[] expressions) throws DifferentialAnalysisException {
        int[][] jacobianHint = new int[initialState.length][initialState.length];
        int i = 0;
        while (i < initialState.length) {
            int j = 0;
            while (j < initialState.length) {
                jacobianHint[i][j] = 0;
                ++j;
            }
            ++i;
        }
        this.model.append("x0 = [");
        double[] dArray = initialState;
        int n = initialState.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            this.model.append(String.valueOf(d) + " ");
            ++n2;
        }
        this.model.append("]';\n");
        this.model.append("dx = zeros(" + initialState.length + ",1);\n");
        i = 0;
        while (i < expressions.length) {
            PrintVisitor v = new PrintVisitor();
            expressions[i].accept(v);
            this.model.append(new Formatter().format("dx(%d) = %s;\n", i + 1, v.getString()));
            ++i;
        }
    }

    private int getNewIndex(int oldIndex) {
        return oldIndex;
    }

    private boolean removedFromList(int coordinate) {
        return false;
    }

    private int[] oldIndicesOfRemoved(int coordinate) {
        throw new IllegalStateException();
    }

    private int populationLevelOfRemovedCoordinate(int coordinate) {
        throw new IllegalStateException();
    }

    private ArrayList<Coordinate[]> getCoordinatesPerComponent() {
        ISequentialComponent[] sequentialComponents = this.graph.getSequentialComponents();
        ArrayList<Coordinate[]> list = new ArrayList<Coordinate[]>(sequentialComponents.length);
        int i = 0;
        while (i < sequentialComponents.length) {
            ISequentialComponent component = sequentialComponents[i];
            Coordinate[] coordinates = new Coordinate[component.getComponentMapping().size()];
            int c = 0;
            for (Map.Entry<Short, Coordinate> entry : component.getComponentMapping()) {
                coordinates[c++] = entry.getValue();
            }
            list.add(coordinates);
            ++i;
        }
        return list;
    }

    public String getMatlabModel() {
        return this.model.toString();
    }

    private class PrintVisitor
    implements ExpressionVisitor {
        private StringBuffer buf = new StringBuffer();

        private PrintVisitor() {
        }

        public String getString() {
            return this.buf.toString();
        }

        public void visitCoordinate(Coordinate coordinate) throws DifferentialAnalysisException {
            int oldIndex = coordinate.getCoordinate();
            int BASE = 1;
            if (!MatlabConverter.this.removedFromList(oldIndex)) {
                this.buf.append("x(" + (MatlabConverter.this.getNewIndex(oldIndex) + BASE) + ")");
            } else {
                int[] indices;
                this.buf.append("(");
                this.buf.append(MatlabConverter.this.populationLevelOfRemovedCoordinate(oldIndex));
                int[] nArray = indices = MatlabConverter.this.oldIndicesOfRemoved(oldIndex);
                int n = indices.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    this.buf.append(" - x(" + (MatlabConverter.this.getNewIndex(i) + BASE) + ")");
                    ++n2;
                }
                this.buf.append(")");
            }
        }

        public void visitDivisionExpression(DivisionExpression div) throws DifferentialAnalysisException {
            PrintVisitor lhs = new PrintVisitor();
            PrintVisitor rhs = new PrintVisitor();
            div.getLhs().accept(lhs);
            div.getRhs().accept(rhs);
            this.buf.append("div(" + lhs.getString() + "," + rhs.getString() + ")");
        }

        public void visitMinimumExpression(MinimumExpression min) throws DifferentialAnalysisException {
            PrintVisitor lhs = new PrintVisitor();
            PrintVisitor rhs = new PrintVisitor();
            min.getLhs().accept(lhs);
            min.getRhs().accept(rhs);
            this.buf.append("min(" + lhs.getString() + "," + rhs.getString() + ")");
        }

        public void visitMultiplicationExpression(MultiplicationExpression mult) throws DifferentialAnalysisException {
            PrintVisitor lhs = new PrintVisitor();
            PrintVisitor rhs = new PrintVisitor();
            mult.getLhs().accept(lhs);
            mult.getRhs().accept(rhs);
            this.buf.append(String.valueOf(lhs.getString()) + "*" + rhs.getString());
        }

        public void visitRateExpression(RateExpression rate) throws DifferentialAnalysisException {
            this.buf.append(rate.getRate());
        }

        public void visitSubtractionExpression(SubtractionExpression subtractionExpression) throws DifferentialAnalysisException {
            PrintVisitor lhs = new PrintVisitor();
            PrintVisitor rhs = new PrintVisitor();
            subtractionExpression.getLhs().accept(lhs);
            subtractionExpression.getRhs().accept(rhs);
            this.buf.append(String.valueOf(lhs.getString()) + "-" + rhs.getString());
        }

        public void visitSummationExpression(SummationExpression sum) throws DifferentialAnalysisException {
            PrintVisitor lhs = new PrintVisitor();
            PrintVisitor rhs = new PrintVisitor();
            sum.getLhs().accept(lhs);
            sum.getRhs().accept(rhs);
            this.buf.append(String.valueOf(lhs.getString()) + "+" + rhs.getString());
        }
    }
}

