/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.largescale;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import uk.ac.ed.inf.pepa.DoNothingMonitor;
import uk.ac.ed.inf.pepa.IProgressMonitor;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.Compiler;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.ISymbolGenerator;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.State;
import uk.ac.ed.inf.pepa.largescale.IGeneratingFunction;
import uk.ac.ed.inf.pepa.largescale.IParametricDerivationGraph;
import uk.ac.ed.inf.pepa.largescale.IParametricTransitionTriple;
import uk.ac.ed.inf.pepa.largescale.ISequentialComponent;
import uk.ac.ed.inf.pepa.largescale.internal.GeneratingFunction;
import uk.ac.ed.inf.pepa.largescale.internal.ParametricComponent;
import uk.ac.ed.inf.pepa.largescale.internal.ParametricStateExplorer;
import uk.ac.ed.inf.pepa.largescale.internal.ParametricStateExplorerBuilder;
import uk.ac.ed.inf.pepa.largescale.internal.ParametricTransition;
import uk.ac.ed.inf.pepa.largescale.internal.ParametricTransitionTriple;
import uk.ac.ed.inf.pepa.model.Model;
import uk.ac.ed.inf.pepa.ode.DifferentialAnalysisException;
import uk.ac.ed.inf.pepa.parsing.ModelNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParametricDerivationGraphBuilder {
    private double[] initialState;
    private ParametricStateExplorer explorer;
    private ArrayList<ParametricTransitionTriple> parametricDerivationGraph = new ArrayList(20);
    private ArrayList<GeneratingFunction> generatingFunctions = new ArrayList();
    private ISymbolGenerator generator;
    private static final int REFRESH_MONITOR = 20;

    public static IParametricDerivationGraph createDerivationGraph(ModelNode model, IProgressMonitor monitor) throws DifferentialAnalysisException, InterruptedException {
        final ParametricDerivationGraphBuilder builder = new ParametricDerivationGraphBuilder(model);
        builder.derive(monitor);
        final ParametricTransitionTriple[] triples = new ParametricTransitionTriple[builder.getDerivationGraph().size()];
        builder.getDerivationGraph().toArray(triples);
        final GeneratingFunction[] functions = new GeneratingFunction[builder.getGeneratingFunctions().size()];
        builder.getGeneratingFunctions().toArray(functions);
        final short[] processMappings = builder.explorer.getProcessMappings();
        return new IParametricDerivationGraph(){

            public IGeneratingFunction[] getGeneratingFunctions() {
                return functions;
            }

            public ISymbolGenerator getSymbolGenerator() {
                return builder.getSymbolGenerator();
            }

            public IParametricTransitionTriple[] getTransitionTriples() {
                return triples;
            }

            public double[] getInitialState() {
                return builder.getInitialState();
            }

            public short[] getProcessMappings() {
                return processMappings;
            }

            public ISequentialComponent[] getSequentialComponents() {
                return builder.explorer.getSequentialComponents();
            }
        };
    }

    private ParametricDerivationGraphBuilder(ModelNode model) throws DifferentialAnalysisException {
        Model cModel = new Compiler(true, model).getModel();
        ParametricStateExplorerBuilder seb = new ParametricStateExplorerBuilder(cModel);
        this.explorer = seb.getExplorer();
        this.generator = seb.getSymbolGenerator();
        this.initialState = new double[this.explorer.getProblemSize()];
        Arrays.fill(this.initialState, 0.0);
        short[] firstComponent = this.generator.getInitialState();
        int i = 0;
        while (i < firstComponent.length) {
            this.initialState[this.explorer.getSequentialComponents()[i].getCoordinate((short)firstComponent[i])] = this.explorer.getSequentialComponents()[i].getInitialPopulationLevel();
            ++i;
        }
    }

    public ISymbolGenerator getSymbolGenerator() {
        return this.generator;
    }

    public double[] getInitialState() {
        return this.initialState;
    }

    public ArrayList<ParametricTransitionTriple> getDerivationGraph() {
        return this.parametricDerivationGraph;
    }

    public ArrayList<GeneratingFunction> getGeneratingFunctions() {
        return this.generatingFunctions;
    }

    public void derive(IProgressMonitor monitor) throws DifferentialAnalysisException, InterruptedException {
        if (monitor == null) {
            monitor = new DoNothingMonitor();
        }
        monitor.beginTask(-1);
        HashSet<State> exploredStates = new HashSet<State>();
        LinkedList<State> queue = new LinkedList<State>();
        short[] initialState = this.generator.getInitialState();
        int hashCode = Arrays.hashCode(initialState);
        State initState = new State(initialState, hashCode);
        exploredStates.add(initState);
        queue.add(initState);
        int transitions = 0;
        ParametricTransition[] found = null;
        int stateNumber = 0;
        while (!queue.isEmpty()) {
            if (monitor.isCanceled()) {
                monitor.done();
                throw new InterruptedException("ODE generation was interrupted");
            }
            State s = (State)queue.remove();
            if (stateNumber++ % 20 == 0) {
                monitor.worked(20);
            }
            try {
                found = this.explorer.exploreState(s.fState);
            }
            catch (DifferentialAnalysisException e) {
                throw this.createException(s, e.getMessage());
            }
            if (found.length == 0) {
                monitor.done();
                throw this.createException(s, "Deadlock found.");
            }
            transitions += found.length;
            int i = 0;
            while (i < found.length) {
                ParametricTransition aT = found[i];
                hashCode = Arrays.hashCode(aT.getTarget());
                State target = new State(aT.getTarget(), hashCode);
                if (!exploredStates.contains(target)) {
                    exploredStates.add(target);
                    queue.add(target);
                }
                ParametricTransitionTriple triple = new ParametricTransitionTriple();
                triple.setSource(s.fState);
                triple.setTarget(aT.getTarget());
                triple.setActionId(aT.getActionId());
                triple.setRate(aT.getParametricRate());
                this.parametricDerivationGraph.add(triple);
                ++i;
            }
        }
        this.explorer.dispose();
        this.parametricDerivationGraph.trimToSize();
        this.buildGeneratingFunctions();
        monitor.done();
    }

    private void buildGeneratingFunctions() {
        for (IParametricTransitionTriple iParametricTransitionTriple : this.parametricDerivationGraph) {
            short[] jump = this.buildJump(iParametricTransitionTriple.getSource(), iParametricTransitionTriple.getTarget());
            short actionId = iParametricTransitionTriple.getActionId();
            boolean foundSameJump = false;
            for (IGeneratingFunction iGeneratingFunction : this.generatingFunctions) {
                if (!Arrays.equals(jump, iGeneratingFunction.getJump()) || actionId != iGeneratingFunction.getActionId() || Arrays.equals(iParametricTransitionTriple.getSource(), iGeneratingFunction.getRepresentativeSource()) || Arrays.equals(iParametricTransitionTriple.getTarget(), iGeneratingFunction.getRepresentativeTarget())) continue;
                foundSameJump = true;
                break;
            }
            if (foundSameJump) continue;
            GeneratingFunction generatingFunction = new GeneratingFunction();
            generatingFunction.setActionId(actionId);
            generatingFunction.setJump(jump);
            generatingFunction.setRepresentativeSource(iParametricTransitionTriple.getSource());
            generatingFunction.setRepresentativeTarget(iParametricTransitionTriple.getTarget());
            generatingFunction.setRate(iParametricTransitionTriple.getRate());
            this.generatingFunctions.add(generatingFunction);
        }
    }

    private short[] buildJump(short[] source, short[] target) {
        short[] jump = new short[this.explorer.getProblemSize()];
        Arrays.fill(jump, (short)0);
        int i = 0;
        while (i < source.length) {
            ParametricComponent c = this.explorer.getSequentialComponents()[i];
            int n = c.getCoordinate(source[i]);
            jump[n] = (short)(jump[n] - 1);
            int n2 = c.getCoordinate(target[i]);
            jump[n2] = (short)(jump[n2] + 1);
            ++i;
        }
        return jump;
    }

    private DifferentialAnalysisException createException(State state, String message) {
        StringBuffer buf = new StringBuffer();
        buf.append(String.valueOf(message) + " State number: ");
        buf.append(String.valueOf(state.stateNumber) + ". ");
        buf.append("State: ");
        int i = 0;
        while (i < state.fState.length) {
            buf.append(this.generator.getProcessLabel(state.fState[i]));
            if (i != state.fState.length - 1) {
                buf.append(",");
            }
            ++i;
        }
        return new DifferentialAnalysisException(buf.toString());
    }
}

