/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.largescale;

import uk.ac.ed.inf.pepa.largescale.IGeneratingFunction;
import uk.ac.ed.inf.pepa.largescale.IParametricDerivationGraph;
import uk.ac.ed.inf.pepa.largescale.IPointEstimator;
import uk.ac.ed.inf.pepa.largescale.expressions.EvaluatorVisitor;
import uk.ac.ed.inf.pepa.ode.DifferentialAnalysisException;

public class ThroughputCalculation
implements IPointEstimator {
    private short actionId;
    private IParametricDerivationGraph derivationGraph;

    public ThroughputCalculation(short actionId, IParametricDerivationGraph derivationGraph) {
        if (actionId < 0) {
            throw new IllegalArgumentException("Action id not valid");
        }
        this.actionId = actionId;
        this.derivationGraph = derivationGraph;
    }

    public double computeEstimate(double timePoint, double[] solution) throws DifferentialAnalysisException {
        double currentThroughput = 0.0;
        IGeneratingFunction[] iGeneratingFunctionArray = this.derivationGraph.getGeneratingFunctions();
        int n = iGeneratingFunctionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IGeneratingFunction f = iGeneratingFunctionArray[n2];
            if (f.getActionId() == this.actionId) {
                currentThroughput += new EvaluatorVisitor(f.getRate(), solution).getResult();
            }
            ++n2;
        }
        return currentThroughput;
    }

    public short getActionId() {
        return this.actionId;
    }
}

