/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.largescale.expressions;

import uk.ac.ed.inf.pepa.largescale.expressions.Coordinate;
import uk.ac.ed.inf.pepa.largescale.expressions.DivisionExpression;
import uk.ac.ed.inf.pepa.largescale.expressions.Expression;
import uk.ac.ed.inf.pepa.largescale.expressions.ExpressionVisitor;
import uk.ac.ed.inf.pepa.largescale.expressions.MinimumExpression;
import uk.ac.ed.inf.pepa.largescale.expressions.MultiplicationExpression;
import uk.ac.ed.inf.pepa.largescale.expressions.RateExpression;
import uk.ac.ed.inf.pepa.largescale.expressions.SubtractionExpression;
import uk.ac.ed.inf.pepa.largescale.expressions.SummationExpression;
import uk.ac.ed.inf.pepa.ode.DifferentialAnalysisException;

public class EvaluatorVisitor
implements ExpressionVisitor {
    private double[] state;
    private double result = 0.0;

    public EvaluatorVisitor(Expression expression, double[] currentState) throws DifferentialAnalysisException {
        if (expression == null) {
            throw new NullPointerException("Exception cannot be null");
        }
        if (currentState == null) {
            throw new NullPointerException("State cannot be null");
        }
        if (currentState.length == 0) {
            throw new IllegalArgumentException("State must have at least one coordinate");
        }
        this.state = currentState;
        expression.accept(this);
    }

    public EvaluatorVisitor() {
    }

    public double getResult(Expression expression, double[] state) throws DifferentialAnalysisException {
        this.state = state;
        expression.accept(this);
        return this.result;
    }

    public double getResult() {
        return this.result;
    }

    public void visitCoordinate(Coordinate coordinate) throws DifferentialAnalysisException {
        int index = coordinate.getCoordinate();
        if (this.state.length < index + 1) {
            throw new DifferentialAnalysisException("Cannot accept state to evaluate. Too short.");
        }
        this.result = this.state[index];
    }

    public void visitDivisionExpression(DivisionExpression div) throws DifferentialAnalysisException {
        div.getLhs().accept(this);
        double lhs = this.result;
        div.getRhs().accept(this);
        double rhs = this.result;
        this.result = lhs == 0.0 && rhs == 0.0 ? 1.0 : lhs / rhs;
    }

    public void visitMinimumExpression(MinimumExpression min) throws DifferentialAnalysisException {
        min.getLhs().accept(this);
        double lhs = this.result;
        min.getRhs().accept(this);
        this.result = Math.min(this.result, lhs);
    }

    public void visitMultiplicationExpression(MultiplicationExpression mult) throws DifferentialAnalysisException {
        mult.getLhs().accept(this);
        double lhs = this.result;
        mult.getRhs().accept(this);
        this.result *= lhs;
    }

    public void visitRateExpression(RateExpression rate) throws DifferentialAnalysisException {
        this.result = rate.getRate();
    }

    public void visitSummationExpression(SummationExpression sum) throws DifferentialAnalysisException {
        sum.getLhs().accept(this);
        double lhs = this.result;
        sum.getRhs().accept(this);
        this.result += lhs;
    }

    public void visitSubtractionExpression(SubtractionExpression subtractionExpression) {
        throw new IllegalStateException();
    }
}

