/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.largescale.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.SequentialComponentData;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.ShortArray;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.Transition;
import uk.ac.ed.inf.pepa.largescale.ISequentialComponent;
import uk.ac.ed.inf.pepa.largescale.expressions.Coordinate;
import uk.ac.ed.inf.pepa.largescale.expressions.Expression;
import uk.ac.ed.inf.pepa.largescale.expressions.MultiplicationExpression;
import uk.ac.ed.inf.pepa.largescale.expressions.RateExpression;
import uk.ac.ed.inf.pepa.largescale.expressions.SummationExpression;
import uk.ac.ed.inf.pepa.largescale.internal.ParametricStateExplorer;
import uk.ac.ed.inf.pepa.largescale.internal.ParametricStructuralElement;
import uk.ac.ed.inf.pepa.largescale.internal.ParametricTransition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParametricComponent
extends ParametricStructuralElement
implements ISequentialComponent {
    private HashMap<Short, ArrayList<ParametricTransition>> allDerivatives = new HashMap();
    private HashMap<Short, Coordinate> coordinateMap = new HashMap();
    private String name;
    private int initialPopulationLevel;
    private short[] actionAlphabet;

    public ParametricComponent(String name, int initialPopulationLevel, int offset, int length) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (initialPopulationLevel <= 0) {
            throw new IllegalArgumentException("Population level must be positive");
        }
        this.name = name;
        this.initialPopulationLevel = initialPopulationLevel;
        this.setOffset(offset);
        this.setLength(length);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public short[] getActionAlphabet() {
        if (this.actionAlphabet == null) {
            ShortArray sa = new ShortArray(this.apparentRates.size());
            for (Map.Entry ar : this.apparentRates.entrySet()) {
                sa.add((Short)ar.getKey());
            }
            this.actionAlphabet = sa.toArray();
        }
        return this.actionAlphabet;
    }

    @Override
    public int getInitialPopulationLevel() {
        return this.initialPopulationLevel;
    }

    @Override
    public Set<Map.Entry<Short, Coordinate>> getComponentMapping() {
        return this.coordinateMap.entrySet();
    }

    public String toString() {
        return "ODE Component:" + this.name + "[" + this.initialPopulationLevel + "]" + "(offset:" + this.getOffset() + ")" + " (length: " + this.getLength() + ")";
    }

    public int getCoordinate(short processId) {
        return this.coordinateMap.get(processId).getCoordinate();
    }

    @Override
    public void init(ParametricStateExplorer parametricStateExplorer) {
        super.init(parametricStateExplorer);
    }

    @Override
    public void compose(short[] state) {
        this.derivatives = this.allDerivatives.get(state[this.getOffset()]);
    }

    public int setupCoordinateIndexes(int coordinateIndex) {
        this.debug("Accepting index:" + coordinateIndex);
        if (!this.derivatives.isEmpty()) {
            throw new IllegalStateException("Derivatives must be empty now!");
        }
        if (!this.apparentRates.isEmpty()) {
            throw new IllegalStateException("Apparent rates must be empty now!");
        }
        ParametricStateExplorer stateExplorer = this.getStateExplorer();
        short initialLocalState = stateExplorer.initialVector[this.getOffset()];
        Coordinate coordinate = new Coordinate(coordinateIndex++);
        this.allDerivatives.put(initialLocalState, new ArrayList());
        this.coordinateMap.put(initialLocalState, coordinate);
        Stack<Short> unexploredProcesses = new Stack<Short>();
        unexploredProcesses.add(initialLocalState);
        while (!unexploredProcesses.isEmpty()) {
            short s = (Short)unexploredProcesses.pop();
            SequentialComponentData data = stateExplorer.getData(s);
            for (Transition transition : data.fFirstStepDerivative) {
                short targetProcess = transition.fTargetProcess[0];
                Coordinate targetCoordinate = this.coordinateMap.get(targetProcess);
                if (targetCoordinate == null) {
                    targetCoordinate = new Coordinate(coordinateIndex++);
                    this.coordinateMap.put(targetProcess, targetCoordinate);
                    unexploredProcesses.push(targetProcess);
                    this.allDerivatives.put(targetProcess, new ArrayList());
                }
                ParametricTransition pt = new ParametricTransition();
                pt.setTarget(transition.fTargetProcess);
                MultiplicationExpression parametricRate = new MultiplicationExpression(new RateExpression(transition.fRate), this.coordinateMap.get(s));
                pt.setParametricRate(parametricRate);
                if (this.hidingSet.get(transition.fActionId)) {
                    pt.setActionId((short)-1);
                } else {
                    pt.setActionId(transition.fActionId);
                    Expression apparentRate = (Expression)this.apparentRates.get(transition.fActionId);
                    apparentRate = apparentRate != null ? new SummationExpression(apparentRate, parametricRate) : parametricRate;
                    this.apparentRates.put(transition.fActionId, apparentRate);
                }
                this.allDerivatives.get(s).add(pt);
            }
        }
        this.debug("Component: " + this);
        this.debug("Transitions");
        for (Map.Entry<Short, ArrayList<ParametricTransition>> entry : this.allDerivatives.entrySet()) {
            this.debug("Derivatives for " + this.coordinateMap.get(entry.getKey()));
            for (ParametricTransition parametricTransition : entry.getValue()) {
                this.debug(parametricTransition.toString());
            }
        }
        this.debug("Apparent rates");
        for (Map.Entry<Short, ArrayList<ParametricTransition>> entry : this.apparentRates.entrySet()) {
            this.debug(entry.getKey() + ": " + entry.getValue());
        }
        return coordinateIndex;
    }

    private void debug(String s) {
    }
}

