/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.largescale.internal;

import java.util.BitSet;
import uk.ac.ed.inf.pepa.largescale.IParametricStructuralElement;
import uk.ac.ed.inf.pepa.largescale.expressions.DivisionExpression;
import uk.ac.ed.inf.pepa.largescale.expressions.Expression;
import uk.ac.ed.inf.pepa.largescale.expressions.MinimumExpression;
import uk.ac.ed.inf.pepa.largescale.expressions.MultiplicationExpression;
import uk.ac.ed.inf.pepa.largescale.expressions.SummationExpression;
import uk.ac.ed.inf.pepa.largescale.internal.ParametricStructuralElement;
import uk.ac.ed.inf.pepa.largescale.internal.ParametricTransition;

public class ParametricOperator
extends ParametricStructuralElement {
    private BitSet actionSet;
    private IParametricStructuralElement lhs;
    private IParametricStructuralElement rhs;

    public IParametricStructuralElement getLeftChild() {
        return this.lhs;
    }

    public IParametricStructuralElement getRightChild() {
        return this.rhs;
    }

    public void setCooperationSet(BitSet bitSet) {
        if (bitSet == null) {
            throw new NullPointerException();
        }
        this.actionSet = bitSet;
    }

    public void setLeftChild(IParametricStructuralElement lhs) {
        this.lhs = lhs;
        this.updateOffsetAndLength();
    }

    public void setRightChild(IParametricStructuralElement rhs) {
        this.rhs = rhs;
        this.updateOffsetAndLength();
    }

    private void updateOffsetAndLength() {
        if (this.lhs != null) {
            this.setOffset(this.lhs.getOffset());
            if (this.rhs != null) {
                this.setLength(this.lhs.getLength() + this.rhs.getLength());
            }
        }
    }

    public String toString() {
        return "ODE operator:\n left:" + this.lhs.toString() + " right: " + this.rhs.toString();
    }

    public void compose(short[] state) {
        this.apparentRates.clear();
        this.derivatives.clear();
        ParametricTransition[] parametricTransitionArray = this.lhs.getDerivatives();
        int n = parametricTransitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ParametricTransition leftEntry = parametricTransitionArray[n2];
            if (leftEntry.getActionId() == -1 || !this.actionSet.get(leftEntry.getActionId())) {
                this.createLeftOnlyTransition(state, leftEntry);
            } else {
                ParametricTransition[] parametricTransitionArray2 = this.rhs.getDerivatives();
                int n3 = parametricTransitionArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    ParametricTransition rightEntry = parametricTransitionArray2[n4];
                    if (rightEntry.getActionId() == leftEntry.getActionId()) {
                        this.createSharedTransition(state, leftEntry, rightEntry);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        parametricTransitionArray = this.rhs.getDerivatives();
        n = parametricTransitionArray.length;
        n2 = 0;
        while (n2 < n) {
            ParametricTransition rightEntry = parametricTransitionArray[n2];
            if (rightEntry.getActionId() == -1 || !this.actionSet.get(rightEntry.getActionId())) {
                this.createRightOnlyTransition(state, rightEntry);
            }
            ++n2;
        }
    }

    private void createLeftOnlyTransition(short[] state, ParametricTransition leftEntry) {
        ParametricTransition t = ParametricTransition.create(state, this.rhs.getOffset(), this.rhs.getLength(), this.checkAction(leftEntry.getActionId()), leftEntry.getParametricRate());
        short[] targetProcess = t.getTarget();
        int i = 0;
        while (i < this.lhs.getLength()) {
            targetProcess[this.lhs.getOffset() + i] = leftEntry.getTarget()[this.lhs.getOffset() + i];
            ++i;
        }
        Expression left = this.lhs.getApparentRate(t.getActionId());
        if (left == null && t.getActionId() != -1) {
            throw new IllegalStateException("There must be an apparent rate!");
        }
        Expression right = this.rhs.getApparentRate(t.getActionId());
        if (right == null) {
            this.update(t, left);
        } else {
            this.update(t, new SummationExpression(left, right));
        }
    }

    private void createRightOnlyTransition(short[] state, ParametricTransition rightEntry) {
        ParametricTransition t = ParametricTransition.create(state, this.lhs.getOffset(), this.lhs.getLength(), this.checkAction(rightEntry.getActionId()), rightEntry.getParametricRate());
        short[] targetProcess = t.getTarget();
        int i = 0;
        while (i < this.rhs.getLength()) {
            targetProcess[this.rhs.getOffset() + i] = rightEntry.getTarget()[this.rhs.getOffset() + i];
            ++i;
        }
        Expression left = this.lhs.getApparentRate(t.getActionId());
        Expression right = this.rhs.getApparentRate(t.getActionId());
        if (right == null && t.getActionId() != -1) {
            throw new IllegalStateException("There must be an apparent rate!");
        }
        if (left == null) {
            this.update(t, right);
        } else {
            this.update(t, new SummationExpression(left, right));
        }
    }

    private void createSharedTransition(short[] state, ParametricTransition leftEntry, ParametricTransition rightEntry) {
        short sharedActionId = leftEntry.getActionId();
        Expression apparentRateLeft = this.lhs.getApparentRate(sharedActionId);
        Expression apparentRateRight = this.rhs.getApparentRate(sharedActionId);
        MinimumExpression minApparentRates = new MinimumExpression(apparentRateLeft, apparentRateRight);
        DivisionExpression first = new DivisionExpression(leftEntry.getParametricRate(), apparentRateLeft);
        DivisionExpression second = new DivisionExpression(rightEntry.getParametricRate(), apparentRateRight);
        MultiplicationExpression temp = new MultiplicationExpression(first, second);
        MultiplicationExpression finalRate = new MultiplicationExpression(temp, minApparentRates);
        ParametricTransition t = ParametricTransition.create(state, 0, 0, this.checkAction(sharedActionId), finalRate);
        short[] newState = t.getTarget();
        int i = 0;
        while (i < this.lhs.getLength()) {
            newState[this.lhs.getOffset() + i] = leftEntry.getTarget()[this.lhs.getOffset() + i];
            ++i;
        }
        i = 0;
        while (i < this.rhs.getLength()) {
            newState[this.rhs.getOffset() + i] = rightEntry.getTarget()[this.rhs.getOffset() + i];
            ++i;
        }
        this.update(t, minApparentRates);
    }

    private final short checkAction(short action) {
        if (action == -1) {
            return action;
        }
        return this.hidingSet.get(action) ? (short)-1 : (short)action;
    }

    private final void update(ParametricTransition transition, Expression apparentRate) {
        this.derivatives.add(transition);
        if (transition.getActionId() != -1) {
            this.apparentRates.put(transition.getActionId(), apparentRate);
        }
    }
}

