/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.largescale.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.ISymbolGenerator;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.SequentialComponentData;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.Transition;
import uk.ac.ed.inf.pepa.ctmc.derivation.internal.HashMapSequentialComponentData;
import uk.ac.ed.inf.pepa.ctmc.derivation.internal.SymbolGenerator;
import uk.ac.ed.inf.pepa.largescale.IParametricStructuralElement;
import uk.ac.ed.inf.pepa.largescale.internal.ParametricComponent;
import uk.ac.ed.inf.pepa.largescale.internal.ParametricOperator;
import uk.ac.ed.inf.pepa.largescale.internal.ParametricStateExplorer;
import uk.ac.ed.inf.pepa.model.Action;
import uk.ac.ed.inf.pepa.model.ActionSet;
import uk.ac.ed.inf.pepa.model.Aggregation;
import uk.ac.ed.inf.pepa.model.Choice;
import uk.ac.ed.inf.pepa.model.Constant;
import uk.ac.ed.inf.pepa.model.Cooperation;
import uk.ac.ed.inf.pepa.model.FiniteRate;
import uk.ac.ed.inf.pepa.model.Hiding;
import uk.ac.ed.inf.pepa.model.Model;
import uk.ac.ed.inf.pepa.model.NamedAction;
import uk.ac.ed.inf.pepa.model.Prefix;
import uk.ac.ed.inf.pepa.model.Process;
import uk.ac.ed.inf.pepa.model.Rate;
import uk.ac.ed.inf.pepa.model.Visitor;
import uk.ac.ed.inf.pepa.ode.DifferentialAnalysisException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParametricStateExplorerBuilder {
    private Model model;
    private int offset = 0;
    private final HashMap<Short, Process> sequentialComponentsMap = new HashMap();
    private final HashMap<Short, NamedAction> actionMap = new HashMap();
    public final HashMap<Short, HashMapSequentialComponentData> sequentialComponentsData = new HashMap();
    private final ArrayList<ParametricOperator> operators = new ArrayList();
    private final ArrayList<List<Short>> cooperationSets = new ArrayList();
    private final HashMap<IParametricStructuralElement, List<Short>> hidingSets = new HashMap();
    private final LinkedList<ParametricComponent> sequentialComponents = new LinkedList();
    private final ParametricStateExplorer explorer = new ParametricStateExplorer();
    private short seqProcess = 0;
    private short seqAction = 0;
    private LinkedList<Short> initialState = new LinkedList();
    private short[] initialStateVector;

    /*
     * WARNING - void declaration
     */
    public ParametricStateExplorerBuilder(Model model) throws DifferentialAnalysisException {
        void var5_6;
        this.model = model;
        ComposerVisitor v = new ComposerVisitor();
        this.model.getSystemEquation().accept(v);
        this.initialStateVector = new short[this.initialState.size()];
        int i = 0;
        Iterator iterator = this.initialState.iterator();
        while (iterator.hasNext()) {
            short stateId = (Short)iterator.next();
            this.initialStateVector[i++] = stateId;
        }
        this.scan_two();
        short n = this.seqAction;
        boolean bl = false;
        while (var5_6 < this.operators.size()) {
            List<Short> cooperationSet = this.cooperationSets.get((int)var5_6);
            ParametricOperator operator = this.operators.get((int)var5_6);
            operator.setCooperationSet(this.createBitSet(cooperationSet, n));
            List<Short> hs = this.hidingSets.get(operator);
            if (hs != null) {
                operator.setHidingSet(this.createBitSet(hs, n));
            } else {
                operator.setHidingSet(this.createBitSet(new ArrayList<Short>(), n));
            }
            ++var5_6;
        }
        for (ParametricComponent parametricComponent : this.sequentialComponents) {
            List<Short> hs = this.hidingSets.get(parametricComponent);
            if (hs != null) {
                parametricComponent.setHidingSet(this.createBitSet(hs, n));
                continue;
            }
            parametricComponent.setHidingSet(this.createBitSet(new ArrayList<Short>(), n));
        }
        this.explorer.operators = this.operators.toArray(new ParametricOperator[this.operators.size()]);
        this.explorer.sequentialComponents = this.sequentialComponents.toArray(new ParametricComponent[this.sequentialComponents.size()]);
        this.explorer.sequentialComponentInfo = new SequentialComponentData[this.seqProcess];
        for (Map.Entry entry : this.sequentialComponentsData.entrySet()) {
            double[] apparentRates = new double[n];
            Arrays.fill(apparentRates, 0.0);
            HashMapSequentialComponentData value = (HashMapSequentialComponentData)entry.getValue();
            for (Map.Entry<Short, Double> apparentRateEntry : value.fApparentRates.entrySet()) {
                apparentRates[apparentRateEntry.getKey().shortValue()] = apparentRateEntry.getValue();
            }
            SequentialComponentData data = new SequentialComponentData();
            data.fFirstStepDerivative = ((HashMapSequentialComponentData)entry.getValue()).fFirstStepDerivative;
            data.fArrayApparentRates = apparentRates;
            this.explorer.sequentialComponentInfo[((Short)entry.getKey()).shortValue()] = data;
        }
        this.explorer.initialVector = this.initialStateVector;
        this.explorer.init();
    }

    private BitSet createBitSet(List<Short> set, int n) {
        BitSet bitSet = new BitSet(n);
        for (short s : set) {
            bitSet.set(s);
        }
        return bitSet;
    }

    public ParametricStateExplorer getExplorer() {
        return this.explorer;
    }

    public ISymbolGenerator getSymbolGenerator() {
        return new SymbolGenerator(this.initialStateVector, this.sequentialComponentsMap, this.actionMap);
    }

    private short getIndex(NamedAction action) {
        for (Map.Entry<Short, NamedAction> entry : this.actionMap.entrySet()) {
            if (!action.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        this.actionMap.put(this.seqAction, action);
        short s = this.seqAction;
        this.seqAction = (short)(s + 1);
        return s;
    }

    public short getIndex(Process process) {
        Short id = this.basicGetIndex(process);
        if (id != null) {
            return id;
        }
        this.sequentialComponentsMap.put(this.seqProcess, process);
        short s = this.seqProcess;
        this.seqProcess = (short)(s + 1);
        return s;
    }

    private Short basicGetIndex(Process process) {
        for (Map.Entry<Short, Process> entry : this.sequentialComponentsMap.entrySet()) {
            if (!process.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    private void scan_two() throws DifferentialAnalysisException {
        boolean addedOnce;
        HashMap<Short, ArrayList<Short>> unguardedDefinitionMap = new HashMap<Short, ArrayList<Short>>();
        for (Constant constant : this.model.getProcessDefinitions()) {
            short index = this.getIndex(constant);
            unguardedDefinitionMap.put(index, new ArrayList());
            try {
                constant.getBinding().accept(new SequentialComponentVisitor(index, false, unguardedDefinitionMap));
            }
            catch (IllegalStateException e) {
                throw new DifferentialAnalysisException(e.getMessage());
            }
        }
        do {
            addedOnce = false;
            for (Map.Entry entry : unguardedDefinitionMap.entrySet()) {
                HashMapSequentialComponentData sourceData = this.sequentialComponentsData.get(entry.getKey());
                if (sourceData == null) {
                    sourceData = new HashMapSequentialComponentData();
                    this.sequentialComponentsData.put((Short)entry.getKey(), sourceData);
                }
                for (Short target : (ArrayList)entry.getValue()) {
                    HashMapSequentialComponentData targetData = this.sequentialComponentsData.get(target);
                    if (targetData == null) {
                        targetData = new HashMapSequentialComponentData();
                        this.sequentialComponentsData.put(target, targetData);
                    }
                    for (Transition transition : targetData.fFirstStepDerivative) {
                        if (sourceData.fFirstStepDerivative.contains(transition)) continue;
                        sourceData.fFirstStepDerivative.add(transition);
                        Double old = sourceData.fApparentRates.get(transition.fActionId);
                        if (old == null) {
                            old = 0.0;
                        }
                        double newRate = old + transition.fRate;
                        sourceData.fApparentRates.put(transition.fActionId, newRate);
                        addedOnce = true;
                    }
                }
            }
        } while (addedOnce);
    }

    private double convertRate(Rate r) throws DifferentialAnalysisException {
        if (r instanceof FiniteRate) {
            return ((FiniteRate)r).getValue();
        }
        throw new DifferentialAnalysisException("Passive rates are not currently supported.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ComposerVisitor
    implements Visitor {
        public IParametricStructuralElement lastVisited;

        private List<Short> createActionSetIdentifiers(ActionSet set) {
            LinkedList<Short> actionSet = new LinkedList<Short>();
            Iterator<Action> iter = set.iterator();
            while (iter.hasNext()) {
                actionSet.add(ParametricStateExplorerBuilder.this.getIndex((NamedAction)iter.next()));
            }
            return actionSet;
        }

        @Override
        public void visitAggregation(Aggregation aggregation) {
            Constant constant = (Constant)aggregation.getSubProcesses().keySet().iterator().next();
            this.addConstant(constant, aggregation.getCopies());
        }

        @Override
        public void visitChoice(Choice choice) {
            throw new IllegalStateException("Choice shouldn't be seen in the system equation");
        }

        @Override
        public void visitConstant(Constant constant) {
            this.addConstant(constant, 1);
        }

        private void addConstant(Constant constant, int copies) {
            String string = constant.getName();
            ParametricStateExplorerBuilder parametricStateExplorerBuilder = ParametricStateExplorerBuilder.this;
            int n = parametricStateExplorerBuilder.offset;
            parametricStateExplorerBuilder.offset = n + 1;
            ParametricComponent component = new ParametricComponent(string, copies, n, 1);
            ParametricStateExplorerBuilder.this.sequentialComponents.add(component);
            ParametricStateExplorerBuilder.this.initialState.add(ParametricStateExplorerBuilder.this.getIndex(constant));
            this.lastVisited = component;
        }

        @Override
        public void visitCooperation(Cooperation cooperation) {
            ParametricOperator operator = new ParametricOperator();
            ParametricStateExplorerBuilder.this.operators.add(operator);
            List<Short> list = this.createActionSetIdentifiers(cooperation.getActionSet());
            ParametricStateExplorerBuilder.this.cooperationSets.add(list);
            ComposerVisitor leftVisitor = new ComposerVisitor();
            cooperation.getLeftHandSide().accept(leftVisitor);
            ComposerVisitor rightVisitor = new ComposerVisitor();
            cooperation.getRightHandSide().accept(rightVisitor);
            operator.setLeftChild(leftVisitor.lastVisited);
            operator.setRightChild(rightVisitor.lastVisited);
            this.lastVisited = operator;
        }

        @Override
        public void visitHiding(Hiding hiding) {
            hiding.getHiddenProcess().accept(this);
            ParametricStateExplorerBuilder.this.hidingSets.put(this.lastVisited, this.createActionSetIdentifiers(hiding.getActionSet()));
        }

        @Override
        public void visitPrefix(Prefix prefix) {
            throw new IllegalStateException("Prefix shouldn't be seen in the system equation");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SequentialComponentVisitor
    implements Visitor {
        short fSourceId;
        boolean fGuardedDefinition;
        HashMap<Short, ArrayList<Short>> fUnguardedDefinitionMap;

        public SequentialComponentVisitor(short sourceId, boolean guardedDefinition, HashMap<Short, ArrayList<Short>> unguardedDefinitionMap) {
            this.fSourceId = sourceId;
            this.fGuardedDefinition = guardedDefinition;
            this.fUnguardedDefinitionMap = unguardedDefinitionMap;
        }

        @Override
        public void visitAggregation(Aggregation aggregation) {
            throw new IllegalStateException("Aggregation " + aggregation.prettyPrint() + " should" + "not be found in sequential component definition");
        }

        @Override
        public void visitChoice(Choice choice) {
            choice.getLeftHandSide().accept(this);
            choice.getRightHandSide().accept(this);
        }

        @Override
        public void visitConstant(Constant constant) {
            if (!this.fGuardedDefinition) {
                short targetId = ParametricStateExplorerBuilder.this.getIndex(constant);
                this.fUnguardedDefinitionMap.get(this.fSourceId).add(targetId);
            }
        }

        @Override
        public void visitCooperation(Cooperation cooperation) {
            throw new IllegalStateException("Cooperation " + cooperation.prettyPrint() + " should" + "not be found in sequential component definition");
        }

        @Override
        public void visitHiding(Hiding hiding) {
            throw new IllegalStateException("Hiding " + hiding.prettyPrint() + " should" + "not be found in sequential component definition");
        }

        @Override
        public void visitPrefix(Prefix prefix) {
            short actionId;
            double rate;
            HashMapSequentialComponentData data = ParametricStateExplorerBuilder.this.sequentialComponentsData.get(this.fSourceId);
            if (data == null) {
                data = new HashMapSequentialComponentData();
                ParametricStateExplorerBuilder.this.sequentialComponentsData.put(this.fSourceId, data);
            }
            Action action = prefix.getActivity().getAction();
            try {
                rate = ParametricStateExplorerBuilder.this.convertRate(prefix.getActivity().getRate());
            }
            catch (DifferentialAnalysisException e) {
                throw new IllegalStateException(e);
            }
            if (action instanceof NamedAction) {
                actionId = ParametricStateExplorerBuilder.this.getIndex((NamedAction)action);
                double oldValue = data.fApparentRates.containsKey(actionId) ? data.fApparentRates.get(actionId) : 0.0;
                double newValue = oldValue + rate;
                data.fApparentRates.put(actionId, newValue);
            } else {
                actionId = -1;
            }
            Process target = prefix.getTargetProcess();
            Transition transition = new Transition();
            short targetProcessId = ParametricStateExplorerBuilder.this.getIndex(target);
            transition.fTargetProcess = new short[ParametricStateExplorerBuilder.this.initialStateVector.length];
            Arrays.fill(transition.fTargetProcess, targetProcessId);
            transition.fActionId = actionId;
            transition.fRate = rate;
            data.fFirstStepDerivative.add(transition);
            HashMapSequentialComponentData targetData = ParametricStateExplorerBuilder.this.sequentialComponentsData.get(targetProcessId);
            if (targetData == null) {
                target.accept(new SequentialComponentVisitor(targetProcessId, true, this.fUnguardedDefinitionMap));
            }
        }
    }
}

