/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.largescale.simulation;

import fern.network.Network;
import fern.simulation.Simulator;
import fern.simulation.algorithm.GibsonBruckSimulator;
import fern.simulation.algorithm.GillespieEnhanced;
import uk.ac.ed.inf.pepa.IProgressMonitor;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.largescale.IParametricDerivationGraph;
import uk.ac.ed.inf.pepa.largescale.IPointEstimator;
import uk.ac.ed.inf.pepa.largescale.simulation.IStatisticsCollector;
import uk.ac.ed.inf.pepa.largescale.simulation.PEPANetwork;
import uk.ac.ed.inf.pepa.largescale.simulation.SimulationException;
import umontreal.iro.lecuyer.stat.TallyStore;

public abstract class AbstractStochasticSimulation {
    protected static final int MINIMUM_SAMPLE_SIZE_FOR_CONFIDENCE = 3;
    protected static final int MAX_ITERATIONS_CONVERGENCE = 0;
    protected static final int CONFIDENCE_LEVEL_CONVERGENCE = 1;
    protected double currentConfidenceError = Double.POSITIVE_INFINITY;
    protected double startTime;
    protected double stopTime;
    protected double timeInterval;
    protected int convergenceCriterion;
    protected double requiredConfidenceLevel;
    protected double requiredConfidenceError;
    protected int maxIterations;
    protected Simulator simulator;
    protected IPointEstimator[] estimators;
    protected IParametricDerivationGraph derivationGraph;
    protected IStatisticsCollector[] collectors;
    protected TallyStore[][] tallies;
    protected int timeStep;

    public AbstractStochasticSimulation(OptionMap map, IParametricDerivationGraph derivationGraph, IPointEstimator[] estimators, IStatisticsCollector[] collectors) {
        if (estimators == null || estimators.length == 0) {
            throw new IllegalArgumentException();
        }
        if (collectors == null || collectors.length == 0) {
            throw new IllegalArgumentException();
        }
        this.startTime = (Double)map.get("ssa.start-time");
        this.stopTime = (Double)map.get("ssa.stop-time");
        this.timeStep = (Integer)map.get("ssa.time-interval");
        this.timeInterval = (this.stopTime - this.startTime) / (double)(this.timeStep - 1);
        this.derivationGraph = derivationGraph;
        this.estimators = estimators;
        this.collectors = collectors;
        PEPANetwork network = new PEPANetwork(derivationGraph);
        String algorithm = (String)map.get("ssa.algorithm");
        this.simulator = null;
        if (algorithm.equals("ssa.algorithm.gibson-bruck")) {
            this.simulator = new GibsonBruckSimulator((Network)network);
        } else if (algorithm.equals("ssa.algorithm.gillespie")) {
            this.simulator = new GillespieEnhanced((Network)network);
        } else {
            throw new IllegalArgumentException();
        }
        this.requiredConfidenceLevel = (Double)map.get("ssa.convergence.confidence");
        this.maxIterations = (Integer)map.get("ssa.convergence.max-iterations");
        this.requiredConfidenceError = (Double)map.get("ssa.convergence.confidence-percent");
        this.convergenceCriterion = ((String)map.get("ssa.convergence")).equals("ssa.max-iterations") ? 0 : 1;
        this.tallies = new TallyStore[collectors.length][this.getNumberOfTimePoints()];
        int i = 0;
        while (i < collectors.length) {
            int j = 0;
            while (j < this.getNumberOfTimePoints()) {
                this.tallies[i][j] = new TallyStore("Collector " + i + "," + j);
                ++j;
            }
            ++i;
        }
    }

    public abstract int getNumberOfTimePoints();

    public void averagesAndRadii(int collectorIndex, double[] averages, double[] radii) {
        if (collectorIndex > this.collectors.length - 1) {
            throw new IllegalArgumentException();
        }
        if (averages.length != this.getNumberOfTimePoints()) {
            throw new IllegalArgumentException();
        }
        if (radii.length != this.getNumberOfTimePoints()) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < this.getNumberOfTimePoints()) {
            double[] result = new double[2];
            this.tallies[collectorIndex][i].confidenceIntervalStudent(this.requiredConfidenceLevel, result);
            averages[i] = result[0];
            radii[i] = result[1];
            ++i;
        }
    }

    public double[] getAverages(int collectorIndex) {
        if (collectorIndex > this.collectors.length - 1) {
            throw new IllegalArgumentException();
        }
        double[] result = new double[this.getNumberOfTimePoints()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.tallies[collectorIndex][i].average();
            ++i;
        }
        return result;
    }

    public void confidenceInterval(int collectorIndex, int timeIndex, double[] result) {
        this.tallies[collectorIndex][timeIndex].confidenceIntervalStudent(this.requiredConfidenceLevel, result);
    }

    public boolean canComputeConfidenceInterval() {
        return this.tallies[0][0].numberObs() >= 3;
    }

    public int getNumberOfObservers() {
        return this.collectors.length;
    }

    public double getRequiredConfidenceLevel() {
        return this.requiredConfidenceLevel;
    }

    public double getRequiredConfidenceError() {
        return this.requiredConfidenceError;
    }

    public double getCurrentConfidenceError() {
        return this.currentConfidenceError;
    }

    public abstract void doSimulation(IProgressMonitor var1) throws SimulationException, InterruptedException;
}

