/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.largescale.simulation;

import uk.ac.ed.inf.pepa.largescale.simulation.IStatisticsCollector;

public class AverageResponseTimeCollector
implements IStatisticsCollector {
    private int userIndex;
    private int throughputIndex;

    public AverageResponseTimeCollector(int userIndex, int throughputIndex) {
        if (userIndex < 0 || throughputIndex < 0) {
            throw new IllegalArgumentException();
        }
        this.userIndex = userIndex;
        this.throughputIndex = throughputIndex;
    }

    public double computeObservation(double[] estimates) {
        double w = estimates[this.userIndex] / estimates[this.throughputIndex];
        if (Double.isNaN(w)) {
            throw new IllegalStateException();
        }
        return w;
    }
}

