/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.largescale.simulation;

import fern.simulation.Simulator;
import fern.simulation.controller.SimulationController;
import fern.simulation.observer.Observer;
import fern.tools.Stochastics;
import java.io.IOException;
import java.util.Date;
import uk.ac.ed.inf.pepa.DoNothingMonitor;
import uk.ac.ed.inf.pepa.IProgressMonitor;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.largescale.IParametricDerivationGraph;
import uk.ac.ed.inf.pepa.largescale.IPointEstimator;
import uk.ac.ed.inf.pepa.largescale.ParametricDerivationGraphBuilder;
import uk.ac.ed.inf.pepa.largescale.simulation.AbstractStochasticSimulation;
import uk.ac.ed.inf.pepa.largescale.simulation.DefaultCollector;
import uk.ac.ed.inf.pepa.largescale.simulation.DefaultConvergenceChecker;
import uk.ac.ed.inf.pepa.largescale.simulation.IConvergenceChecker;
import uk.ac.ed.inf.pepa.largescale.simulation.IStatisticsCollector;
import uk.ac.ed.inf.pepa.largescale.simulation.SimulationException;
import uk.ac.ed.inf.pepa.ode.DifferentialAnalysisException;
import uk.ac.ed.inf.pepa.parsing.ModelNode;
import uk.ac.ed.inf.pepa.tools.PepaTools;
import umontreal.iro.lecuyer.stat.Tally;

public class SteadyStateSimulation
extends AbstractStochasticSimulation {
    private IConvergenceChecker convergenceChecker = new DefaultConvergenceChecker();
    private int batchLengthFactor;

    public static void main(String[] args) throws IOException, DifferentialAnalysisException, InterruptedException, SimulationException {
        ModelNode model = (ModelNode)PepaTools.parse(PepaTools.readText(args[0]));
        IParametricDerivationGraph derivationGraph = ParametricDerivationGraphBuilder.createDerivationGraph(model, null);
        OptionMap map = new OptionMap();
        map.put("ssa.stop-time", 5.0);
        IPointEstimator[] estimators = new IPointEstimator[]{new IPointEstimator(){

            public double computeEstimate(double timePoint, double[] solution) throws DifferentialAnalysisException {
                return solution[0];
            }
        }};
        IStatisticsCollector[] collectors = DefaultCollector.create(estimators);
        SteadyStateSimulation simulation = new SteadyStateSimulation(map, derivationGraph, estimators, collectors);
        simulation.doSimulation(new IProgressMonitor(){
            private int batches = 0;

            public void beginTask(int amount) {
                System.out.println("Simulation started: " + amount);
            }

            public void done() {
                System.out.println("Simulation completed");
            }

            public boolean isCanceled() {
                return false;
            }

            public void setCanceled(boolean state) {
            }

            public void worked(int worked) {
                ++this.batches;
                if (this.batches == 1) {
                    System.out.println("Transient removed");
                } else if (this.batches > 3) {
                    double[] result = new double[2];
                    SteadyStateSimulation.this.confidenceInterval(0, 0, result);
                    System.out.printf("%3d : %9.6f (%9.6f)\n", this.batches, result[0], result[1]);
                }
            }
        });
        double[] results = new double[2];
        simulation.confidenceInterval(0, 0, results);
        System.out.println("Average: " + results[0]);
        System.out.println("Ci: " + results[1]);
    }

    public SteadyStateSimulation(OptionMap map, IParametricDerivationGraph derivationGraph, IPointEstimator[] estimators, IStatisticsCollector[] collectors) {
        super(map, derivationGraph, estimators, collectors);
        this.batchLengthFactor = (Integer)map.get("ssa.batch-length-factor");
    }

    public double computeLagOneAutoCorrelation(int collectorIndex) {
        double[] allValues = new double[this.tallies[collectorIndex][0].numberObs()];
        System.arraycopy(this.tallies[collectorIndex][0].getArray(), 0, allValues, 0, allValues.length);
        double avg = this.tallies[collectorIndex][0].average();
        double num = 0.0;
        double den = 0.0;
        int j = 0;
        while (j < allValues.length - 2) {
            num += (allValues[j] - avg) * (allValues[j + 1] - avg);
            den += Math.pow(allValues[j] - avg, 2.0);
            ++j;
        }
        return num / (den += Math.pow(allValues[allValues.length - 1], 2.0));
    }

    public void doSimulation(IProgressMonitor monitor) throws SimulationException, InterruptedException {
        if (monitor == null) {
            monitor = new DoNothingMonitor();
        }
        SteadyStateController controller = new SteadyStateController();
        this.simulator.addObserver(this.getObserver(controller, monitor));
        Stochastics.getInstance().setSeed(new Date());
        this.simulator.start((SimulationController)controller);
        if (monitor.isCanceled()) {
            throw new InterruptedException("Simulation was cancelled");
        }
    }

    private Observer getObserver(final SteadyStateController controller, final IProgressMonitor monitor) {
        final double batchLength = (double)this.batchLengthFactor * this.stopTime;
        Observer batchMeansObserver = new Observer(this.simulator){
            private Tally[] accumulators;
            private boolean collecting;
            private int currentBatch;
            private double lastEvent;
            private double[] solutionBeforeEvent;
            {
                super($anonymous0);
                this.collecting = false;
                this.solutionBeforeEvent = new double[SteadyStateSimulation.this.derivationGraph.getInitialState().length];
            }

            public void activateReaction(int mu, double tau, Simulator.FireType fireType, int times) {
            }

            public void finished() {
                monitor.done();
            }

            public void started() {
                this.currentBatch = 0;
                this.lastEvent = 0.0;
                this.updateSolutionBeforeEvent();
                monitor.beginTask(-1);
                this.setTheta(SteadyStateSimulation.this.stopTime);
            }

            public void step() {
                if (monitor.isCanceled()) {
                    controller.setGoOn(false);
                    return;
                }
                if (!this.collecting) {
                    return;
                }
                this.updateAccumulators(SteadyStateSimulation.this.simulator.getTime());
            }

            private void updateAccumulators(double newTime) {
                int i = 0;
                while (i < SteadyStateSimulation.this.estimators.length) {
                    try {
                        double currentResult = SteadyStateSimulation.this.estimators[i].computeEstimate(newTime, this.solutionBeforeEvent);
                        this.accumulators[i].add(currentResult * (newTime - this.lastEvent));
                    }
                    catch (DifferentialAnalysisException e) {
                        throw new IllegalStateException(e);
                    }
                    ++i;
                }
                this.updateSolutionBeforeEvent();
                this.lastEvent = newTime;
            }

            private void updateSolutionBeforeEvent() {
                int i = 0;
                while (i < this.solutionBeforeEvent.length) {
                    this.solutionBeforeEvent[i] = SteadyStateSimulation.this.simulator.getAmount(i);
                    ++i;
                }
            }

            public void theta(double theta) {
                if (this.collecting) {
                    this.updateAccumulators(theta);
                    double[] estimates = new double[SteadyStateSimulation.this.estimators.length];
                    int i = 0;
                    while (i < SteadyStateSimulation.this.estimators.length) {
                        estimates[i] = this.accumulators[i].sum() / batchLength;
                        ++i;
                    }
                    i = 0;
                    while (i < SteadyStateSimulation.this.collectors.length) {
                        SteadyStateSimulation.this.tallies[i][0].add(SteadyStateSimulation.this.collectors[i].computeObservation(estimates));
                        ++i;
                    }
                } else {
                    this.updateSolutionBeforeEvent();
                    this.lastEvent = theta;
                }
                ++this.currentBatch;
                if (this.currentBatch >= 3 && this.checkConvergenceAndSetController()) {
                    return;
                }
                monitor.worked(1);
                this.collecting = true;
                this.accumulators = new Tally[SteadyStateSimulation.this.estimators.length];
                int i = 0;
                while (i < SteadyStateSimulation.this.estimators.length) {
                    this.accumulators[i] = new Tally("Estimator " + i + "," + this.currentBatch);
                    ++i;
                }
                this.setTheta(theta + batchLength);
            }

            private boolean checkConvergenceAndSetController() {
                double currentError;
                SteadyStateSimulation.this.currentConfidenceError = currentError = SteadyStateSimulation.this.convergenceChecker.computeConvergenceError(SteadyStateSimulation.this);
                boolean hasConverged = currentError < SteadyStateSimulation.this.requiredConfidenceError;
                controller.setGoOn(!hasConverged);
                return hasConverged;
            }
        };
        return batchMeansObserver;
    }

    public int getNumberOfTimePoints() {
        return 1;
    }

    private class SteadyStateController
    implements SimulationController {
        private boolean goOn = true;

        private SteadyStateController() {
        }

        public void setGoOn(boolean goOn) {
            this.goOn = goOn;
        }

        public boolean goOn(Simulator sim) {
            return this.goOn;
        }
    }
}

