/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.model;

import java.util.Map;
import org.apache.log4j.Logger;
import uk.ac.ed.inf.pepa.model.Action;
import uk.ac.ed.inf.pepa.model.Aggregation;
import uk.ac.ed.inf.pepa.model.Choice;
import uk.ac.ed.inf.pepa.model.Constant;
import uk.ac.ed.inf.pepa.model.Cooperation;
import uk.ac.ed.inf.pepa.model.FiniteRate;
import uk.ac.ed.inf.pepa.model.Hiding;
import uk.ac.ed.inf.pepa.model.PassiveRate;
import uk.ac.ed.inf.pepa.model.Prefix;
import uk.ac.ed.inf.pepa.model.Process;
import uk.ac.ed.inf.pepa.model.Rate;
import uk.ac.ed.inf.pepa.model.internal.DoMakePepaProcess;

public class RateMath {
    private static Logger logger = Logger.getLogger(RateMath.class);
    public static int RATE_MATH_COUNT = 0;

    public static Rate getApparentRate(Process process, Action action) {
        if (process instanceof Constant) {
            return RateMath.getApparentRate(((Constant)process).getBinding(), action);
        }
        if (process instanceof Prefix) {
            if (action.equals(((Prefix)process).getActivity().getAction())) {
                return ((Prefix)process).getActivity().getRate();
            }
            return DoMakePepaProcess.getInstance().createFiniteRate(0.0);
        }
        if (process instanceof Choice) {
            return RateMath.sum(RateMath.getApparentRate(((Choice)process).getLeftHandSide(), action), RateMath.getApparentRate(((Choice)process).getRightHandSide(), action));
        }
        if (process instanceof Hiding) {
            if (!((Hiding)process).getActionSet().contains(action)) {
                return RateMath.getApparentRate(((Hiding)process).getHiddenProcess(), action);
            }
            return DoMakePepaProcess.getInstance().createFiniteRate(0.0);
        }
        if (process instanceof Cooperation) {
            Cooperation coop = (Cooperation)process;
            if (coop.getActionSet().contains(action)) {
                return RateMath.min(RateMath.getApparentRate(coop.getLeftHandSide(), action), RateMath.getApparentRate(coop.getRightHandSide(), action));
            }
            return RateMath.sum(RateMath.getApparentRate(coop.getLeftHandSide(), action), RateMath.getApparentRate(coop.getRightHandSide(), action));
        }
        if (process instanceof Aggregation) {
            Aggregation aggregation = (Aggregation)process;
            Rate newRate = null;
            for (Map.Entry<Process, Integer> entry : aggregation.getSubProcesses().entrySet()) {
                Process singleProcess = entry.getKey();
                Rate entryRate = RateMath.getApparentRate(singleProcess, action);
                entryRate = RateMath.mult(entryRate, entry.getValue());
                newRate = newRate == null ? entryRate : RateMath.sum(newRate, entryRate);
            }
            return newRate;
        }
        throw new IllegalArgumentException();
    }

    public static Rate sum(Rate r1, Rate r2) {
        if (r1 instanceof PassiveRate) {
            if (r2 instanceof PassiveRate) {
                return DoMakePepaProcess.getInstance().createPassiveRate(((PassiveRate)r1).getWeight() + ((PassiveRate)r2).getWeight());
            }
            if (((FiniteRate)r2).getValue() == 0.0) {
                return r1;
            }
        }
        if (r1 instanceof FiniteRate) {
            if (r2 instanceof FiniteRate) {
                return DoMakePepaProcess.getInstance().createFiniteRate(((FiniteRate)r1).getValue() + ((FiniteRate)r2).getValue());
            }
            if (((FiniteRate)r1).getValue() == 0.0) {
                return r2;
            }
        }
        throw new UnsupportedOperationException("Sum must be between rates of the same type!");
    }

    public static FiniteRate minus(Rate r1, Rate r2) {
        if (r1 instanceof FiniteRate && r2 instanceof FiniteRate) {
            return DoMakePepaProcess.getInstance().createFiniteRate(((FiniteRate)r1).getValue() - ((FiniteRate)r2).getValue());
        }
        throw new UnsupportedOperationException("Only finite rates accepted");
    }

    public static Rate mult(Rate r1, Rate r2) {
        if (r1 instanceof FiniteRate && r2 instanceof FiniteRate) {
            return DoMakePepaProcess.getInstance().createFiniteRate(((FiniteRate)r1).getValue() * ((FiniteRate)r2).getValue());
        }
        if (r1 instanceof FiniteRate && r2 instanceof PassiveRate) {
            return DoMakePepaProcess.getInstance().createPassiveRate(((FiniteRate)r1).getValue());
        }
        logger.debug((Object)("R1 :" + r1.prettyPrint()));
        logger.debug((Object)("R2 :" + r2.prettyPrint()));
        throw new UnsupportedOperationException("Only finite rates accepted");
    }

    public static Rate min(Rate r1, Rate r2) {
        if (r1 instanceof FiniteRate) {
            if (r2 instanceof FiniteRate) {
                if (((FiniteRate)r1).getValue() <= ((FiniteRate)r2).getValue()) {
                    return r1;
                }
                return r2;
            }
            return r1;
        }
        if (r1 instanceof PassiveRate) {
            if (r2 instanceof PassiveRate) {
                if (((PassiveRate)r1).getWeight() <= ((PassiveRate)r2).getWeight()) {
                    return r1;
                }
                return r2;
            }
            return r2;
        }
        throw new UnsupportedOperationException("Trying to min(" + r1.getClass() + "," + r2.getClass() + ")");
    }

    public static Rate div(Rate r1, Rate r2) {
        if (r1 instanceof PassiveRate && r2 instanceof PassiveRate) {
            return DoMakePepaProcess.getInstance().createFiniteRate(((PassiveRate)r1).getWeight() / ((PassiveRate)r2).getWeight());
        }
        if (r1 instanceof FiniteRate && r2 instanceof FiniteRate) {
            return DoMakePepaProcess.getInstance().createFiniteRate(((FiniteRate)r1).getValue() / ((FiniteRate)r2).getValue());
        }
        throw new UnsupportedOperationException("Div must be between rates of the same type!");
    }

    public static Rate mult(Rate rate, int i) {
        if (rate instanceof PassiveRate) {
            return DoMakePepaProcess.getInstance().createPassiveRate(((PassiveRate)rate).getWeight() * (double)i);
        }
        if (rate instanceof FiniteRate) {
            return DoMakePepaProcess.getInstance().createFiniteRate(((FiniteRate)rate).getValue() * (double)i);
        }
        throw new UnsupportedOperationException("mult applied to " + rate);
    }
}

