/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.model.internal;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import uk.ac.ed.inf.pepa.model.Action;
import uk.ac.ed.inf.pepa.model.ActionSet;
import uk.ac.ed.inf.pepa.model.NamedAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionSetImpl
implements ActionSet {
    private Set<Action> actions = new LinkedHashSet<Action>();

    public boolean add(Action action) {
        if (action == null) {
            throw new NullPointerException();
        }
        return this.actions.add(action);
    }

    @Override
    public boolean contains(Action action) {
        return this.actions.contains(action);
    }

    @Override
    public Iterator<Action> iterator() {
        final Iterator<Action> iterator = this.actions.iterator();
        return new Iterator<Action>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Action next() {
                return (Action)iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return this.actions.size();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActionSet)) {
            return false;
        }
        ActionSet actionSet = (ActionSet)o;
        boolean error = false;
        Iterator<Action> iter = this.actions.iterator();
        Action action = null;
        while (iter.hasNext()) {
            action = iter.next();
            if (actionSet.contains(action)) continue;
            error = true;
            break;
        }
        return !error;
    }

    public int hashCode() {
        Iterator<Action> iter = this.actions.iterator();
        int hash = 0;
        while (iter.hasNext()) {
            hash += iter.next().hashCode();
        }
        return hash;
    }

    @Override
    public String prettyPrint() {
        StringBuffer set = new StringBuffer();
        set.append("<");
        for (Action action : this.actions) {
            set.append(((NamedAction)action).getName());
            set.append(",");
        }
        set.setCharAt(set.length() - 1, '>');
        return set.toString();
    }
}

