/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.model.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import uk.ac.ed.inf.pepa.model.Aggregation;
import uk.ac.ed.inf.pepa.model.Process;
import uk.ac.ed.inf.pepa.model.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregationImpl
implements Aggregation {
    private HashMap<Process, Integer> subProcesses = new HashMap();
    private int copies = 0;

    public void add(Process process, int copies) {
        if (process == null || this.subProcesses.containsKey(process)) {
            throw new IllegalStateException("SubProcess null or already present");
        }
        if (copies == 0) {
            throw new IllegalStateException("Number of copies null");
        }
        this.subProcesses.put(process, copies);
        this.copies += copies;
    }

    @Override
    public int getCopies() {
        return this.copies;
    }

    @Override
    public Map<Process, Integer> getSubProcesses() {
        return Collections.unmodifiableMap(this.subProcesses);
    }

    @Override
    public void accept(Visitor v) {
        v.visitAggregation(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Aggregation)) {
            return false;
        }
        Map<Process, Integer> otherMap = ((Aggregation)o).getSubProcesses();
        for (Map.Entry<Process, Integer> entry : this.subProcesses.entrySet()) {
            if (otherMap.containsKey(entry.getKey()) && otherMap.get(entry.getKey()) == entry.getValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        for (Map.Entry<Process, Integer> entry : this.subProcesses.entrySet()) {
            hashCode += entry.getKey().hashCode() + entry.getValue().hashCode();
        }
        return hashCode;
    }

    @Override
    public String prettyPrint() {
        StringBuffer buf = new StringBuffer();
        HashMap<String, Process> names = new HashMap<String, Process>();
        ArrayList<String> toBeSorted = new ArrayList<String>();
        for (Process p : this.subProcesses.keySet()) {
            String s = p.prettyPrint();
            names.put(s, p);
            toBeSorted.add(s);
        }
        Collections.sort(toBeSorted);
        for (String name : toBeSorted) {
            int copies = this.subProcesses.get(names.get(name));
            buf.append(String.valueOf(name) + (copies > 1 ? "[" + copies + "]" : "") + ", ");
        }
        buf.deleteCharAt(buf.length() - 1);
        buf.deleteCharAt(buf.length() - 1);
        return buf.toString();
    }

    public void decreaseCopies(Process process, int copies) {
        if (copies < 0) {
            throw new IllegalStateException("Non negative value");
        }
        if (!this.subProcesses.containsKey(process)) {
            throw new IllegalStateException("No such process in aggregation " + process.prettyPrint());
        }
        Integer newValue = this.subProcesses.get(process) - copies;
        if (newValue < 0) {
            throw new IllegalStateException("Negative number of copies");
        }
        if (newValue == 0) {
            this.subProcesses.remove(process);
        } else {
            this.subProcesses.put(process, newValue);
        }
    }

    public void increaseCopies(Process process, int copies) {
        if (copies < 0) {
            throw new IllegalStateException("Non negative value");
        }
        if (!this.subProcesses.containsKey(process)) {
            this.add(process, copies);
        } else {
            Integer newValue = this.subProcesses.get(process) + copies;
            this.subProcesses.put(process, newValue);
        }
    }
}

