/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.model.internal;

import uk.ac.ed.inf.pepa.model.Action;
import uk.ac.ed.inf.pepa.model.ActionSet;
import uk.ac.ed.inf.pepa.model.Activity;
import uk.ac.ed.inf.pepa.model.Aggregation;
import uk.ac.ed.inf.pepa.model.Choice;
import uk.ac.ed.inf.pepa.model.Constant;
import uk.ac.ed.inf.pepa.model.Cooperation;
import uk.ac.ed.inf.pepa.model.FiniteRate;
import uk.ac.ed.inf.pepa.model.Hiding;
import uk.ac.ed.inf.pepa.model.Model;
import uk.ac.ed.inf.pepa.model.NamedAction;
import uk.ac.ed.inf.pepa.model.NamedRate;
import uk.ac.ed.inf.pepa.model.PassiveRate;
import uk.ac.ed.inf.pepa.model.Prefix;
import uk.ac.ed.inf.pepa.model.Process;
import uk.ac.ed.inf.pepa.model.Rate;
import uk.ac.ed.inf.pepa.model.SilentAction;
import uk.ac.ed.inf.pepa.model.internal.ActionSetImpl;
import uk.ac.ed.inf.pepa.model.internal.ActivityImpl;
import uk.ac.ed.inf.pepa.model.internal.AggregationImpl;
import uk.ac.ed.inf.pepa.model.internal.ChoiceImpl;
import uk.ac.ed.inf.pepa.model.internal.ConstantImpl;
import uk.ac.ed.inf.pepa.model.internal.CooperationImpl;
import uk.ac.ed.inf.pepa.model.internal.FiniteRateImpl;
import uk.ac.ed.inf.pepa.model.internal.HidingImpl;
import uk.ac.ed.inf.pepa.model.internal.ModelImpl;
import uk.ac.ed.inf.pepa.model.internal.NamedActionImpl;
import uk.ac.ed.inf.pepa.model.internal.NamedRateImpl;
import uk.ac.ed.inf.pepa.model.internal.PassiveRateImpl;
import uk.ac.ed.inf.pepa.model.internal.PrefixImpl;
import uk.ac.ed.inf.pepa.model.internal.SilentActionImpl;
import uk.ac.ed.inf.pepa.parsing.ModelNode;

public class DoMakePepaProcess {
    private static final DoMakePepaProcess INSTANCE = new DoMakePepaProcess();

    public static DoMakePepaProcess getInstance() {
        return INSTANCE;
    }

    public PassiveRate createPassiveRate(double weight) {
        PassiveRateImpl rate = new PassiveRateImpl();
        rate.setWeight(weight);
        return rate;
    }

    public FiniteRate createFiniteRate(double value) {
        FiniteRateImpl rate = new FiniteRateImpl();
        rate.setValue(value);
        return rate;
    }

    public NamedRate createNamedRate(String name, double value) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException();
        }
        NamedRateImpl rate = new NamedRateImpl();
        rate.setName(name);
        rate.setValue(value);
        return rate;
    }

    public Constant createConstant(String name) {
        ConstantImpl constant = new ConstantImpl();
        constant.setName(name);
        return constant;
    }

    public Model createModel(ModelNode modelNode) {
        if (modelNode == null) {
            throw new NullPointerException();
        }
        return new ModelImpl(modelNode);
    }

    public Activity createActivity(Action action, Rate rate) {
        ActivityImpl activity = new ActivityImpl();
        activity.setAction(action);
        activity.setRate(rate);
        return activity;
    }

    public NamedAction createNamedAction(String name) {
        NamedActionImpl action = new NamedActionImpl();
        action.setName(name);
        return action;
    }

    public SilentAction createSilentAction(NamedAction hiddenAction) {
        SilentActionImpl silentAction = new SilentActionImpl();
        silentAction.setHiddenAction(hiddenAction);
        return silentAction;
    }

    public Prefix createPrefix(Activity activity, Process destination) {
        PrefixImpl prefix = new PrefixImpl();
        prefix.setActivity(activity);
        prefix.setTargetProcess(destination);
        return prefix;
    }

    public Cooperation createCooperation(Process lhs, Process rhs, ActionSet actions2) {
        CooperationImpl cooperation = new CooperationImpl();
        cooperation.setLeftHandSide(lhs);
        cooperation.setRightHandSide(rhs);
        cooperation.setActionSet(actions2);
        return cooperation;
    }

    public Aggregation createAggregation() {
        return new AggregationImpl();
    }

    public Choice createChoice(Process lhs, Process rhs) {
        ChoiceImpl choice = new ChoiceImpl();
        choice.setLeftHandSide(lhs);
        choice.setRightHandSide(rhs);
        return choice;
    }

    public Hiding createHiding(Process hiddenProcess, ActionSet actionSet) {
        HidingImpl hiding = new HidingImpl();
        hiding.setActionSet(actionSet);
        hiding.setHiddenProcess(hiddenProcess);
        return hiding;
    }

    public ActionSet createActionSet() {
        return new ActionSetImpl();
    }
}

