/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ode;

import uk.ac.ed.inf.pepa.IProgressMonitor;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.largescale.IParametricDerivationGraph;
import uk.ac.ed.inf.pepa.ode.DifferentialAnalysisException;
import uk.ac.ed.inf.pepa.ode.IODESolver;
import uk.ac.ed.inf.pepa.ode.ISolutionRoutineCallback;
import uk.ac.ed.inf.pepa.ode.ODESolverFactory;

public class SteadyStateRoutine {
    private OptionMap map;
    private IParametricDerivationGraph graph;
    private double[] lastSolution;
    private double lastError;
    private double lastTimePoint;
    private IODESolver solver;

    public SteadyStateRoutine(OptionMap map, IParametricDerivationGraph graph) {
        if (map == null) {
            map = new OptionMap();
            map.put("ode.interpolation", "ode.interpolation.off");
        }
        if (map.get("ode.interpolation").equals("ode.interpolation.on")) {
            throw new IllegalArgumentException();
        }
        this.map = map;
        this.graph = graph;
    }

    public double getConvergenceNorm() {
        return this.lastError;
    }

    public double[] getSolution() {
        return this.lastSolution;
    }

    public double getTimePoint() {
        return this.lastTimePoint;
    }

    public void obtainSteadyState(final IProgressMonitor monitor) throws DifferentialAnalysisException, InterruptedException {
        final SteadyStateConvergenceCallback callback = new SteadyStateConvergenceCallback((Double)this.map.get("ode.steady-state.norm"), monitor);
        monitor.beginTask(-1);
        this.solver = ODESolverFactory.create(this.graph);
        try {
            try {
                this.solver.solve(this.map, callback, new IProgressMonitor(){

                    public void worked(int worked) {
                    }

                    public void setCanceled(boolean state) {
                    }

                    public boolean isCanceled() {
                        return monitor.isCanceled() || callback.hasConverged();
                    }

                    public void done() {
                    }

                    public void beginTask(int amount) {
                    }
                });
                if (!callback.hasConverged()) {
                    throw new DifferentialAnalysisException("Steady-state analysis not converged after t = " + this.lastTimePoint + ". Norm = " + this.lastError, 1);
                }
            }
            catch (InterruptedException e) {
                if (!callback.hasConverged()) {
                    throw e;
                }
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    class SteadyStateConvergenceCallback
    implements ISolutionRoutineCallback {
        private double convergenceRequired;
        private boolean hasConverged = false;
        private IProgressMonitor monitor;

        public SteadyStateConvergenceCallback(double convergenceNorm, IProgressMonitor internalMonitor) {
            this.convergenceRequired = convergenceNorm;
            this.monitor = internalMonitor;
        }

        public boolean hasConverged() {
            return this.hasConverged;
        }

        public void timePointComputed(double timePoint, double[] solution) throws DifferentialAnalysisException {
            SteadyStateRoutine.this.lastTimePoint = timePoint;
            if (SteadyStateRoutine.this.lastSolution == null) {
                SteadyStateRoutine.this.lastSolution = new double[solution.length];
                System.arraycopy(solution, 0, SteadyStateRoutine.this.lastSolution, 0, solution.length);
                return;
            }
            SteadyStateRoutine.this.lastError = this.computeDifference(SteadyStateRoutine.this.lastSolution, solution);
            System.arraycopy(solution, 0, SteadyStateRoutine.this.lastSolution, 0, solution.length);
            if (SteadyStateRoutine.this.lastError <= this.convergenceRequired) {
                this.hasConverged = true;
                this.monitor.setCanceled(true);
            }
            this.monitor.worked(1);
        }

        private double computeDifference(double[] lastSolution, double[] solution) {
            double normZero = 0.0;
            int i = 0;
            while (i < solution.length) {
                double compDifference = solution[i] - lastSolution[i];
                normZero += Math.abs(compDifference);
                ++i;
            }
            return normZero;
        }
    }
}

