/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ode.internal;

import java.util.Arrays;
import uk.ac.ed.inf.pepa.DoNothingMonitor;
import uk.ac.ed.inf.pepa.IProgressMonitor;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.largescale.IGeneratingFunction;
import uk.ac.ed.inf.pepa.largescale.IParametricDerivationGraph;
import uk.ac.ed.inf.pepa.largescale.expressions.EvaluatorVisitor;
import uk.ac.ed.inf.pepa.ode.DifferentialAnalysisException;
import uk.ac.ed.inf.pepa.ode.IODESolver;
import uk.ac.ed.inf.pepa.ode.ISolutionRoutineCallback;
import uk.ac.ed.inf.pepa.ode.internal.odetojava.DormandPrince;
import uk.ac.ed.inf.pepa.ode.internal.odetojava.Imex;
import uk.ac.ed.inf.pepa.ode.internal.odetojava.modules.Btableau;
import uk.ac.ed.inf.pepa.ode.internal.odetojava.modules.IWriterCallback;
import uk.ac.ed.inf.pepa.ode.internal.odetojava.modules.ODE;
import uk.ac.ed.inf.pepa.ode.internal.odetojava.modules.Span;

public class ODEtoJavaSolver
implements IODESolver {
    private IParametricDerivationGraph derivationGraph;
    private ODE ode;

    public ODEtoJavaSolver(final IParametricDerivationGraph derivationGraph) {
        this.derivationGraph = derivationGraph;
        this.ode = new ODE(){

            public double[] f(double t, double[] state) throws DifferentialAnalysisException {
                double[] results = new double[state.length];
                IGeneratingFunction[] iGeneratingFunctionArray = derivationGraph.getGeneratingFunctions();
                int n = iGeneratingFunctionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IGeneratingFunction f = iGeneratingFunctionArray[n2];
                    double result = new EvaluatorVisitor(f.getRate(), state).getResult();
                    int i = 0;
                    while (i < state.length) {
                        short jumpElement = f.getJump()[i];
                        int n3 = i++;
                        results[n3] = results[n3] + (double)jumpElement * result;
                    }
                    ++n2;
                }
                return results;
            }

            public double[] g(double arg0, double[] arg1) {
                double[] event = new double[1];
                return event;
            }
        };
    }

    public double[] evaluateVectorField(double t, double[] state) throws DifferentialAnalysisException {
        return this.ode.f(t, state);
    }

    public void solve(OptionMap map, final ISolutionRoutineCallback callback, IProgressMonitor monitor, double[] initialState) throws DifferentialAnalysisException, InterruptedException {
        if (callback == null) {
            throw new NullPointerException("Callback cannot be null");
        }
        if (initialState == null) {
            throw new NullPointerException("Initial state cannot be null");
        }
        if (map == null) {
            map = new OptionMap();
        }
        if (initialState.length != this.derivationGraph.getInitialState().length) {
            throw new IllegalArgumentException();
        }
        if (monitor == null) {
            monitor = new DoNothingMonitor();
        }
        final IProgressMonitor progressMonitor = monitor;
        final double startTime = (Double)map.get("ode.integration.start-time");
        final double stopTime = (Double)map.get("ode.integration.stop-time");
        double relativeTolerance = (Double)map.get("ode.integration.rtol");
        double absoluteTolerance = (Double)map.get("ode.integration.atol");
        double[] x = initialState;
        int n = x.length;
        double[] atol = new double[n];
        double[] rtol = new double[n];
        Arrays.fill(atol, absoluteTolerance);
        Arrays.fill(rtol, relativeTolerance);
        String fileName = "";
        String stiffnessDetection = "StiffDetect_Off";
        String eventLocation = "EventLoc_Off";
        String stats = "Stats_Off";
        String solver = (String)map.get("ode.solver");
        Span span = null;
        IWriterCallback writerCallback = new IWriterCallback(){
            private double lastTime;
            {
                this.lastTime = d;
            }

            public void closeFile() {
                progressMonitor.done();
            }

            public void openFile(String fileName, boolean append) {
                progressMonitor.beginTask(100);
            }

            public void openFile(String fileName) {
                progressMonitor.beginTask(100);
            }

            public void writeToFile(double t, double[] y) throws DifferentialAnalysisException {
                progressMonitor.worked((int)((t - this.lastTime) / (stopTime - startTime) * 100.0));
                this.lastTime = t;
                callback.timePointComputed(t, y);
            }

            public boolean isCanceled() {
                return progressMonitor.isCanceled();
            }
        };
        if (solver.equals("ode.dormand.prince")) {
            if (map.get("ode.interpolation").equals("ode.interpolation.on")) {
                int step = (Integer)map.get("ode.integration.step");
                double timestep = (stopTime - startTime) / (double)(step - 1);
                double[] times = new double[step];
                int i = 0;
                while (i < times.length) {
                    times[i] = startTime + (double)i * timestep;
                    ++i;
                }
                span = new Span(times);
            } else {
                span = new Span(startTime, stopTime);
            }
            double initialStepSize = -1.0;
            DormandPrince.dormand_prince(this.ode, span, x, initialStepSize, atol, rtol, fileName, stiffnessDetection, eventLocation, stats, writerCallback);
        } else {
            span = new Span(startTime, stopTime);
            double initialStepSize = 1.0E-6;
            int step = (Integer)map.get("ode.integration.step");
            Imex.imex(this.ode, span, x, initialStepSize, new Btableau("imex443"), fileName, stats, step, writerCallback);
        }
    }

    public void solve(OptionMap map, ISolutionRoutineCallback callback, IProgressMonitor monitor) throws DifferentialAnalysisException, InterruptedException {
        this.solve(map, callback, monitor, this.derivationGraph.getInitialState());
    }
}

