/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ode.internal.odetojava.modules;

public class Span {
    private double t0;
    private double tf;
    private double[] times;
    private boolean proper;

    public Span(double a, double b) {
        this.t0 = a;
        this.tf = b;
        this.proper = this.tf > this.t0;
    }

    public Span(double a, double b, double inc) {
        this.t0 = a;
        this.tf = b;
        if (this.tf > this.t0 && inc > 0.0) {
            double intervalSize = this.tf - this.t0;
            double arraySizeD = intervalSize / inc;
            int arraySize = (int)Math.floor(arraySizeD);
            this.times = new double[arraySize += 2];
            double accum = this.t0;
            int i = 0;
            while (i < this.times.length - 1) {
                this.times[i] = accum;
                accum += inc;
                ++i;
            }
            this.times[this.times.length - 1] = this.tf;
            this.proper = true;
            i = 0;
            while (i < this.times.length - 1) {
                if (this.times[i] >= this.times[i + 1]) {
                    this.proper = false;
                }
                ++i;
            }
        } else {
            this.proper = false;
        }
    }

    public Span(double[] times) {
        this.times = new double[times.length];
        int i = 0;
        while (i < times.length) {
            this.times[i] = times[i];
            ++i;
        }
        this.t0 = times[0];
        this.tf = times[times.length - 1];
        this.proper = true;
        i = 0;
        while (i < times.length - 1) {
            if (times[i] >= times[i + 1]) {
                this.proper = false;
            }
            ++i;
        }
    }

    public double get_t0() {
        return this.t0;
    }

    public double get_tf() {
        return this.tf;
    }

    public double[] get_times() {
        return this.times;
    }

    public int get_timesLength() {
        if (this.times == null) {
            return 0;
        }
        return this.times.length;
    }

    public boolean get_property() {
        return this.proper;
    }
}

