/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ode.internal.odetojava.ssCtrlModules;

import Jama.Matrix;
import uk.ac.ed.inf.pepa.ode.DifferentialAnalysisException;
import uk.ac.ed.inf.pepa.ode.internal.odetojava.modules.Btableau;
import uk.ac.ed.inf.pepa.ode.internal.odetojava.modules.ODE;
import uk.ac.ed.inf.pepa.ode.internal.odetojava.modules.StdMet;

public class Imex1S {
    private int s;
    private double[][] a;
    private double[] b;
    private double[][] ahat;
    private double[] bhat;
    private ODE f;
    private double t;
    private double h;
    private int n;
    private double[] uold;
    private double[] unew;
    private double[][] jacobian;
    private double[][] I;
    private double[][] k;
    private double[][] khat;
    private final double deltaMin = 1.0E-4;
    private final double deltaY = Math.sqrt(1.0E-4);

    public Imex1S(Btableau butcher) {
        this.s = butcher.getbl();
        this.a = new double[butcher.getah()][butcher.getal()];
        this.b = new double[butcher.getbl()];
        this.ahat = new double[butcher.getahath()][butcher.getahatl()];
        this.bhat = new double[butcher.getbhatl()];
        StdMet.matrixcpy(this.a, butcher.get_a());
        StdMet.arraycpy(this.b, butcher.get_b());
        StdMet.matrixcpy(this.ahat, butcher.get_ahat());
        StdMet.arraycpy(this.bhat, butcher.get_bhat());
    }

    public double[] doOneStep(ODE function, double t, double[] u, double h) throws DifferentialAnalysisException {
        this.t = t;
        this.h = h;
        this.n = u.length;
        this.f = function;
        this.uold = new double[this.n];
        this.unew = new double[this.n];
        this.jacobian = new double[this.n][this.n];
        this.I = new double[this.n][this.n];
        int i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < this.n) {
                if (i == j) {
                    this.I[i][j] = 1.0;
                }
                ++j;
            }
            ++i;
        }
        double[] f1 = new double[this.n];
        double[] f2 = new double[this.n];
        double[] yTemp = new double[this.n];
        double[] ad1 = new double[this.n];
        double[] stam1 = new double[this.n];
        double[] stam2 = new double[this.n];
        double[] as1 = new double[this.n];
        double[] mtam1 = new double[this.n];
        double[] fn = new double[this.n];
        double[] g = new double[this.n];
        double[] temp = new double[this.n];
        double[] a1 = new double[this.n];
        double[][] m1 = new double[this.n][this.n];
        double[][] m2 = new double[this.n][1];
        StdMet.arraycpy(this.uold, u);
        f1 = this.f.f(t, this.uold);
        int i2 = 0;
        while (i2 < this.n) {
            double deltaX = this.deltaY * Math.abs(this.uold[i2]);
            if (deltaX < 1.0E-4) {
                deltaX = 1.0E-4;
            }
            StdMet.arraycpy(yTemp, this.uold);
            int n = i2;
            yTemp[n] = yTemp[n] + deltaX;
            f2 = this.f.f(t, yTemp);
            StdMet.arraydiff(ad1, f2, f1);
            StdMet.stam(stam1, 1.0 / deltaX, ad1);
            int j = 0;
            while (j < this.n) {
                this.jacobian[j][i2] = stam1[j];
                ++j;
            }
            ++i2;
        }
        this.k = new double[this.s][this.n];
        this.khat = new double[this.s + 1][this.n];
        f1 = this.f.f(t, this.uold);
        StdMet.mtam(g, this.jacobian, this.uold);
        StdMet.arraydiff(fn, f1, g);
        StdMet.arraycpy(this.khat[0], fn);
        i2 = 0;
        while (i2 < this.s) {
            StdMet.zero_out(temp);
            int j = 0;
            while (j < i2) {
                StdMet.stam(stam1, this.a[i2][j], this.k[j]);
                StdMet.stam(stam2, this.ahat[i2 + 1][j], this.khat[j]);
                StdMet.arraysum(as1, stam1, stam2);
                StdMet.arraysum(temp, temp, as1);
                ++j;
            }
            StdMet.stam(stam1, this.ahat[i2 + 1][i2], this.khat[i2]);
            StdMet.arraysum(temp, temp, stam1);
            StdMet.stam(temp, h, temp);
            StdMet.arraysum(temp, temp, this.uold);
            j = 0;
            while (j < this.n) {
                StdMet.stam(stam1, h * this.a[i2][i2], this.jacobian[j]);
                StdMet.arraycpy(m1[j], stam1);
                ++j;
            }
            j = 0;
            while (j < this.n) {
                StdMet.arraydiff(m1[j], this.I[j], m1[j]);
                ++j;
            }
            StdMet.mtam(mtam1, this.jacobian, temp);
            Matrix A = new Matrix(m1);
            int j2 = 0;
            while (j2 < this.n) {
                m2[j2][0] = mtam1[j2];
                ++j2;
            }
            Matrix B = new Matrix(m2);
            Matrix X = A.solve(B);
            a1 = X.getColumnPackedCopy();
            StdMet.arraycpy(this.k[i2], a1);
            StdMet.stam(stam1, h * this.a[i2][i2], this.k[i2]);
            StdMet.arraysum(temp, temp, stam1);
            f1 = this.f.f(t, temp);
            StdMet.mtam(g, this.jacobian, temp);
            StdMet.arraydiff(fn, f1, g);
            StdMet.arraycpy(this.khat[i2 + 1], fn);
            ++i2;
        }
        StdMet.zero_out(temp);
        i2 = 0;
        while (i2 < this.s) {
            StdMet.stam(stam1, this.b[i2], this.k[i2]);
            StdMet.stam(stam2, this.bhat[i2], this.khat[i2]);
            StdMet.arraysum(as1, stam1, stam2);
            StdMet.arraysum(temp, temp, as1);
            ++i2;
        }
        StdMet.stam(stam1, this.bhat[this.s], this.khat[this.s]);
        StdMet.arraysum(temp, temp, stam1);
        StdMet.stam(temp, h, temp);
        StdMet.arraysum(this.unew, this.uold, temp);
        return this.unew;
    }
}

